/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.editors;

import com.spacekiller.util.beans.editors.PaintCustomEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;

public class PaintPropertyEditor
extends PropertyEditorSupport {
    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        Object value = this.getValue();
        if (value != null && value instanceof Paint) {
            Paint paint = (Paint)value;
            if (gfx instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)gfx;
                g2d.setPaint(paint);
                g2d.fillRect(box.x, box.y, box.width, box.height);
            } else if (paint instanceof Color) {
                Color col = (Color)paint;
                gfx.setColor(col);
                gfx.fillRect(box.x, box.y, box.width, box.height);
            }
        }
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        PaintCustomEditor editor = new PaintCustomEditor();
        Object value = this.getValue();
        if (value != null && value instanceof Paint) {
            editor.setPaint((Paint)value);
        }
        editor.setEditor(this);
        return editor;
    }
}

