/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.editors;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.Platform;
import com.spacekiller.util.beans.BeanEditor;
import com.spacekiller.util.beans.editors.AbstractPropertyFeatureEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.beancontext.BeanContext;
import javax.swing.Icon;
import javax.swing.JLabel;

public class ReferencePropertyEditor
extends AbstractPropertyFeatureEditor
implements BeanEditor {
    private Object bean;
    private BeanContext beanContextOfBean;
    private BeansToolkit beansToolkit;

    @Override
    public String getAsText() {
        Object value = this.getValue();
        return String.valueOf(value);
    }

    public Object getBean() {
        return this.bean;
    }

    public BeanContext getBeanContextOfBean() {
        return this.beanContextOfBean;
    }

    @Override
    public Component getCustomEditor() {
        return new JLabel("TODO: " + this.getClass().getName());
    }

    @Override
    public String getJavaInitializationString() {
        Object value = this.getValue();
        Class refType = this.getReferenceType();
        if (refType == null || value == null) {
            return "null";
        }
        return "reference to (" + refType.getName() + ")" + value + " {<not currently supported>}";
    }

    protected Class getReferenceType() {
        FeatureDescriptor feature = this.getFeatureDescriptor();
        if (feature != null && feature instanceof PropertyDescriptor) {
            PropertyDescriptor property = (PropertyDescriptor)feature;
            return property.getPropertyType();
        }
        return null;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            this.setValue(null);
            return;
        }
        throw new IllegalArgumentException("Cannot get reference from text: " + text);
    }

    public void setBean(Object newBean) {
        this.bean = newBean;
    }

    public void setBeanContextOfBean(BeanContext newBeanContextOfBean) {
        this.beanContextOfBean = newBeanContextOfBean;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        BeansToolkit btk = this.beansToolkit;
        String text = null;
        Icon icon = null;
        Object bean = this.bean;
        if (bean == null) {
            text = "";
            icon = null;
        } else {
            text = String.valueOf(bean);
            icon = btk.getIcon(bean);
        }
        int x = box.x;
        int y = box.y;
        if (icon != null) {
            icon.paintIcon(null, gfx, x, y);
            x += icon.getIconWidth() + 5;
        }
        int asc = gfx.getFontMetrics().getAscent();
        gfx.setColor(Color.white);
        gfx.drawString(text, x, y + asc);
        gfx.setColor(Color.black);
        gfx.drawString(text, x + 1, y + asc + 1);
    }

    @Override
    public BeansToolkit getBeansToolkit() {
        if (this.beansToolkit == null) {
            this.setBeansToolkit(Platform.getInstance().getBeansToolkit());
        }
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
    }

    @Override
    public Object getValue() {
        return this.bean;
    }

    @Override
    public void setValue(Object value) {
        this.bean = value;
    }
}

