/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.model;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.BeanProperty;
import com.spacekiller.util.beans.model.BeanModel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBeanModel
implements BeanModel,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(AbstractBeanModel.class.getName());
    private BeansToolkit toolkit;
    private Vector beans = new Vector();
    private Vector contexts = new Vector();

    public AbstractBeanModel(BeansToolkit tk) {
        this.setToolkit(tk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBean(Object bean) {
        Vector vector = this.beans;
        synchronized (vector) {
            this.insertBeanAt(bean, this.getBeanCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            this.removeAllBeans();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected abstract void fireBeansDeleted(int var1, int var2);

    protected abstract void fireBeansInserted(int var1, int var2);

    protected abstract void fireBeansUpdated(int var1, int var2);

    @Override
    public Object getBeanAt(int row) {
        return this.beans.get(row);
    }

    @Override
    public BeanContext getBeanContextOfBeanAt(int index) {
        BeanContext bc = (BeanContext)this.contexts.get(index);
        if (bc != null) {
            return bc;
        }
        Object bean = this.getBeanAt(index);
        if (bean == null) {
            return null;
        }
        if (bean instanceof BeanContextChild) {
            BeanContextChild bcc = (BeanContextChild)bean;
            return bcc.getBeanContext();
        }
        return null;
    }

    @Override
    public int getBeanCount() {
        return this.beans.size();
    }

    @Override
    public int getBeanIndex(Object bean) {
        return this.getBeanIndex(bean, 0);
    }

    @Override
    public int getBeanIndex(Object bean, int fromIndex) {
        return this.beans.indexOf(bean, fromIndex);
    }

    public BeansToolkit getToolkit() {
        return this.toolkit;
    }

    protected Object getValue(int index, PropertyDescriptor property) {
        if (property == null) {
            return null;
        }
        Object bean = null;
        try {
            bean = this.getBeanAt(index);
            if (bean == null) {
                return null;
            }
            if (property.getReadMethod() == null) {
                return null;
            }
            return this.toolkit.getValue(property, bean);
        }
        catch (IllegalArgumentException e) {
            Class<?> clazz = bean == null ? null : bean.getClass();
            String clazzName = clazz == null ? "null" : clazz.getName();
            logger.fine("Warning: Invalid property access: property=" + property.getName() + " class=" + clazzName);
            return null;
        }
        catch (Throwable e) {
            this.handleException(e);
            return null;
        }
    }

    protected void handleException(Throwable e) {
        logger.log(Level.WARNING, e.getMessage(), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertBeanAt(Object bean, int i) {
        Vector vector = this.beans;
        synchronized (vector) {
            this.beans.insertElementAt(bean, i);
            this.contexts.insertElementAt(null, i);
            this.fireBeansInserted(i, i);
            if (bean != null) {
                BeanProperty.installPropertyChangeListener((Object)bean, (PropertyChangeListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllBeans() {
        Vector vector = this.beans;
        synchronized (vector) {
            int count = this.getBeanCount();
            for (int c = count - 1; c >= 0; --c) {
                Object bean = this.getBeanAt(c);
                this.beans.removeElementAt(c);
                this.contexts.removeElementAt(c);
                if (bean == null) continue;
                BeanProperty.uninstallPropertyChangeListener((Object)bean, (PropertyChangeListener)this);
            }
            this.fireBeansDeleted(0, count - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBean(Object bean) {
        Vector vector = this.beans;
        synchronized (vector) {
            int i = this.getBeanIndex(bean);
            if (i < 0) {
                return;
            }
            this.removeBeanAt(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBeanAt(int index) {
        Vector vector = this.beans;
        synchronized (vector) {
            Object bean = this.getBeanAt(index);
            this.beans.removeElementAt(index);
            this.contexts.removeElementAt(index);
            if (bean != null) {
                BeanProperty.uninstallPropertyChangeListener((Object)bean, (PropertyChangeListener)this);
            }
            this.fireBeansDeleted(index, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBeanAt(Object bean, int index) {
        Vector vector = this.beans;
        synchronized (vector) {
            Object old = this.getBeanAt(index);
            if (old != null) {
                BeanProperty.uninstallPropertyChangeListener((Object)old, (PropertyChangeListener)this);
            }
            this.beans.setElementAt(bean, index);
            if (bean != null) {
                BeanProperty.installPropertyChangeListener((Object)bean, (PropertyChangeListener)this);
            }
            this.fireBeansUpdated(index, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBeanContextOfBeanAt(BeanContext bc, int index) {
        Vector vector = this.beans;
        synchronized (vector) {
            this.contexts.set(index, bc);
        }
    }

    private void setToolkit(BeansToolkit newToolkit) {
        this.toolkit = newToolkit;
    }

    protected boolean setValue(int index, PropertyDescriptor property, Object value) {
        try {
            Object bean = this.getBeanAt(index);
            if (bean == null) {
                return false;
            }
            this.toolkit.setValue(property, bean, value);
            return true;
        }
        catch (Throwable e) {
            this.handleException(e);
            return false;
        }
    }
}

