/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans.model;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.components.DefaultFeatureHeaderRenderer;
import com.spacekiller.util.beans.model.DefaultPropertyTableModel;
import java.beans.PropertyDescriptor;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CascadingPropertyTableModel
extends DefaultPropertyTableModel {
    public CascadingPropertyTableModel(BeansToolkit tk) {
        super(tk);
    }

    @Override
    protected TableColumn createTableColumn(int modelIndex, TableCellRenderer renderer, TableCellEditor editor, DefaultFeatureHeaderRenderer headerRenderer) throws Exception {
        TableColumn column = super.createTableColumn(modelIndex, renderer, editor, headerRenderer);
        Object value = null;
        int num = this.getBeanCount();
        value = num < 1 ? "No bean selected" : (num == 1 ? this.getBeanAt(0) : "" + num + " beans");
        column.setHeaderValue(value);
        return column;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return "Value";
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object o;
        PropertyDescriptor descr = this.getPropertyDescriptorAt(row);
        if (descr == null) {
            return null;
        }
        int beanIndex = col;
        if (beanIndex < 0) {
            return descr;
        }
        if (beanIndex > 0) {
            return null;
        }
        Object value = null;
        int count = this.getBeanCount();
        if (count > 20) {
            count = 20;
        }
        for (int c = 0; c < count && ((o = this.getValue(c, descr)) == value || c <= 0 || value == null); ++c) {
            value = o;
        }
        return value;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        PropertyDescriptor descr = this.getPropertyDescriptorAt(row);
        if (descr == null) {
            return;
        }
        int beanIndex = col;
        if (beanIndex != 0) {
            return;
        }
        int count = this.getBeanCount();
        for (int c = 0; c < count; ++c) {
            this.setValue(c, descr, value);
        }
        this.fireTableCellUpdated(row, col);
    }
}

