/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.mspinky;

import com.waxmonster.timecode.AbstractTimecodeFormat;
import com.waxmonster.timecode.TimecodeDecoder;
import com.waxmonster.timecode.common.AbstractTimecodeDecoder;
import com.waxmonster.timecode.mspinky.MPVTTimecodeDecoder;
import com.waxmonster.timecode.mspinky.MPWrapperTimecodeDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractMsPinkyTimecodeFormat
extends AbstractTimecodeFormat {
    private static final Logger logger = Logger.getLogger(AbstractMsPinkyTimecodeFormat.class.getName());
    private int generation = 3;

    public AbstractMsPinkyTimecodeFormat() {
    }

    public AbstractMsPinkyTimecodeFormat(int generation) {
        this.setName("MsPinky#" + generation);
        this.setTitle("MsPinky#" + generation);
        this.generation = generation;
    }

    public int getBits() {
        return -1;
    }

    public boolean isScratchModeSupported(int scratchMode) {
        switch (scratchMode) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
        }
        return false;
    }

    public boolean isMidiDecoderSupported() {
        return false;
    }

    public boolean isAudioDecoderSupported() {
        return true;
    }

    public TimecodeDecoder createDecoder(float inputRate, int inputBufFrames, float outputRate, int outputBufFrames, double[] outputBuffer) throws IllegalArgumentException {
        String osName;
        if (outputRate != inputRate) {
            throw new IllegalArgumentException("Unsupported/Incompatible frame rates: outputRate=" + outputRate + ", inputRate=" + inputRate);
        }
        if (outputBufFrames != inputBufFrames) {
            throw new IllegalArgumentException("Unsupported/Incompatible buffer frames: outputBufFrames=" + outputBufFrames + ", inputBufFrames=" + inputBufFrames);
        }
        double sharpness = -1.0;
        double threshold = 0.0;
        AbstractTimecodeDecoder decoder = null;
        int scratchMode = 1;
        if (decoder == null && (osName = System.getProperty("os.name")) != null && osName.toLowerCase().startsWith("windows")) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Trying to create MPWrapperTimecodeDecoder...");
            }
            try {
                decoder = new MPWrapperTimecodeDecoder(this, inputRate, inputBufFrames, outputBuffer, this.generation, scratchMode, sharpness, threshold);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (decoder == null) {
            // empty if block
        }
        if (decoder == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Trying to create MPVTTimecodeDecoder...");
            }
            try {
                decoder = new MPVTTimecodeDecoder(this, inputRate, inputBufFrames, outputBuffer, this.generation, scratchMode, sharpness, threshold);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (decoder == null) {
            throw new RuntimeException("Unable to create MsPinky-TimecodeDecoder! See previous error messages.");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("TimecodeDecoder created: " + decoder);
        }
        return decoder;
    }

    public int getGeneration() {
        return this.generation;
    }

    protected void setGeneration(int generation) {
        this.generation = generation;
    }
}

