/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.mspinky;

import com.spacekiller.util.sound.SampleBuffer;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.NativeLongByReference;
import com.waxmonster.timecode.TimecodeFormat;
import com.waxmonster.timecode.common.AbstractTimecodeDecoder;
import com.waxmonster.timecode.mspinky.AbstractMsPinkyTimecodeFormat;
import com.waxmonster.timecode.mspinky.MPVTLibrary;
import com.waxmonster.timecode.mspinky.MsPinkyConst;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MPVTTimecodeDecoder
extends AbstractTimecodeDecoder
implements MsPinkyConst {
    private static final Logger logger = Logger.getLogger(MPVTTimecodeDecoder.class.getName());
    private final AbstractMsPinkyTimecodeFormat format;
    private final float frameRate;
    private final FloatBuffer bufLeft;
    private final FloatBuffer bufRight;
    private final int bufLen;
    private final NativeLong samps;
    private final NativeLong measurements;
    private final NativeLongByReference measurements_ref;
    private final DoubleBuffer velocity;
    private final DoubleBuffer power;
    private final DoubleBuffer position;
    private double pos;
    private final double[] values;
    private double relFactor;
    private MPVTLibrary mpvtLibrary;
    private Pointer mpvtPointer;
    private volatile int srt;
    private volatile int cnt;
    private int mode;

    public MPVTTimecodeDecoder(AbstractMsPinkyTimecodeFormat format, float frameRate, int maxBufferFrames, double[] outputBuffer, int generation, int mode, double sharpness, double threshold) {
        int bufMeasures;
        int pinkyFrames;
        boolean checkBufferSize;
        this.format = format;
        this.frameRate = frameRate;
        boolean absoluteMode = mode == 2;
        this.mode = absoluteMode ? 2 : 1;
        this.bufLen = maxBufferFrames;
        this.bufLeft = this.allocateFloatBuffer(this.bufLen);
        this.bufRight = this.allocateFloatBuffer(this.bufLen);
        this.samps = new NativeLong();
        int measurements = this.bufLen / 32 + 1;
        this.measurements = new NativeLong((long)measurements);
        this.measurements_ref = new NativeLongByReference(this.measurements);
        this.velocity = this.allocateDoubleBuffer(measurements);
        this.power = this.allocateDoubleBuffer(measurements);
        this.position = this.allocateDoubleBuffer(measurements);
        this.values = outputBuffer;
        this.pos = 0.0;
        this.relFactor = 1000.0 / (double)frameRate;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Mode: " + (absoluteMode ? "Absolute" : "Relative"));
            logger.finer("Generation: #" + generation);
            logger.finer("CutoffSharpness: " + sharpness);
            logger.finer("SignalPowerTreshold: " + threshold);
        }
        this.mpvtLibrary = MPVTLibrary.INSTANCE;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("MPVT Library: " + this.mpvtLibrary);
        }
        this.mpvtPointer = this.mpvtLibrary.MPVT_CreateNew(this.bufLen, frameRate);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("MPVT Object created: " + this.mpvtPointer);
        }
        this.mpvtLibrary.MPVT_SetVinylGeneration(this.mpvtPointer, new NativeLong((long)generation));
        this.mpvtLibrary.MPVT_SetAbsoluteMode(this.mpvtPointer, absoluteMode ? (byte)1 : 0);
        if (sharpness >= 0.0) {
            this.mpvtLibrary.MPVT_SetCutoffSharpness(this.mpvtPointer, sharpness);
        }
        if (threshold < 0.0) {
            this.mpvtLibrary.MPVT_SetSignalPowerThreshold(this.mpvtPointer, threshold);
        }
        if ((checkBufferSize = true) && (pinkyFrames = (bufMeasures = this.bufLen / 32) * 32) < this.bufLen) {
            int leadInFrames = this.bufLen - pinkyFrames;
            logger.info("Lead-in frames required: bufLen=" + this.bufLen + ", pinkyFrames=" + pinkyFrames + ", leadInFrames=" + leadInFrames);
            int max = 0;
            this.bufLeft.rewind();
            this.bufRight.rewind();
            this.velocity.rewind();
            this.power.rewind();
            this.position.rewind();
            this.samps.setValue((long)leadInFrames);
            this.mpvtLibrary.MPVT_ProcessBuffer(this.mpvtPointer, this.bufLeft, this.bufRight, this.samps, this.velocity, this.power, this.position, this.measurements_ref);
            int num = this.measurements.intValue();
            if (num != max) {
                logger.warning("Unexpected Lead-in measurements: " + num + " != " + max);
            }
        }
    }

    public TimecodeFormat getFormat() {
        return this.format;
    }

    protected FloatBuffer allocateFloatBuffer(int len) {
        ByteBuffer bb = ByteBuffer.allocateDirect(len * 4);
        bb.order(ByteOrder.nativeOrder());
        return bb.asFloatBuffer();
    }

    protected DoubleBuffer allocateDoubleBuffer(int len) {
        ByteBuffer bb = ByteBuffer.allocateDirect(len * 8);
        bb.order(ByteOrder.nativeOrder());
        return bb.asDoubleBuffer();
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public synchronized void close() {
        if (this.mpvtPointer == null) {
            return;
        }
        String info = this.mpvtPointer.toString();
        this.mpvtLibrary.MPVT_Destruct(this.mpvtPointer);
        this.mpvtPointer = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("MPVT object closed: " + info);
        }
    }

    public boolean isAudioDecoder() {
        return true;
    }

    public boolean isMidiDecoder() {
        return false;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        if (!this.isModeSupported(mode)) {
            return;
        }
        this.mode = mode;
    }

    public boolean isModeSupported(int mode) {
        switch (mode) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
        }
        return false;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void handle(long time, int status, int data1, int data2) {
        throw new UnsupportedOperationException("MIDI timecode not supported: " + this);
    }

    public void decode(long time, double[] buf, int off, int len) {
        int n = len / 2;
        for (int i = 0; i < n; ++i) {
            this.bufLeft.put((float)buf[off++]);
            this.bufRight.put((float)buf[off++]);
        }
        this.decode(n);
    }

    public void decode(long time, SampleBuffer buf, int off, int len) {
        int n = len / 2;
        for (int i = 0; i < n; ++i) {
            this.bufLeft.put(buf.getFloat(off++));
            this.bufRight.put(buf.getFloat(off++));
        }
        this.decode(n);
    }

    protected void decode(int frames) {
        int o = this.cnt;
        if (o > 0) {
            System.arraycopy(this.values, this.srt, this.values, 0, o);
        }
        this.bufLeft.rewind();
        this.bufRight.rewind();
        this.velocity.rewind();
        this.power.rewind();
        this.position.rewind();
        this.samps.setValue((long)frames);
        this.mpvtLibrary.MPVT_ProcessBuffer(this.mpvtPointer, this.bufLeft, this.bufRight, this.samps, this.velocity, this.power, this.position, this.measurements_ref);
        int num = this.measurements.intValue();
        double x = this.pos;
        for (int i = 0; i < num; ++i) {
            double v = this.velocity.get() * this.relFactor;
            for (int k = 0; k < 32; ++k) {
                this.values[o++] = x;
                x += v;
            }
        }
        if (o < frames) {
            logger.warning("Unexpected number of frames: " + o + " < " + frames + " (measurements=" + num + ")");
            throw new IllegalStateException("Unexpected number of frames: " + o + " < " + frames + " (measurements=" + num + ")");
        }
        this.pos = x;
        this.srt = frames;
        this.cnt = o - frames;
    }

    public void produce(long time, int frames) {
    }
}

