/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.mspinky;

import be.kotuha.pinkywrapper.MsPinkyWrapper;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.timecode.TimecodeFormat;
import com.waxmonster.timecode.common.AbstractTimecodeDecoder;
import com.waxmonster.timecode.mspinky.AbstractMsPinkyTimecodeFormat;
import com.waxmonster.timecode.mspinky.MsPinkyConst;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MPWrapperTimecodeDecoder
extends AbstractTimecodeDecoder
implements MsPinkyConst {
    private static final Logger logger = Logger.getLogger(MPWrapperTimecodeDecoder.class.getName());
    private final AbstractMsPinkyTimecodeFormat format;
    private final float frameRate;
    private final float[] bufLeft;
    private final float[] bufRight;
    private final int bufLen;
    private final int measurements;
    private final double[] velocity;
    private final double[] power;
    private final double[] position;
    private final double[] values;
    private final double relFactor;
    private MsPinkyWrapper wrapper;
    private volatile double pos;
    private volatile int srt;
    private volatile int cnt;
    private int mode;

    public MPWrapperTimecodeDecoder(AbstractMsPinkyTimecodeFormat format, float frameRate, int maxBufferFrames, double[] outputBuffer, int generation, int mode, double sharpness, double threshold) {
        int bufMeasures;
        int pinkyFrames;
        boolean checkBufferSize;
        this.format = format;
        this.frameRate = frameRate;
        boolean absoluteMode = mode == 2;
        this.mode = absoluteMode ? 2 : 1;
        this.bufLen = maxBufferFrames;
        this.bufLeft = new float[this.bufLen];
        this.bufRight = new float[this.bufLen];
        this.measurements = this.bufLen / 32 + 1;
        this.velocity = new double[this.measurements];
        this.power = new double[this.measurements];
        this.position = new double[this.measurements];
        this.values = outputBuffer;
        this.pos = 0.0;
        this.relFactor = 1000.0 / (double)frameRate;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Creating MsPinky wrapper: bufferSize=" + this.bufLen + ", sampleRate=" + frameRate);
        }
        this.wrapper = new MsPinkyWrapper(this.bufLen, (double)frameRate);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("MsPinky wrapper created: " + this.wrapper);
        }
        this.wrapper.init();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("MsPinky wrapper initialized: " + this.wrapper);
        }
        this.wrapper.setGeneration(generation);
        this.wrapper.setAbsoluteMode(absoluteMode);
        if (sharpness >= 0.0) {
            this.wrapper.setCutoffSharpness(sharpness);
        }
        if (threshold < 0.0) {
            this.wrapper.setSignalPowerTreshold(threshold);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Mode: " + (this.wrapper.isAbsoluteMode() ? "Absolute" : "Relative"));
            logger.finer("Generation: #" + this.wrapper.getGeneration() + " = " + this.wrapper.getGenerationString());
            logger.finer("CutoffSharpness: " + this.wrapper.getCutoffSharpness());
            logger.finer("SignalPowerTreshold: " + this.wrapper.getSignalPowerTreshold());
        }
        if ((checkBufferSize = true) && (pinkyFrames = (bufMeasures = this.bufLen / 32) * 32) < this.bufLen) {
            int leadInFrames = this.bufLen - pinkyFrames;
            logger.info("Lead-in frames required: bufLen=" + this.bufLen + ", pinkyFrames=" + pinkyFrames + ", leadInFrames=" + leadInFrames);
            int max = 0;
            int num = this.wrapper.processBuffer(this.bufLeft, this.bufRight, leadInFrames, this.velocity, this.power, this.position, max);
            if (num != max) {
                logger.warning("Unexpected Lead-in measurements: " + num + " != " + max);
            }
        }
    }

    public TimecodeFormat getFormat() {
        return this.format;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.wrapper == null) {
            return;
        }
        MPWrapperTimecodeDecoder mPWrapperTimecodeDecoder = this;
        synchronized (mPWrapperTimecodeDecoder) {
            if (this.wrapper == null) {
                return;
            }
            try {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Closing MsPinky wrapper: " + this.wrapper);
                }
                this.wrapper.close();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("MsPinky wrapper closed: " + this.wrapper);
                }
            }
            finally {
                this.wrapper = null;
            }
        }
    }

    public boolean isAudioDecoder() {
        return true;
    }

    public boolean isMidiDecoder() {
        return false;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        if (!this.isModeSupported(mode)) {
            return;
        }
        this.mode = mode;
    }

    public boolean isModeSupported(int mode) {
        switch (mode) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
        }
        return false;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void handle(long time, int status, int data1, int data2) {
        throw new UnsupportedOperationException("MIDI timecode not supported: " + this);
    }

    public void decode(long time, double[] buf, int off, int len) {
        int n = len / 2;
        for (int i = 0; i < n; ++i) {
            this.bufLeft[i] = (float)buf[off++];
            this.bufRight[i] = (float)buf[off++];
        }
        this.decode(n);
    }

    public void decode(long time, SampleBuffer buf, int off, int len) {
        int n = len / 2;
        for (int i = 0; i < n; ++i) {
            this.bufLeft[i] = buf.getFloat(off++);
            this.bufRight[i] = buf.getFloat(off++);
        }
        this.decode(n);
    }

    protected void decode(int frames) {
        int o = this.cnt;
        if (o > 0) {
            System.arraycopy(this.values, this.srt, this.values, 0, o);
        }
        int num = this.wrapper.processBuffer(this.bufLeft, this.bufRight, frames, this.velocity, this.power, this.position, this.measurements);
        double x = this.pos;
        for (int i = 0; i < num; ++i) {
            double v = this.velocity[i] * this.relFactor;
            for (int k = 0; k < 32; ++k) {
                this.values[o++] = x;
                x += v;
            }
        }
        if (o < frames) {
            logger.warning("Unexpected number of frames: " + o + " < " + frames + " (measurements=" + num + ")");
            throw new IllegalStateException("Unexpected number of frames: " + o + " < " + frames + " (measurements=" + num + ")");
        }
        this.pos = x;
        this.srt = frames;
        this.cnt = o - frames;
    }

    public void produce(long time, int frames) {
    }
}

