/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DecHexBinPanel
extends JPanel {
    private static final long serialVersionUID = 9108150381288094094L;
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private long value;
    private int bits;
    private int columns;
    private boolean refreshing;
    private JTextField textFieldDec;
    private JTextField textFieldHex;
    private JTextField textFieldBin;

    public DecHexBinPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblDec = new JLabel("Dec:");
        lblDec.setToolTipText("Decimal");
        GridBagConstraints gbc_lblDec = new GridBagConstraints();
        gbc_lblDec.anchor = 17;
        gbc_lblDec.insets = new Insets(0, 0, 5, 5);
        gbc_lblDec.gridx = 0;
        gbc_lblDec.gridy = 0;
        this.add((Component)lblDec, gbc_lblDec);
        this.textFieldDec = new JTextField();
        GridBagConstraints gbc_textFieldDec = new GridBagConstraints();
        gbc_textFieldDec.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldDec.fill = 2;
        gbc_textFieldDec.gridx = 1;
        gbc_textFieldDec.gridy = 0;
        this.add((Component)this.textFieldDec, gbc_textFieldDec);
        this.textFieldDec.setColumns(10);
        JLabel lblHex = new JLabel("Hex:");
        lblHex.setToolTipText("Hexadecimal");
        GridBagConstraints gbc_lblHex = new GridBagConstraints();
        gbc_lblHex.anchor = 17;
        gbc_lblHex.insets = new Insets(0, 0, 5, 5);
        gbc_lblHex.gridx = 0;
        gbc_lblHex.gridy = 1;
        this.add((Component)lblHex, gbc_lblHex);
        this.textFieldHex = new JTextField();
        GridBagConstraints gbc_textFieldHex = new GridBagConstraints();
        gbc_textFieldHex.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldHex.fill = 2;
        gbc_textFieldHex.gridx = 1;
        gbc_textFieldHex.gridy = 1;
        this.add((Component)this.textFieldHex, gbc_textFieldHex);
        this.textFieldHex.setColumns(10);
        JLabel lblBin = new JLabel("Bin:");
        lblBin.setToolTipText("Binary");
        GridBagConstraints gbc_lblBin = new GridBagConstraints();
        gbc_lblBin.anchor = 17;
        gbc_lblBin.insets = new Insets(0, 0, 0, 5);
        gbc_lblBin.gridx = 0;
        gbc_lblBin.gridy = 2;
        this.add((Component)lblBin, gbc_lblBin);
        this.textFieldBin = new JTextField();
        GridBagConstraints gbc_textFieldBin = new GridBagConstraints();
        gbc_textFieldBin.fill = 2;
        gbc_textFieldBin.gridx = 1;
        gbc_textFieldBin.gridy = 2;
        this.add((Component)this.textFieldBin, gbc_textFieldBin);
        this.textFieldBin.setColumns(10);
        this.initDecHexBinPanel();
    }

    protected void initDecHexBinPanel() {
        this.textFieldDec.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.handle(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handle(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.handle(e);
            }

            protected void handle(DocumentEvent e) {
                if (!DecHexBinPanel.this.refreshing) {
                    DecHexBinPanel.this.applyDec();
                }
            }
        });
        this.textFieldHex.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.handle(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handle(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.handle(e);
            }

            protected void handle(DocumentEvent e) {
                if (!DecHexBinPanel.this.refreshing) {
                    DecHexBinPanel.this.applyHex();
                }
            }
        });
        this.textFieldBin.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.handle(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handle(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.handle(e);
            }

            protected void handle(DocumentEvent e) {
                if (!DecHexBinPanel.this.refreshing) {
                    DecHexBinPanel.this.applyBin();
                }
            }
        });
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
        this.textFieldDec.setColumns(columns);
        this.textFieldHex.setColumns(columns);
        this.textFieldBin.setColumns(columns);
    }

    protected JTextField getTextFieldDec() {
        return this.textFieldDec;
    }

    protected JTextField getTextFieldHex() {
        return this.textFieldHex;
    }

    protected JTextField getTextFieldBin() {
        return this.textFieldBin;
    }

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
        this.refresh();
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
        this.refresh();
    }

    protected void refresh() {
        this.refreshDec();
        this.refreshHex();
        this.refreshBin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshDec() {
        try {
            this.refreshing = true;
            String s = Long.toString(this.value);
            if (s == null) {
                s = "";
            }
            this.textFieldDec.setText(s);
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshHex() {
        try {
            this.refreshing = true;
            String s = DecHexBinPanel.formatHex(this.value, this.bits);
            if (s == null) {
                s = "";
            }
            this.textFieldHex.setText(s);
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshBin() {
        try {
            this.refreshing = true;
            String s = DecHexBinPanel.formatBinary(this.value, this.bits);
            if (s == null) {
                s = "";
            }
            this.textFieldBin.setText(s);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void applyDec() {
        try {
            this.value = Long.parseLong(this.textFieldDec.getText().trim());
        }
        catch (NumberFormatException e) {
            this.value = 0L;
        }
        this.refreshHex();
        this.refreshBin();
    }

    protected void applyHex() {
        try {
            this.value = DecHexBinPanel.parseHex(this.textFieldHex.getText().trim());
        }
        catch (NumberFormatException e) {
            this.value = 0L;
        }
        this.refreshDec();
        this.refreshBin();
    }

    protected void applyBin() {
        try {
            this.value = DecHexBinPanel.parseBinary(this.textFieldBin.getText().trim());
        }
        catch (NumberFormatException e) {
            this.value = 0L;
        }
        this.refreshDec();
        this.refreshHex();
    }

    public static String formatBinary(long value, int bits) {
        if (bits < 0 || bits > 64) {
            return null;
        }
        char[] chars = new char[bits];
        int off = bits;
        for (int i = 0; i < bits; ++i) {
            chars[--off] = (value >> i & 1L) == 1L ? 49 : 48;
        }
        return new String(chars);
    }

    public static long parseBinary(String s) {
        int len = s == null ? 0 : s.length();
        long val = 0L;
        block4: for (int i = 0; i < len; ++i) {
            val <<= 1;
            switch (s.charAt(i)) {
                case '0': {
                    continue block4;
                }
                case '1': {
                    val |= 1L;
                    continue block4;
                }
                default: {
                    throw new NumberFormatException("Invalid binary string: " + s);
                }
            }
        }
        return val;
    }

    public static String formatHex(long value, int bits) {
        if (bits < 0 || bits > 64) {
            return null;
        }
        int len = (bits + 3) / 4;
        char[] chars = new char[len];
        int off = len;
        for (int i = 0; i < len; ++i) {
            chars[--off] = HEX_CHARS[(int)(value & 0xFL)];
            value >>= 4;
        }
        return new String(chars);
    }

    public static long parseHex(String s) {
        int len = 0;
        if (s != null) {
            s = s.toLowerCase();
            len = s.length();
        }
        long val = 0L;
        block18: for (int i = 0; i < len; ++i) {
            val <<= 4;
            switch (s.charAt(i)) {
                case '0': {
                    continue block18;
                }
                case '1': {
                    val |= 1L;
                    continue block18;
                }
                case '2': {
                    val |= 2L;
                    continue block18;
                }
                case '3': {
                    val |= 3L;
                    continue block18;
                }
                case '4': {
                    val |= 4L;
                    continue block18;
                }
                case '5': {
                    val |= 5L;
                    continue block18;
                }
                case '6': {
                    val |= 6L;
                    continue block18;
                }
                case '7': {
                    val |= 7L;
                    continue block18;
                }
                case '8': {
                    val |= 8L;
                    continue block18;
                }
                case '9': {
                    val |= 9L;
                    continue block18;
                }
                case 'a': {
                    val |= 0xAL;
                    continue block18;
                }
                case 'b': {
                    val |= 0xBL;
                    continue block18;
                }
                case 'c': {
                    val |= 0xCL;
                    continue block18;
                }
                case 'd': {
                    val |= 0xDL;
                    continue block18;
                }
                case 'e': {
                    val |= 0xEL;
                    continue block18;
                }
                case 'f': {
                    val |= 0xFL;
                    continue block18;
                }
                default: {
                    throw new NumberFormatException("Invalid hex string: " + s);
                }
            }
        }
        return val;
    }
}

