/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.debug;

import com.waxmonster.timecode.common.LfsrTimecodeDefinition;
import com.waxmonster.timecode.debug.BitArray;
import com.waxmonster.timecode.impl.Lfsr;
import com.waxmonster.timecode.impl.LfsrTable;

public class LfsrSeedDetector {
    private BitArray data;
    private int bits;

    public LfsrSeedDetector(BitArray data, int bits) {
        this.data = data;
        this.bits = bits;
    }

    protected BitArray getData() {
        return this.data;
    }

    protected void setData(BitArray data) {
        this.data = data;
    }

    public int getBits() {
        return this.bits;
    }

    protected void setBits(int bits) {
        this.bits = bits;
    }

    public int detectSeed(LfsrTimecodeDefinition def, int minContinuousSlots) {
        int result = 0;
        boolean test = false;
        LfsrTable table = new LfsrTable(def, test){

            protected void initTimecodeTable() throws IllegalArgumentException {
                try {
                    super.initTimecodeTable();
                }
                catch (IllegalArgumentException e) {
                    System.out.println("Suppressing timecode wrapping error: " + e);
                }
            }
        };
        int len = this.data.length();
        int hi = 1 << this.bits - 1;
        int taps = def.getTaps();
        int tc = 0;
        int lastCode = 0;
        int lastSlot = -1;
        int continuousSlots = 0;
        int continuousSeed = 0;
        int continuousIndex = -1;
        int maxContinuousSlots = 0;
        int maxContinuousSeed = 0;
        int maxContinuousIndex = -1;
        int firstPossibleSlots = 0;
        int firstPossibleSeed = 0;
        int firstPossibleIndex = -1;
        for (int i = 0; i < len; ++i) {
            int slot;
            tc >>= 1;
            if (this.data.get(i)) {
                tc |= hi;
            }
            if ((slot = table.lookup(tc)) == lastSlot + 1 && slot != -1 && i >= this.bits && lastSlot != -1) {
                if (continuousSlots < 1) {
                    continuousSeed = lastCode;
                    continuousIndex = i - 1;
                    System.out.println("Testing seed at bit #" + continuousIndex + ": " + continuousSeed + " == 0x" + Integer.toHexString(continuousSeed) + " ==> slot=" + lastSlot);
                }
                if (++continuousSlots > maxContinuousSlots) {
                    maxContinuousSlots = continuousSlots;
                    maxContinuousSeed = continuousSeed;
                    maxContinuousIndex = continuousIndex;
                }
                if (continuousSlots > minContinuousSlots) {
                    if (firstPossibleIndex < 0) {
                        System.out.println("Found possible seed at bit #" + continuousIndex + ": " + continuousSeed + " == 0x" + Integer.toHexString(continuousSeed));
                    }
                    if (firstPossibleIndex < 0 || firstPossibleIndex == continuousIndex) {
                        firstPossibleIndex = continuousIndex;
                        firstPossibleSlots = continuousSlots;
                        firstPossibleSeed = continuousSeed;
                    }
                }
            } else {
                continuousSlots = 0;
            }
            lastSlot = slot;
            lastCode = tc;
        }
        if (firstPossibleIndex >= 0) {
            System.out.println("First possible seed at bit #" + firstPossibleIndex + ": " + firstPossibleSeed + " == 0x" + Integer.toHexString(firstPossibleSeed) + " (" + firstPossibleSlots + " continuous slots)");
        }
        if (maxContinuousIndex >= 0) {
            System.out.println("Max.continuous seed at bit #" + maxContinuousIndex + ": " + maxContinuousSeed + " == 0x" + Integer.toHexString(maxContinuousSeed) + " (" + maxContinuousSlots + " continuous slots)");
        }
        if (firstPossibleIndex >= 0) {
            result = firstPossibleSeed;
            if (firstPossibleIndex >= this.bits) {
                Lfsr lfsr = new Lfsr(this.bits, taps);
                System.out.println("Searching backwards to find seed...");
                int prev = firstPossibleSeed;
                StringBuffer debugData = new StringBuffer();
                StringBuffer debugBits = new StringBuffer();
                for (int i = firstPossibleIndex - this.bits + 1; i >= 0; --i) {
                    boolean bit = (prev & 1) != 0;
                    boolean dat = this.data.get(i);
                    System.out.println("Checking index #" + i + ": dat=" + dat + ", bit=" + bit);
                    debugData.append(dat ? "1" : "0");
                    debugBits.append(bit ? "1" : "0");
                    if (dat != bit) {
                        System.out.println("Check failed at index #" + i + ": " + dat + " != " + bit);
                        result = lfsr.fwd(prev);
                        break;
                    }
                    prev = lfsr.rev(prev);
                }
                System.out.println("debugData: " + debugData);
                System.out.println("debugBits: " + debugBits);
            }
            if (result != 0) {
                System.out.println("Return seed: " + result + " == 0x" + Integer.toHexString(result) + " (" + Integer.toBinaryString(result) + ")");
            }
        }
        return result;
    }
}

