/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.debug;

import com.waxmonster.timecode.debug.BitArray;
import com.waxmonster.timecode.impl.Lfsr;

public class LfsrTapsDetector {
    private BitArray data;
    private int bits;
    private int seed;

    public LfsrTapsDetector(BitArray data, int bits) {
        this.data = data;
        this.bits = bits;
        this.seed = 0;
        for (int i = 0; i < bits; ++i) {
            if (!data.get(i)) continue;
            this.seed |= 1 << i;
        }
    }

    protected BitArray getData() {
        return this.data;
    }

    protected void setData(BitArray data) {
        this.data = data;
    }

    public int getBits() {
        return this.bits;
    }

    protected void setBits(int bits) {
        this.bits = bits;
    }

    public int getSeed() {
        return this.seed;
    }

    protected void setSeed(int seed) {
        this.seed = seed;
    }

    public void testTaps(int taps) {
        Lfsr lfsr = new Lfsr(this.bits, taps);
        int len = this.data.length();
        int expected = this.seed;
        int hi = 1 << this.bits - 1;
        int tc = 0;
        for (int i = 0; i < len; ++i) {
            tc >>= 1;
            if (this.data.get(i)) {
                tc |= hi;
            }
            if (i + 1 < this.bits) continue;
            if (tc != expected) {
                throw new RuntimeException("Unexpected LFSR-Value: " + Integer.toBinaryString(tc) + " != " + Integer.toBinaryString(expected));
            }
            expected = lfsr.fwd(expected);
        }
        System.out.println("Tested " + len + " bits");
    }

    public int detectTaps() {
        int start;
        int result = 0;
        int max = 1 << this.bits;
        System.out.println("Brute force " + max + " possible taps...");
        for (int t = start = 1; t < max; ++t) {
            int taps = t;
            Lfsr lfsr = new Lfsr(this.bits, taps);
            int len = this.data.length();
            int expected = this.seed;
            int hi = 1 << this.bits - 1;
            int tc = 0;
            boolean found = true;
            for (int i = 0; i < len; ++i) {
                tc >>= 1;
                if (this.data.get(i)) {
                    tc |= hi;
                }
                if (i + 1 < this.bits) continue;
                if (tc != expected) {
                    found = false;
                    break;
                }
                expected = lfsr.fwd(expected);
            }
            if (!found) continue;
            System.out.println("Found the taps: " + taps + " == 0x" + Integer.toHexString(taps) + " (" + Integer.toBinaryString(taps) + ")");
            if (result != 0) continue;
            result = taps;
        }
        return result;
    }
}

