/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.debug;

import com.spacekiller.util.AbstractExecution;
import com.spacekiller.util.media.wave.WaveAudioFile;
import com.spacekiller.util.sound.ByteArraySampleBuffer;
import com.spacekiller.util.sound.RawSampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleType;
import com.spacekiller.util.sound.SoundUtil;
import com.waxmonster.timecode.common.LfsrTimecodeDefinition;
import com.waxmonster.timecode.common.TimecodeTable;
import com.waxmonster.timecode.debug.TimecodeAnalyzerImpl;
import com.waxmonster.timecode.debug.TimecodeAnalyzerResult;
import com.waxmonster.timecode.impl.LfsrTable;
import java.io.File;
import java.io.StreamCorruptedException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;

public class TimecodeAnalyzerExecution
extends AbstractExecution {
    private static final Logger logger = Logger.getLogger(TimecodeAnalyzerExecution.class.getName());
    private File sourceFile;
    private LfsrTimecodeDefinition lfsrDefinition;
    private LfsrTable lfsrTable;
    private Runnable postHook;
    private TimecodeAnalyzerResult timecodeAnalyzerResult;

    public TimecodeAnalyzerExecution(File sourceFile, LfsrTimecodeDefinition lfsrDefinition, LfsrTable lfsrTable, Runnable postHook) {
        this.sourceFile = sourceFile;
        this.lfsrDefinition = lfsrDefinition;
        this.lfsrTable = lfsrTable;
        this.postHook = postHook;
        this.setName("Timecode Analyzer");
        this.setDescription("Timecode Analyzer: " + sourceFile);
        this.setStatus("Analyzing timecode file: " + sourceFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        try {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Analyzing timecode wave file: " + this.sourceFile);
            }
            WaveAudioFile waf = new WaveAudioFile(this.sourceFile, "r");
            try {
                SampleType sampleType;
                int channels;
                AudioFormat format = waf.getAudioFormat();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Audio format: " + format);
                }
                if ((channels = waf.getChannels()) != 2) {
                    throw new IllegalArgumentException("Timecode audio file must be stereo ! (Found " + channels + " channels)");
                }
                float frameRate = waf.getFrameRate();
                int frameSize = waf.getFrameSize();
                long frames = waf.getFrameLength();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Number of audio frames: " + frames + " @ " + frameRate + " Hz stereo (" + frameSize + " bytes/frame)");
                }
                if ((sampleType = SoundUtil.guessSampleType((AudioFormat)format)) == null) {
                    throw new Exception("Unsupported audio format: " + format);
                }
                int bufferFrames = (int)frameRate;
                int bufferSamples = bufferFrames * channels;
                int bufferBytes = bufferFrames * frameSize;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Creating sample buffer: " + bufferFrames + " frames, " + bufferSamples + " samples, " + bufferBytes + " bytes");
                }
                ByteArraySampleBuffer buffer = sampleType.createByteArraySampleBuffer(channels, frameRate, bufferSamples);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("ByteArraySampleBuffer: " + buffer);
                }
                TimecodeAnalyzerImpl analyzer = new TimecodeAnalyzerImpl(frameRate, this.lfsrDefinition, (TimecodeTable)this.lfsrTable);
                long ms1 = System.currentTimeMillis();
                long framePosition = 0L;
                while (framePosition < frames) {
                    int numFrames = (int)Math.min((long)bufferFrames, frames - framePosition);
                    int numBytes = numFrames * frameSize;
                    int numRead = waf.read(framePosition, (RawSampleBuffer)buffer, 0, numBytes);
                    if (numRead != numBytes) {
                        throw new StreamCorruptedException("numRead: " + numRead + " != " + numBytes);
                    }
                    analyzer.process((SampleBuffer)buffer, numFrames);
                    this.setProgress((double)(framePosition += (long)numFrames) / (double)frames);
                }
                long ms2 = System.currentTimeMillis();
                this.setProgress(1.0);
                this.setTimecodeAnalyzerResult(analyzer.getResult());
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Processed " + framePosition + " frames in " + (ms2 - ms1) + " ms.");
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                this.addException(e);
            }
            finally {
                try {
                    waf.close();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    this.addException(e);
                }
            }
        }
        finally {
            Runnable post = this.postHook;
            if (post != null) {
                post.run();
            }
        }
    }

    public TimecodeAnalyzerResult getTimecodeAnalyzerResult() {
        return this.timecodeAnalyzerResult;
    }

    protected void setTimecodeAnalyzerResult(TimecodeAnalyzerResult timecodeAnalyzerResult) {
        this.timecodeAnalyzerResult = timecodeAnalyzerResult;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    protected void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    public LfsrTimecodeDefinition getLfsrDefinition() {
        return this.lfsrDefinition;
    }

    protected void setLfsrDefinition(LfsrTimecodeDefinition lfsrDefinition) {
        this.lfsrDefinition = lfsrDefinition;
    }

    public LfsrTable getLfsrTable() {
        return this.lfsrTable;
    }

    protected void setLfsrTable(LfsrTable lfsrTable) {
        this.lfsrTable = lfsrTable;
    }
}

