/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.debug;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.timecode.common.LfsrTimecodeDefinition;
import com.waxmonster.timecode.common.TimecodeTable;
import com.waxmonster.timecode.debug.TimecodeAnalyzer;
import com.waxmonster.timecode.debug.TimecodeAnalyzerResult;
import com.waxmonster.timecode.impl.Lfsr;
import com.waxmonster.timecode.impl.LfsrChannel;
import java.io.PrintStream;

public class TimecodeAnalyzerImpl
implements TimecodeAnalyzer {
    public static final int UNKNOWN = 0;
    public static final int FORWARD = 1;
    public static final int BACKWARD = -1;
    private static final double ZERO_RC = 0.001;
    private static final double ALPHA = 0.001953125;
    private static final double BETA = 7.62939453125E-6;
    private static final int REF_PEAKS_AVG = 48;
    private final double frameRate;
    private final LfsrTimecodeDefinition definition;
    private final int bits;
    private final Lfsr lfsr;
    private final TimecodeTable table;
    private long frameCount;
    private long bitCount;
    private long zeroBitCount;
    private long oneBitCount;
    private long validBitCount;
    private long invalidBitCount;
    private boolean switchPhase;
    private boolean switchPrimary;
    private boolean switchPolarity;
    private LfsrChannel primary;
    private LfsrChannel secondary;
    private long primaryCrossed;
    private long secondaryCrossed;
    private long directionChanges;
    private int direction;
    private long forwardCount = 0L;
    private long backwardCount = 0L;
    private double dt;
    private double dxFwd;
    private double dxRev;
    private Pitch pitch;
    private int bitState;
    private int timecode;
    private int bitstream;
    private int validCounter;
    private int timecodeTicker;
    private int slot = -1;
    private int continousSlots = 0;
    private int totalContinousSlots = 0;
    private int maxContinousSlots = 0;
    private int totalUnknownSlots = 0;
    private double refLevel = 1.0;
    private StringBuffer debugBits = new StringBuffer();

    public TimecodeAnalyzerImpl(double frameRate, LfsrTimecodeDefinition timecodeDefinition, TimecodeTable timecodeTable) {
        double zeroAlpha;
        this.definition = timecodeDefinition;
        this.setSwitchPhase(this.definition.isSwitchPhase());
        this.setSwitchPrimary(this.definition.isSwitchPrimary());
        this.setSwitchPolarity(this.definition.isSwitchPolarity());
        this.bits = this.definition.getBits();
        int taps = this.definition.getTaps();
        this.lfsr = new Lfsr(this.bits, taps);
        this.table = timecodeTable;
        this.frameRate = frameRate;
        this.dt = 1.0 / frameRate;
        double resolution = this.definition.getResolution();
        this.pitch = new Pitch();
        this.dxFwd = 1.0 / resolution / 4.0;
        this.dxRev = -1.0 / resolution / 4.0;
        double zeroThreshold = zeroAlpha = this.dt / (0.001 + this.dt);
        this.primary = new LfsrChannel(zeroThreshold, zeroAlpha);
        this.secondary = new LfsrChannel(zeroThreshold, zeroAlpha);
        System.out.println("TimecodeAnalyzerImpl: zeroThreshold=" + zeroThreshold + ", zeroAlpha=" + zeroAlpha);
    }

    @Override
    public void process(SampleBuffer buf, int frames) {
        int channels = buf.getChannels();
        if (channels != 2) {
            throw new IllegalArgumentException("Invalid number of channels: " + channels + " != 2 (stereo)");
        }
        int i = 0;
        block12: for (int f = 0; f < frames; ++f) {
            int dir;
            double s;
            double p;
            if (this.switchPrimary) {
                p = buf.getDouble(i++);
                s = buf.getDouble(i++);
            } else {
                s = buf.getDouble(i++);
                p = buf.getDouble(i++);
            }
            this.primary.process(p);
            this.secondary.process(s);
            if (this.primary.crossed) {
                ++this.primaryCrossed;
                int n = dir = this.primary.state == this.secondary.state ^ this.switchPhase ? -1 : 1;
                if (dir != this.direction) {
                    if (this.direction != 0) {
                        ++this.directionChanges;
                    }
                    this.direction = dir;
                }
            } else if (this.secondary.crossed) {
                ++this.secondaryCrossed;
                int n = dir = this.primary.state == this.secondary.state ^ this.switchPhase ? 1 : -1;
                if (dir != this.direction) {
                    if (this.direction != 0) {
                        ++this.directionChanges;
                    }
                    this.direction = dir;
                }
            }
            if (!this.primary.crossed && !this.secondary.crossed) {
                this.observePitch(0.0);
            } else {
                switch (this.direction) {
                    case 1: {
                        this.observePitch(this.dxFwd);
                        break;
                    }
                    case -1: {
                        this.observePitch(this.dxRev);
                        break;
                    }
                    default: {
                        this.observePitch(0.0);
                    }
                }
            }
            if (this.secondary.crossed && this.primary.state == this.bitState) {
                this.processBit(Math.abs(p - this.primary.zero));
                if (this.validCounter > 0) {
                    int newSlot = this.table.lookup(this.timecode);
                    if (newSlot == -1) {
                        this.slot = -1;
                        this.continousSlots = 0;
                        ++this.totalUnknownSlots;
                    } else {
                        switch (this.direction) {
                            case 1: {
                                if (newSlot != this.slot + 1) break;
                                ++this.totalContinousSlots;
                                if (++this.continousSlots <= this.maxContinousSlots) break;
                                this.maxContinousSlots = this.continousSlots;
                                break;
                            }
                            case -1: {
                                if (newSlot != this.slot - 1) break;
                                ++this.totalContinousSlots;
                                if (++this.continousSlots <= this.maxContinousSlots) break;
                                this.maxContinousSlots = this.continousSlots;
                            }
                        }
                        this.slot = newSlot;
                    }
                } else {
                    this.slot = -1;
                    this.continousSlots = 0;
                    ++this.totalUnknownSlots;
                }
            }
            ++this.frameCount;
            ++this.timecodeTicker;
            switch (this.direction) {
                case 1: {
                    ++this.forwardCount;
                    continue block12;
                }
                case -1: {
                    ++this.backwardCount;
                }
            }
        }
    }

    protected void observePitch(double dx) {
        double predicted_x = this.pitch.x + this.pitch.v * this.dt;
        double predicted_v = this.pitch.v;
        double residual_x = dx - predicted_x;
        this.pitch.x = predicted_x + residual_x * 0.001953125;
        this.pitch.v = predicted_v + residual_x * 7.62939453125E-6 / this.dt;
        this.pitch.x -= dx;
    }

    protected void processBit(double m) {
        int b = m > this.refLevel ? 1 : 0;
        this.refLevel -= this.refLevel / 48.0;
        this.refLevel += m / 48.0;
        this.timecodeTicker = 0;
        ++this.bitCount;
        if (b == 0) {
            ++this.zeroBitCount;
        } else {
            ++this.oneBitCount;
        }
        if (this.debugBits.length() < 4000) {
            this.debugBits.append(b == 0 ? (char)'0' : '1');
        }
        switch (this.direction) {
            case 1: {
                this.bitstream = (this.bitstream >> 1) + (b << this.bits - 1);
                this.timecode = this.lfsr.fwd(this.timecode);
                if (this.timecode != this.bitstream) break;
                ++this.validCounter;
                ++this.validBitCount;
                return;
            }
            case -1: {
                int mask = (1 << this.bits) - 1;
                this.bitstream = (this.bitstream << 1 & mask) + b;
                this.timecode = this.lfsr.rev(this.timecode);
                if (this.timecode != this.bitstream) break;
                ++this.validCounter;
                ++this.validBitCount;
                return;
            }
        }
        this.timecode = this.bitstream;
        this.validCounter = 0;
        ++this.invalidBitCount;
    }

    @Override
    public TimecodeAnalyzerResult getResult() {
        TimecodeAnalyzerResult result = new TimecodeAnalyzerResult();
        result.setFrameRate(this.frameRate);
        result.setFrameCount(this.frameCount);
        result.setPrimaryCrossed(this.primaryCrossed);
        result.setSecondaryCrossed(this.secondaryCrossed);
        result.setForwardCount(this.forwardCount);
        result.setBackwardCount(this.backwardCount);
        result.setDirection(this.direction);
        result.setDirectionChanges(this.directionChanges);
        result.setBitCount(this.bitCount);
        result.setZeroBitCount(this.zeroBitCount);
        result.setOneBitCount(this.oneBitCount);
        result.setValidBitCount(this.validBitCount);
        result.setInvalidBitCount(this.invalidBitCount);
        result.setTotalUnknownSlots(this.totalUnknownSlots);
        result.setTotalContinousSlots(this.totalContinousSlots);
        result.setMaxContinousSlots(this.maxContinousSlots);
        double avgCrossed = (double)(this.primaryCrossed + this.secondaryCrossed) / 2.0;
        double avgCrossedFrames = (double)this.frameCount / avgCrossed;
        double avgResolution = this.frameRate / avgCrossedFrames / 2.0;
        result.setAvgResolution(avgResolution);
        result.setExpectedResolution(this.definition.getResolution());
        long totalCount = this.forwardCount + this.backwardCount;
        double forwardPct = totalCount > 0L ? (double)this.forwardCount * 100.0 / (double)totalCount : 0.0;
        double backwardPct = totalCount > 0L ? (double)this.backwardCount * 100.0 / (double)totalCount : 0.0;
        result.setForwardPct(forwardPct);
        result.setBackwardPct(backwardPct);
        double totalContinousSlotsPct = (double)this.totalContinousSlots * 100.0 / (double)this.validBitCount;
        result.setTotalContinousSlotsPct(totalContinousSlotsPct);
        double maxContinousSlotsPct = (double)this.maxContinousSlots * 100.0 / (double)this.validBitCount;
        result.setMaxContinousSlotsPct(maxContinousSlotsPct);
        result.setTimecodeTicker(this.timecodeTicker);
        return result;
    }

    public void dump(PrintStream out) {
        out.println("" + this.getResult());
        out.println("Used defined seedBits: " + Integer.toBinaryString(this.definition.getSeed()));
        out.println("Used defined tapsBits: " + Integer.toBinaryString(this.definition.getTaps()));
        out.println("Collected debugBits: " + this.debugBits);
    }

    public boolean isSwitchPhase() {
        return this.switchPhase;
    }

    public void setSwitchPhase(boolean switchPhase) {
        this.switchPhase = switchPhase;
    }

    public boolean isSwitchPolarity() {
        return this.switchPolarity;
    }

    public void setSwitchPolarity(boolean switchPolarity) {
        this.switchPolarity = switchPolarity;
        this.bitState = switchPolarity ? -1 : 1;
    }

    public int getDirection() {
        return this.direction;
    }

    protected void setDirection(int direction) {
        this.direction = direction;
    }

    public long getDirectionChanges() {
        return this.directionChanges;
    }

    protected void setDirectionChanges(long directionChanges) {
        this.directionChanges = directionChanges;
    }

    public boolean isSwitchPrimary() {
        return this.switchPrimary;
    }

    public void setSwitchPrimary(boolean switchPrimary) {
        this.switchPrimary = switchPrimary;
    }

    protected static class Pitch {
        double x;
        double v;

        protected Pitch() {
        }
    }
}

