/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.debug;

public class TimecodeAnalyzerResult {
    private double frameRate;
    private long primaryCrossed;
    private long secondaryCrossed;
    private long directionChanges;
    private int direction;
    private long forwardCount;
    private long backwardCount;
    private long frameCount;
    private long bitCount;
    private long zeroBitCount;
    private long oneBitCount;
    private long validBitCount;
    private long invalidBitCount;
    private long totalUnknownSlots;
    private long totalContinousSlots;
    private double totalContinousSlotsPct;
    private long maxContinousSlots;
    private double maxContinousSlotsPct;
    private double expectedResolution;
    private double avgResolution;
    private double forwardPct;
    private double backwardPct;
    private long timecodeTicker;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String newLine = "\n";
        sb.append("Frame rate: " + this.frameRate).append(newLine);
        sb.append("Frames: " + this.frameCount).append(newLine);
        sb.append("Primary crossings: " + this.primaryCrossed).append(newLine);
        sb.append("Second. crossings: " + this.secondaryCrossed).append(newLine);
        sb.append("Average resolution: " + (double)Math.round(this.avgResolution * 100.0) / 100.0 + " wave cycles/second (expected " + this.expectedResolution + ")").append(newLine);
        sb.append("Direction changes: " + this.directionChanges).append(newLine);
        sb.append("Forward count: " + this.forwardCount + " frames (" + (double)Math.round(this.forwardPct * 100.0) / 100.0 + " %)").append(newLine);
        sb.append("Backward count: " + this.backwardCount + " frames (" + (double)Math.round(this.backwardPct * 100.0) / 100.0 + " %)").append(newLine);
        sb.append("Last direction: " + this.direction).append(newLine);
        sb.append("Timecode bits: " + this.bitCount).append(newLine);
        sb.append("Timecode 0-bits: " + this.zeroBitCount).append(newLine);
        sb.append("Timecode 1-bits: " + this.oneBitCount).append(newLine);
        sb.append("Timecode valid bits: " + this.validBitCount).append(newLine);
        sb.append("Timecode invalid bits: " + this.invalidBitCount).append(newLine);
        sb.append("Total unknown slots: " + this.totalUnknownSlots).append(newLine);
        double totalContinousSlotsPctRounded = (double)Math.round(this.totalContinousSlotsPct * 100.0) / 100.0;
        sb.append("Total continuous slots: " + totalContinousSlotsPctRounded + " % (" + this.totalContinousSlots + " of " + this.validBitCount + " valid bits)").append(newLine);
        double maxContinousSlotsPctRounded = (double)Math.round(this.maxContinousSlotsPct * 100.0) / 100.0;
        sb.append("Max. continuous slots: " + maxContinousSlotsPctRounded + " % (" + this.maxContinousSlots + " of " + this.validBitCount + " valid bits)").append(newLine);
        return sb.toString();
    }

    public long getBackwardCount() {
        return this.backwardCount;
    }

    public void setBackwardCount(long backwardCount) {
        this.backwardCount = backwardCount;
    }

    public long getPrimaryCrossed() {
        return this.primaryCrossed;
    }

    public void setPrimaryCrossed(long primaryCrossed) {
        this.primaryCrossed = primaryCrossed;
    }

    public long getSecondaryCrossed() {
        return this.secondaryCrossed;
    }

    public void setSecondaryCrossed(long secondaryCrossed) {
        this.secondaryCrossed = secondaryCrossed;
    }

    public long getDirectionChanges() {
        return this.directionChanges;
    }

    public void setDirectionChanges(long directionChanges) {
        this.directionChanges = directionChanges;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public long getForwardCount() {
        return this.forwardCount;
    }

    public void setForwardCount(long forwardCount) {
        this.forwardCount = forwardCount;
    }

    public long getFrameCount() {
        return this.frameCount;
    }

    public void setFrameCount(long frameCount) {
        this.frameCount = frameCount;
    }

    public long getBitCount() {
        return this.bitCount;
    }

    public void setBitCount(long bitCount) {
        this.bitCount = bitCount;
    }

    public long getZeroBitCount() {
        return this.zeroBitCount;
    }

    public void setZeroBitCount(long zeroBitCount) {
        this.zeroBitCount = zeroBitCount;
    }

    public long getOneBitCount() {
        return this.oneBitCount;
    }

    public void setOneBitCount(long oneBitCount) {
        this.oneBitCount = oneBitCount;
    }

    public long getValidBitCount() {
        return this.validBitCount;
    }

    public void setValidBitCount(long validBitCount) {
        this.validBitCount = validBitCount;
    }

    public long getInvalidBitCount() {
        return this.invalidBitCount;
    }

    public void setInvalidBitCount(long invalidBitCount) {
        this.invalidBitCount = invalidBitCount;
    }

    public double getAvgResolution() {
        return this.avgResolution;
    }

    public void setAvgResolution(double avgResolution) {
        this.avgResolution = avgResolution;
    }

    public double getForwardPct() {
        return this.forwardPct;
    }

    public void setForwardPct(double forwardPct) {
        this.forwardPct = forwardPct;
    }

    public double getBackwardPct() {
        return this.backwardPct;
    }

    public void setBackwardPct(double backwardPct) {
        this.backwardPct = backwardPct;
    }

    public long getTotalUnknownSlots() {
        return this.totalUnknownSlots;
    }

    public void setTotalUnknownSlots(long totalUnknownSlots) {
        this.totalUnknownSlots = totalUnknownSlots;
    }

    public long getMaxContinousSlots() {
        return this.maxContinousSlots;
    }

    public void setMaxContinousSlots(long maxContinousSlots) {
        this.maxContinousSlots = maxContinousSlots;
    }

    public long getTotalContinousSlots() {
        return this.totalContinousSlots;
    }

    public void setTotalContinousSlots(long totalContinousSlots) {
        this.totalContinousSlots = totalContinousSlots;
    }

    public double getTotalContinousSlotsPct() {
        return this.totalContinousSlotsPct;
    }

    public void setTotalContinousSlotsPct(double totalContinousSlotsPct) {
        this.totalContinousSlotsPct = totalContinousSlotsPct;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(double frameRate) {
        this.frameRate = frameRate;
    }

    public double getExpectedResolution() {
        return this.expectedResolution;
    }

    public void setExpectedResolution(double expectedResolution) {
        this.expectedResolution = expectedResolution;
    }

    public long getTimecodeTicker() {
        return this.timecodeTicker;
    }

    public void setTimecodeTicker(long timecodeTicker) {
        this.timecodeTicker = timecodeTicker;
    }

    public double getMaxContinousSlotsPct() {
        return this.maxContinousSlotsPct;
    }

    public void setMaxContinousSlotsPct(double maxContinousSlotsPct) {
        this.maxContinousSlotsPct = maxContinousSlotsPct;
    }
}

