/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.debug;

import com.spacekiller.util.AbstractExecution;
import com.spacekiller.util.media.wave.WaveAudioFile;
import com.spacekiller.util.sound.RawSampleBuffer;
import com.spacekiller.util.sound.SampleType;
import com.spacekiller.util.sound.SoundUtil;
import com.waxmonster.timecode.debug.TimecodeProducer;
import java.io.File;
import javax.sound.sampled.AudioFormat;

public class TimecodeGeneratorExecution
extends AbstractExecution {
    private TimecodeProducer leftProducer;
    private TimecodeProducer rightProducer;
    private File targetFile;
    private AudioFormat audioFormat;
    private long frameLength;
    private Runnable postHook;

    public TimecodeGeneratorExecution(TimecodeProducer leftProducer, TimecodeProducer rightProducer, File targetFile, AudioFormat audioFormat, long frameLength, Runnable postHook) {
        this.leftProducer = leftProducer;
        this.rightProducer = rightProducer;
        this.targetFile = targetFile;
        this.audioFormat = audioFormat;
        this.frameLength = frameLength;
        this.postHook = postHook;
        this.setName("Timecode Generator");
        this.setDescription("Timecode Generator: " + targetFile);
        this.setStatus("Generating timecode file: " + targetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        try {
            int frameSize = this.audioFormat.getFrameSize();
            float frameRate = this.audioFormat.getFrameRate();
            int bufferFrames = (int)frameRate;
            int channels = 2;
            int samples = bufferFrames * channels;
            SampleType sampleType = SoundUtil.guessSampleType((AudioFormat)this.audioFormat);
            if (sampleType == null) {
                throw new Exception("Unsupported audio format: " + this.audioFormat);
            }
            RawSampleBuffer stereoBuffer = sampleType.createRawSampleBuffer(channels, frameRate, samples);
            WaveAudioFile audioFile = new WaveAudioFile(this.targetFile, this.audioFormat);
            try {
                int frames;
                long framePosition = 0L;
                while ((frames = (int)Math.min(this.frameLength - framePosition, (long)bufferFrames)) >= 1) {
                    int o = 0;
                    for (int i = 0; i < frames; ++i) {
                        stereoBuffer.set(o++, this.leftProducer.produce(framePosition + (long)i));
                        stereoBuffer.set(o++, this.rightProducer.produce(framePosition + (long)i));
                    }
                    audioFile.write(framePosition, stereoBuffer, 0, frames * frameSize);
                    this.setProgress((double)(framePosition += (long)frames) / (double)this.frameLength);
                }
                this.setProgress(1.0);
            }
            finally {
                audioFile.close();
            }
        }
        finally {
            Runnable post = this.postHook;
            if (post != null) {
                post.run();
            }
        }
    }
}

