/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.debug;

import com.waxmonster.timecode.common.CustomLfsrTimecodeDefinition;
import com.waxmonster.timecode.common.LfsrTimecodeDefinition;

public class TimecodeGeneratorOptions {
    private String name;
    private int resolution;
    private int bits;
    private int seed;
    private int taps;
    private int length;
    private boolean switchPhase;
    private boolean switchPrimary;
    private boolean switchPolarity;
    private double amp = 0.5;
    private double amp0 = 0.75;
    private double amp1 = 1.0;
    private double angle = 0.0;
    private double range = 0.25;

    public TimecodeGeneratorOptions() {
    }

    public TimecodeGeneratorOptions(LfsrTimecodeDefinition def) {
        this();
        this.setName(def.getName());
        this.setResolution(def.getResolution());
        this.setBits(def.getBits());
        this.setTaps(def.getTaps());
        this.setSeed(def.getSeed());
        this.setLength(def.getLength());
        this.setSwitchPhase(def.isSwitchPhase());
        this.setSwitchPrimary(def.isSwitchPrimary());
        this.setSwitchPolarity(def.isSwitchPolarity());
        this.setAmp(def.getAmp());
        this.setAmp0(def.getAmp0());
        this.setAmp1(def.getAmp1());
        this.setAngle(def.getAngle());
        this.setRange(def.getRange());
    }

    public LfsrTimecodeDefinition createLfsrTimecodeDefinition() {
        CustomLfsrTimecodeDefinition def = new CustomLfsrTimecodeDefinition();
        def.setName(this.name);
        def.setResolution(this.resolution);
        def.setBits(this.bits);
        def.setTaps(this.taps);
        def.setSeed(this.seed);
        def.setLength(this.length);
        def.setSafe(this.length);
        def.setSwitchPhase(this.switchPhase);
        def.setSwitchPrimary(this.switchPrimary);
        def.setSwitchPolarity(this.switchPolarity);
        def.setAmp(this.amp);
        def.setAmp0(this.amp0);
        def.setAmp1(this.amp1);
        def.setAngle(this.angle);
        def.setRange(this.range);
        return def;
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public int getSeed() {
        return this.seed;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public int getTaps() {
        return this.taps;
    }

    public void setTaps(int taps) {
        this.taps = taps;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public boolean isSwitchPhase() {
        return this.switchPhase;
    }

    public void setSwitchPhase(boolean switchPhase) {
        this.switchPhase = switchPhase;
    }

    public boolean isSwitchPrimary() {
        return this.switchPrimary;
    }

    public void setSwitchPrimary(boolean switchPrimary) {
        this.switchPrimary = switchPrimary;
    }

    public boolean isSwitchPolarity() {
        return this.switchPolarity;
    }

    public void setSwitchPolarity(boolean switchPolarity) {
        this.switchPolarity = switchPolarity;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getAmp() {
        return this.amp;
    }

    public void setAmp(double amp) {
        this.amp = amp;
    }

    public double getAmp0() {
        return this.amp0;
    }

    public void setAmp0(double amp0) {
        this.amp0 = amp0;
    }

    public double getAmp1() {
        return this.amp1;
    }

    public void setAmp1(double amp1) {
        this.amp1 = amp1;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public double getRange() {
        return this.range;
    }

    public void setRange(double range) {
        this.range = range;
    }
}

