/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.debug;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;

public class TimecodeMonitor
implements AudioProcessor {
    private final SampleBuffer left;
    private final SampleBuffer right;
    private volatile boolean meter;
    final double[] x;
    final double[] y;
    final int z;
    int o;

    public TimecodeMonitor(SampleBuffer left, SampleBuffer right, int pixels) {
        this.left = left;
        this.right = right;
        if (pixels < left.getSamples()) {
            pixels = left.getSamples();
        }
        this.meter = false;
        this.z = pixels;
        this.x = new double[this.z];
        this.y = new double[this.z];
        for (int i = 0; i < this.z; ++i) {
            this.x[i] = Double.NaN;
            this.y[i] = Double.NaN;
        }
    }

    public void process(long t, int f) throws AudioException {
        if (this.meter) {
            if (this.o + f < this.z) {
                this.left.get(0, this.x, this.o, f);
                this.right.get(0, this.y, this.o, f);
                this.o += f;
            } else {
                int i = this.z - this.o;
                this.left.get(0, this.x, this.o, i);
                this.right.get(0, this.y, this.o, i);
                if (f > i) {
                    this.o = f - i;
                    this.left.get(i, this.x, 0, this.o);
                    this.right.get(i, this.y, 0, this.o);
                } else {
                    this.o = 0;
                }
            }
        }
    }

    public void shutdown() throws AudioException {
    }

    public boolean isMeter() {
        return this.meter;
    }

    public void setMeter(boolean meter) {
        this.meter = meter;
    }
}

