/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.debug;

import com.spacekiller.util.sound.DoubleArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioInputPortType;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import com.waxmonster.timecode.debug.TimecodeMonitor;
import com.waxmonster.timecode.debug.TimecodeMonitorPanel;
import java.awt.Component;
import java.util.Properties;
import javax.swing.Icon;

public class TimecodeMonitorDevice
extends Device {
    public static final String KEY_REFRESH_RATE = "refreshRate";
    public static final String KEY_PIXEL_RATE = "pixelRate";
    public static final String KEY_METER_SCALE = "meterScale";
    public static final String KEY_METER_ENABLED = "meterEnabled";
    public static final String KEY_GRID_ENABLED = "gridEnabled";
    public static final String KEY_PROPORTIONAL = "proportional";
    public static final double MAX_PIXEL_RATE = 1.0;
    public static final double DEFAULT_PIXEL_RATE = 0.1;
    public static final double MAX_REFRESH_RATE = 1000.0;
    public static final double DEFAULT_REFRESH_RATE = 27.0;
    public static final double MIN_METER_SCALE = 0.1;
    public static final double MAX_METER_SCALE = 10.0;
    public static final double DEFAULT_METER_SCALE = 1.0;
    private final AudioSupportImpl audioSupport = new AudioSupportImpl();
    private AudioInputPort leftInputPort;
    private AudioInputPort rightInputPort;
    private double refreshRate;
    private double pixelRate;
    private double meterScale;
    private boolean meterEnabled;
    private TimecodeMonitor monitor;
    private TimecodeMonitorPanel monitorPanel;
    private boolean gridEnabled = true;
    private boolean proportional = true;

    public TimecodeMonitorDevice(DeviceProvider provider, String name, Icon iconColor16) throws StudioException {
        super(provider, name);
        this.setIconColor16(iconColor16);
        this.pixelRate = 0.1;
        this.meterScale = 1.0;
        this.leftInputPort = new AudioInputPort("Left-In", AudioInputPortType.LEFT, (AudioSupport)this.audioSupport);
        this.rightInputPort = new AudioInputPort("Right-In", AudioInputPortType.RIGHT, (AudioSupport)this.audioSupport);
        this.addPort((Port)this.leftInputPort);
        this.addPort((Port)this.rightInputPort);
        this.setMeterEnabled(true);
    }

    protected void activate() throws StudioException {
    }

    protected void deactivate() throws StudioException {
        this.audioSupport.reset();
    }

    public synchronized Component getCustomizer() {
        if (this.monitorPanel == null) {
            this.monitorPanel = new TimecodeMonitorPanel();
            this.monitorPanel.setOpaque(false);
            this.monitorPanel.setDevice(this);
            this.monitorPanel.setMeterScale(this.meterScale);
            this.adjustTimerDelay();
            this.monitorPanel.setMeter(this.meterEnabled);
            this.monitorPanel.setStudio(this.getStudio());
            this.monitorPanel.setMonitor(this.monitor);
            this.monitorPanel.setGridEnabled(this.gridEnabled);
            this.monitorPanel.setProportional(this.proportional);
        }
        return this.monitorPanel;
    }

    public synchronized Properties getProperties() {
        double pixels;
        double rate;
        Properties props = super.getProperties();
        props.put(KEY_METER_ENABLED, String.valueOf(this.isMeterEnabled()));
        props.put(KEY_GRID_ENABLED, String.valueOf(this.isGridEnabled()));
        props.put(KEY_PROPORTIONAL, String.valueOf(this.isProportional()));
        double scale = this.getMeterScale();
        if (scale > 0.0) {
            props.put(KEY_METER_SCALE, String.valueOf(scale));
        }
        if ((rate = this.getRefreshRate()) > 0.0) {
            props.put(KEY_REFRESH_RATE, String.valueOf(rate));
        }
        if ((pixels = this.getPixelRate()) > 0.0) {
            props.put(KEY_PIXEL_RATE, String.valueOf(pixels));
        }
        return props;
    }

    protected void applyProperty(String key, String value) {
        if (KEY_REFRESH_RATE.equals(key)) {
            if (value != null) {
                this.setRefreshRate(this.parseDoubleProperty(key, value));
            }
            return;
        }
        if (KEY_PIXEL_RATE.equals(key)) {
            if (value != null) {
                this.setPixelRate(this.parseDoubleProperty(key, value));
            }
            return;
        }
        if (KEY_METER_SCALE.equals(key)) {
            if (value != null) {
                this.setMeterScale(this.parseDoubleProperty(key, value));
            }
            return;
        }
        if (KEY_METER_ENABLED.equals(key)) {
            if (value != null) {
                this.setMeterEnabled("true".equalsIgnoreCase(value));
            }
            return;
        }
        if (KEY_GRID_ENABLED.equals(key)) {
            if (value != null) {
                this.setGridEnabled("true".equalsIgnoreCase(value));
            }
            return;
        }
        if (KEY_PROPORTIONAL.equals(key)) {
            if (value != null) {
                this.setProportional("true".equalsIgnoreCase(value));
            }
            return;
        }
    }

    public boolean isMeterEnabled() {
        return this.meterEnabled;
    }

    public synchronized void setMeterEnabled(boolean meterEnabled) {
        TimecodeMonitorPanel panel;
        if (this.meterEnabled == meterEnabled) {
            return;
        }
        this.meterEnabled = meterEnabled;
        TimecodeMonitor mon = this.monitor;
        if (mon != null) {
            mon.setMeter(meterEnabled);
        }
        if ((panel = this.monitorPanel) != null) {
            panel.setMeter(meterEnabled);
        }
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public synchronized void setGridEnabled(boolean gridEnabled) {
        if (this.gridEnabled == gridEnabled) {
            return;
        }
        this.gridEnabled = gridEnabled;
        TimecodeMonitorPanel panel = this.monitorPanel;
        if (panel != null) {
            panel.setGridEnabled(gridEnabled);
        }
    }

    public double getRefreshRate() {
        return this.refreshRate;
    }

    public synchronized void setRefreshRate(double refreshRate) {
        if (this.refreshRate == refreshRate) {
            return;
        }
        this.refreshRate = refreshRate;
        this.adjustTimerDelay();
    }

    protected void adjustTimerDelay() {
        TimecodeMonitorPanel panel = this.monitorPanel;
        if (panel == null) {
            return;
        }
        int timerDelay = -1;
        double rate = this.refreshRate;
        if (rate <= 0.0) {
            rate = 27.0;
        }
        if (rate > 0.0) {
            long millis = Math.round(1000.0 / rate);
            if (millis > Integer.MAX_VALUE) {
                millis = Integer.MAX_VALUE;
            }
            timerDelay = (int)millis;
        }
        if (timerDelay <= 0) {
            timerDelay = 1;
        }
        panel.setDelay(timerDelay);
    }

    protected void studioChanged(Studio studio) {
        super.studioChanged(studio);
        TimecodeMonitorPanel panel = this.monitorPanel;
        if (panel != null) {
            panel.setStudio(studio);
        }
    }

    public double getPixelRate() {
        return this.pixelRate;
    }

    public void setPixelRate(double pixelRate) {
        if (pixelRate > 1.0) {
            pixelRate = 1.0;
        }
        this.pixelRate = pixelRate;
    }

    public double getMeterScale() {
        return this.meterScale;
    }

    public void setMeterScale(double meterScale) {
        if (meterScale > 10.0) {
            meterScale = 10.0;
        }
        if (meterScale < 0.1) {
            meterScale = 0.1;
        }
        this.meterScale = meterScale;
        TimecodeMonitorPanel panel = this.monitorPanel;
        if (panel != null) {
            panel.setMeterScale(meterScale);
        }
    }

    public boolean isProportional() {
        return this.proportional;
    }

    public void setProportional(boolean proportional) {
        this.proportional = proportional;
        TimecodeMonitorPanel panel = this.monitorPanel;
        if (panel != null) {
            panel.setProportional(proportional);
        }
    }

    protected class AudioSyncGroupImpl
    extends AudioSyncGroup {
        public AudioSyncGroupImpl(String name, AudioInputPort[] inputPorts, AudioOutputPort[] outputPorts) {
            super(name, inputPorts, outputPorts);
        }

        public AudioProcessor createAudioProcessor(SampleBuffer[] in, SampleBuffer[] out) throws AudioException {
            int pixels;
            if (in.length < 2) {
                throw new AudioException("Invalid number of input channels: " + in.length + " != 2 (stereo)");
            }
            SampleBuffer left = in[0];
            SampleBuffer right = in[1];
            float rate = 0.0f;
            int frames = 0;
            if (left != null) {
                rate = left.getFrameRate();
                frames = left.getSamples();
            } else if (right != null) {
                rate = right.getFrameRate();
                frames = right.getSamples();
            }
            if (rate <= 0.0f || frames <= 0) {
                return null;
            }
            if (left == null) {
                left = new DoubleArraySampleBuffer(1, frames, rate, new double[frames]);
            }
            if (right == null) {
                right = new DoubleArraySampleBuffer(1, frames, rate, new double[frames]);
            }
            if ((pixels = (int)((double)rate * TimecodeMonitorDevice.this.pixelRate)) < 1) {
                pixels = 1;
            }
            TimecodeMonitorDevice.this.monitor = new TimecodeMonitor(left, right, pixels);
            TimecodeMonitorDevice.this.monitor.setMeter(TimecodeMonitorDevice.this.meterEnabled);
            TimecodeMonitorPanel amp = TimecodeMonitorDevice.this.monitorPanel;
            if (amp != null) {
                amp.setMonitor(TimecodeMonitorDevice.this.monitor);
            }
            return TimecodeMonitorDevice.this.monitor;
        }
    }

    protected class AudioSupportImpl
    extends AudioSupport {
        private AudioSyncGroup syncGroup;

        protected AudioSupportImpl() {
        }

        public synchronized void reset() {
            TimecodeMonitorPanel amp;
            if (this.syncGroup != null) {
                this.syncGroup = null;
            }
            if (TimecodeMonitorDevice.this.monitor != null) {
                TimecodeMonitorDevice.this.monitor = null;
            }
            if ((amp = TimecodeMonitorDevice.this.monitorPanel) != null) {
                amp.setMonitor(null);
            }
        }

        public synchronized AudioSyncGroup getAudioSyncGroup(AudioPort port) {
            if (this.syncGroup == null) {
                this.syncGroup = new AudioSyncGroupImpl(TimecodeMonitorDevice.this.getName(), new AudioInputPort[]{TimecodeMonitorDevice.this.leftInputPort, TimecodeMonitorDevice.this.rightInputPort}, new AudioOutputPort[0]);
            }
            return this.syncGroup;
        }
    }
}

