/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.debug;

import com.spacekiller.util.Tools;
import com.waxmonster.audio.AudioPortType;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceInfo;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.StudioException;
import com.waxmonster.timecode.debug.TimecodeMonitorDevice;
import com.waxmonster.timecode.debug.TimecodeMonitorDeviceInfo;
import javax.swing.Icon;

public class TimecodeMonitorDeviceProvider
extends DeviceProvider {
    public static final String PROVIDER_NAME = "TimecodeMonitorDeviceProvider";
    public static final String DEVICE_CATEGORY_NAME = "Audio Tools";

    public TimecodeMonitorDeviceProvider() {
        super(PROVIDER_NAME);
        this.initCommonAudioDeviceProvider();
    }

    protected void initCommonAudioDeviceProvider() {
        String name = "Timecode Monitor";
        String tooltip = "Timecode monitor";
        Icon monitorIcon = Tools.getIcon(TimecodeMonitorDeviceProvider.class, (String)"/com/waxmonster/timecode/debug/icons/timecode_monitor_icon16.png");
        TimecodeMonitorDeviceInfo monitorInfo = new TimecodeMonitorDeviceInfo(name, tooltip, monitorIcon);
        this.addDeviceInfo(monitorInfo);
    }

    public void refreshDeviceInfo() {
    }

    public Device createDevice(DeviceInfo info) throws StudioException {
        if (info == null) {
            return null;
        }
        String name = info.getDeviceName();
        Icon icon = info.getIcon(1);
        if (info instanceof TimecodeMonitorDeviceInfo) {
            return new TimecodeMonitorDevice(this, name, icon);
        }
        return null;
    }

    public PortType getPortType(String typeName) {
        return AudioPortType.getAudioPortType((String)typeName);
    }
}

