/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.debug;

import com.waxmonster.timecode.debug.TimecodeMonitor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

public class TimecodeMonitorDisplay
extends JComponent {
    private static final long serialVersionUID = 1643384064078002113L;
    private Color[] colors;
    private TimecodeMonitor monitor;
    private double scale;
    private boolean proportional;
    private boolean gridEnabled;
    private Color gridColor = Color.DARK_GRAY;
    private Color gridBackground = Color.BLACK;

    public TimecodeMonitorDisplay() {
        this.setBackground(Color.BLACK);
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(200, 200));
    }

    public TimecodeMonitorDisplay(Color[] colors, double scale) {
        this();
        this.setColors(colors);
        this.setScale(scale);
    }

    @Override
    protected void paintComponent(Graphics g) {
        TimecodeMonitor mon;
        int width = this.getWidth();
        int height = this.getHeight();
        int cx = width / 2;
        int cy = height / 2;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        if (this.proportional) {
            height = width = Math.min(width, height) - 4;
        }
        int gx = (int)Math.round((double)cx - (double)width / 2.0);
        int gy = (int)Math.round((double)cy - (double)height / 2.0);
        g.setColor(this.gridBackground);
        g.fillRect(gx, gy, width, height);
        if (this.gridEnabled) {
            g.setColor(this.gridColor);
            g.drawRect(gx, gy, width, height);
            g.drawLine(cx, gy, cx, gy + height);
            g.drawLine(gx, cy, gx + width, cy);
        }
        if ((mon = this.monitor) == null) {
            return;
        }
        double sx = (double)width * this.scale / 2.0;
        double sy = (double)height * this.scale / 2.0;
        Color[] cols = this.colors;
        if (cols == null) {
            return;
        }
        int nc = cols.length;
        int z = mon.z;
        int o = mon.o;
        int px = -1;
        int py = -1;
        for (int i = 0; i < z; ++i) {
            double x = mon.x[o];
            double y = mon.y[o];
            if (x == x && y == y) {
                int nx = (int)Math.round((double)cx + x * sx);
                int ny = (int)Math.round((double)cy + y * sy);
                if (px >= 0) {
                    g.setColor(cols[nc * i / z]);
                    g.drawLine(px, py, nx, ny);
                }
                px = nx;
                py = ny;
            } else {
                px = -1;
                py = -1;
            }
            ++o;
            o %= z;
        }
    }

    public TimecodeMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(TimecodeMonitor monitor) {
        this.monitor = monitor;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.doLayout();
    }

    public boolean isProportional() {
        return this.proportional;
    }

    public void setProportional(boolean proportional) {
        this.proportional = proportional;
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public void setGridEnabled(boolean gridEnabled) {
        this.gridEnabled = gridEnabled;
    }

    public Color[] getColors() {
        return this.colors;
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    public Color getGridBackground() {
        return this.gridBackground;
    }

    public void setGridBackground(Color gridBackground) {
        this.gridBackground = gridBackground;
    }
}

