/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.debug;

import com.spacekiller.util.Timer;
import com.waxmonster.studio.Studio;
import com.waxmonster.timecode.debug.TimecodeMonitor;
import com.waxmonster.timecode.debug.TimecodeMonitorDevice;
import com.waxmonster.timecode.debug.TimecodeMonitorDisplay;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class TimecodeMonitorPanel
extends JPanel {
    private static final long serialVersionUID = -3989876747869783146L;
    private static final Logger logger = Logger.getLogger(TimecodeMonitorPanel.class.getName());
    private static Color[] pixelColors;
    private final Update update = new Update();
    private final UpdateLater updateLater = new UpdateLater();
    private volatile boolean updatePending = false;
    private Studio studio;
    private TimecodeMonitorDevice device;
    private TimecodeMonitor monitor;
    private Timer timer;
    private int delay = 100;
    private TimecodeMonitorDisplay display;
    private boolean refreshing;
    private boolean meter;
    private double meterScale;
    private boolean gridEnabled;
    private boolean proportional;
    private MouseHandler mouseHandler = new MouseHandler();
    private HierarchyHandler hierarchyHandler = new HierarchyHandler();
    private JPopupMenu popupMenu;
    private JCheckBoxMenuItem popupItemTimecodeMeter;

    public TimecodeMonitorPanel() {
        this.setLayout(new GridLayout(1, 1));
        this.initTimecodeMonitorPanel();
    }

    protected void initTimecodeMonitorPanel() {
        this.display = new TimecodeMonitorDisplay(TimecodeMonitorPanel.getPixelColors(), 1.0);
        this.display.setOpaque(true);
        this.add(this.display);
        this.addHierarchyListener(this.hierarchyHandler);
        this.addMouseListener(this.mouseHandler);
        this.display.addMouseListener(this.mouseHandler);
        this.popupMenu = new JPopupMenu();
        JMenuItem popupItemRefreshRate = new JMenuItem("Refresh Rate...");
        this.popupMenu.add(popupItemRefreshRate);
        popupItemRefreshRate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimecodeMonitorPanel.this.showRefreshRateDialog();
            }
        });
        popupItemRefreshRate.setToolTipText("Set refresh rate...");
        JMenuItem popupItemMeterScale = new JMenuItem("Scale...");
        this.popupMenu.add(popupItemMeterScale);
        popupItemMeterScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimecodeMonitorPanel.this.showMeterScaleDialog();
            }
        });
        popupItemMeterScale.setToolTipText("Set display scale factor...");
        this.popupItemTimecodeMeter = new JCheckBoxMenuItem("Timecode Meter");
        this.popupMenu.add(this.popupItemTimecodeMeter);
        this.popupItemTimecodeMeter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!TimecodeMonitorPanel.this.refreshing) {
                    TimecodeMonitorPanel.this.setMeter(e.getStateChange() == 1);
                }
            }
        });
        this.popupItemTimecodeMeter.setToolTipText("Toggle timecode meter (on/off)");
    }

    public static Color[] getPixelColors() {
        if (pixelColors == null) {
            int num = 255;
            Color[] cols = new Color[num];
            for (int i = 0; i < num; ++i) {
                cols[i] = new Color(0, i, 0);
            }
            pixelColors = cols;
        }
        return pixelColors;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
        Timer tima = this.timer;
        if (tima != null) {
            tima.setDelay(delay);
        }
    }

    public TimecodeMonitorDevice getDevice() {
        return this.device;
    }

    public void setDevice(TimecodeMonitorDevice device) {
        this.device = device;
    }

    public Studio getStudio() {
        return this.studio;
    }

    public void setStudio(Studio studio) {
        if (this.studio == studio) {
            return;
        }
        this.studio = studio;
        Timer tima = null;
        if (studio != null) {
            tima = studio.createTimer((Runnable)this.updateLater, this.delay);
        }
        this.timer = tima;
    }

    public TimecodeMonitor getMonitor() {
        return this.monitor;
    }

    public synchronized void setMonitor(TimecodeMonitor newMonitor) {
        if (this.monitor == newMonitor) {
            return;
        }
        this.monitor = newMonitor;
        this.startStopMeter();
    }

    public boolean isMeter() {
        return this.meter;
    }

    public synchronized void setMeter(boolean meter) {
        TimecodeMonitorDevice amd;
        if (this.meter == meter) {
            return;
        }
        this.meter = meter;
        if (this.popupItemTimecodeMeter.isSelected() != meter) {
            this.popupItemTimecodeMeter.setSelected(meter);
        }
        if ((amd = this.device) != null && amd.isMeterEnabled() != meter) {
            amd.setMeterEnabled(meter);
        }
        this.startStopMeter();
    }

    protected void startStopMeter() {
        Timer tima = this.timer;
        if (tima == null) {
            return;
        }
        TimecodeMonitor mon = this.monitor;
        if (mon != null && this.meter && this.isShowing()) {
            this.display.setMonitor(mon);
            if (!tima.isActive()) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Starting TimecodeMonitor update timer: " + this.timer);
                }
                tima.start();
            }
        } else {
            this.display.setMonitor(null);
            if (tima.isActive()) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Stopping TimecodeMonitor update timer: " + this.timer);
                }
                tima.stop();
                SwingUtilities.invokeLater(this.update);
            }
        }
    }

    protected void showMonitorPopup(Component comp, int x, int y) {
        if (this.popupMenu != null && comp != null) {
            this.popupMenu.show(comp, x, y);
        }
    }

    protected void showRefreshRateDialog() {
        double newRate;
        String initialSelectionValue;
        String message;
        String newValue;
        if (this.device == null || this.refreshing) {
            return;
        }
        double oldRate = this.device.getRefreshRate();
        if (oldRate <= 0.0) {
            oldRate = 27.0;
        }
        if ((newValue = JOptionPane.showInputDialog(this, message = "Refresh Rate: > 0.0 .. max. 1000.0 / sec.", initialSelectionValue = String.valueOf(oldRate))) == null) {
            return;
        }
        if ((newValue = newValue.trim()).length() < 1) {
            return;
        }
        try {
            newRate = Double.parseDouble(newValue);
        }
        catch (NumberFormatException e) {
            return;
        }
        if (newRate > 0.0 && newRate <= 1000.0) {
            try {
                this.device.setRefreshRate(newRate);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public double getMeterScale() {
        return this.meterScale;
    }

    public void setMeterScale(double meterScale) {
        this.meterScale = meterScale;
        this.display.setScale(meterScale);
    }

    protected void showMeterScaleDialog() {
        double newScale;
        String initialSelectionValue;
        String message;
        String newValue;
        if (this.device == null || this.refreshing) {
            return;
        }
        double oldScale = this.device.getMeterScale();
        if (oldScale <= 0.0) {
            oldScale = 1.0;
        }
        if ((newValue = JOptionPane.showInputDialog(this, message = "Scale Factor: 1 = normal / 0.1 .. max. 10.0", initialSelectionValue = String.valueOf(oldScale))) == null) {
            return;
        }
        if ((newValue = newValue.trim()).length() < 1) {
            return;
        }
        try {
            newScale = Double.parseDouble(newValue);
        }
        catch (NumberFormatException e) {
            return;
        }
        if (newScale >= 0.1 && newScale <= 10.0) {
            try {
                this.device.setMeterScale(newScale);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public void setGridEnabled(boolean gridEnabled) {
        if (this.gridEnabled == gridEnabled) {
            return;
        }
        this.gridEnabled = gridEnabled;
        this.display.setGridEnabled(gridEnabled);
        this.display.validate();
        this.display.repaint();
    }

    public boolean isProportional() {
        return this.proportional;
    }

    public void setProportional(boolean proportional) {
        if (this.proportional == proportional) {
            return;
        }
        this.proportional = proportional;
        this.display.setProportional(proportional);
        this.display.validate();
        this.display.repaint();
    }

    protected class HierarchyHandler
    implements HierarchyListener {
        protected HierarchyHandler() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            long flags = e.getChangeFlags();
            if ((flags & 4L) != 0L) {
                TimecodeMonitorPanel.this.startStopMeter();
            }
        }
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (e.isPopupTrigger()) {
                TimecodeMonitorPanel.this.showMonitorPopup(e.getComponent(), e.getX(), e.getY());
                e.consume();
                return;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (e.isPopupTrigger()) {
                TimecodeMonitorPanel.this.showMonitorPopup(e.getComponent(), e.getX(), e.getY());
                e.consume();
                return;
            }
        }
    }

    protected class UpdateLater
    implements Runnable {
        protected UpdateLater() {
        }

        @Override
        public void run() {
            if (!TimecodeMonitorPanel.this.updatePending) {
                TimecodeMonitorPanel.this.updatePending = true;
                SwingUtilities.invokeLater(TimecodeMonitorPanel.this.update);
            }
        }
    }

    protected class Update
    implements Runnable {
        protected Update() {
        }

        @Override
        public void run() {
            TimecodeMonitorPanel.this.updatePending = false;
            TimecodeMonitorPanel.this.display.repaint();
        }
    }
}

