/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.debug;

import com.waxmonster.timecode.debug.TimecodeProducer;
import com.waxmonster.timecode.impl.LfsrTable;

public class TimecodeProducerImpl1
implements TimecodeProducer {
    private static final double PI2 = Math.PI * 2;
    private final double frameRate;
    private final double resolution;
    private final double waveFrames;
    private final int length;
    private final LfsrTable table;
    private double phaseShift;
    private double frameOfs;
    private double ampFactor0 = 0.5;
    private double ampFactor1 = 0.4;

    public TimecodeProducerImpl1(double frameRate, double resolution, LfsrTable table) {
        this.frameRate = frameRate;
        this.table = table;
        this.length = table.length();
        this.resolution = resolution;
        this.waveFrames = frameRate / resolution;
    }

    public double getResolution() {
        return this.resolution;
    }

    @Override
    public double getFrameRate() {
        return this.frameRate;
    }

    @Override
    public double getPhaseShift() {
        return this.phaseShift;
    }

    @Override
    public void setPhaseShift(double phaseShift) {
        this.phaseShift = phaseShift;
    }

    @Override
    public double getTransRange() {
        return 0.0;
    }

    @Override
    public void setTransRange(double transRange) {
    }

    @Override
    public double getFrameOffset() {
        return this.frameOfs;
    }

    @Override
    public void setFrameOffset(double ofs) {
        this.frameOfs = ofs;
    }

    @Override
    public double getAmpFactor0() {
        return this.ampFactor0;
    }

    @Override
    public void setAmpFactor0(double ampFactor0) {
        this.ampFactor0 = ampFactor0;
    }

    @Override
    public double getAmpFactor1() {
        return this.ampFactor1;
    }

    @Override
    public void setAmpFactor1(double ampFactor1) {
        this.ampFactor1 = ampFactor1;
    }

    @Override
    public double produce(double pos) {
        double wave = (pos += this.frameOfs) / this.waveFrames;
        long slot = (long)wave;
        double w = wave - (double)slot;
        double amp = 0.0;
        if (slot >= 0L && slot < (long)this.length) {
            int tc = this.table.timecode((int)slot);
            amp = (tc & 1) == 0 ? this.ampFactor0 : this.ampFactor1;
        }
        return Math.sin((w + this.phaseShift) * (Math.PI * 2)) * amp;
    }
}

