/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.debug;

import com.waxmonster.timecode.debug.TimecodeProducer;
import com.waxmonster.timecode.impl.LfsrTable;

public class TimecodeProducerImpl3
implements TimecodeProducer {
    private static final double PI2 = Math.PI * 2;
    private final double frameRate;
    private final double resolution;
    private final double waveFrames;
    private final int length;
    private final LfsrTable table;
    private double phaseShift;
    private double transRange;
    private double frameOfs;
    private double ampFactor0 = 0.5;
    private double ampFactor1 = 0.4;

    public TimecodeProducerImpl3(double frameRate, double resolution, LfsrTable table) {
        this.frameRate = frameRate;
        this.table = table;
        this.length = table.length();
        this.resolution = resolution;
        this.waveFrames = frameRate / resolution;
    }

    public double getResolution() {
        return this.resolution;
    }

    @Override
    public double getFrameRate() {
        return this.frameRate;
    }

    @Override
    public double getPhaseShift() {
        return this.phaseShift;
    }

    @Override
    public void setPhaseShift(double phaseShift) {
        this.phaseShift = phaseShift;
    }

    @Override
    public double getTransRange() {
        return this.transRange;
    }

    @Override
    public void setTransRange(double transRange) {
        this.transRange = transRange;
    }

    @Override
    public double getFrameOffset() {
        return this.frameOfs;
    }

    @Override
    public void setFrameOffset(double ofs) {
        this.frameOfs = ofs;
    }

    @Override
    public double getAmpFactor0() {
        return this.ampFactor0;
    }

    @Override
    public void setAmpFactor0(double ampFactor0) {
        this.ampFactor0 = ampFactor0;
    }

    @Override
    public double getAmpFactor1() {
        return this.ampFactor1;
    }

    @Override
    public void setAmpFactor1(double ampFactor1) {
        this.ampFactor1 = ampFactor1;
    }

    @Override
    public double produce(double pos) {
        double r;
        boolean nextZero;
        double wave = (pos + this.frameOfs) / this.waveFrames;
        long slot = (long)wave;
        if (slot < 0L || slot >= (long)this.length) {
            return 0.0;
        }
        double w = wave - (double)slot;
        int tc = this.table.timecode((int)slot);
        boolean currZero = (tc & 1) == 0;
        boolean bl = nextZero = (tc & 2) == 0;
        if (currZero == nextZero) {
            r = nextZero ? this.ampFactor0 : this.ampFactor1;
        } else {
            double z = this.transRange;
            if (w < z) {
                double v = w / z;
                double r1 = currZero ? this.ampFactor0 : this.ampFactor1;
                double r2 = nextZero ? this.ampFactor0 : this.ampFactor1;
                double t1 = r1 + (r2 - r1) * Math.sin(v * Math.PI / 2.0);
                double t2 = r2 + (r1 - r2) * Math.sin((1.0 - v) * Math.PI / 2.0);
                r = t1 * v + t2 * (1.0 - v);
            } else {
                r = nextZero ? this.ampFactor0 : this.ampFactor1;
            }
        }
        return Math.sin((w + this.phaseShift) * (Math.PI * 2)) * r;
    }
}

