/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.thread;

import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.thread.ThreadPool;
import com.spacekiller.util.thread.Work;
import com.spacekiller.util.thread.WorkerThread;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultThreadPool
implements ThreadPool {
    private static final Logger logger = Logger.getLogger(DefaultThreadPool.class.getName());
    private final ThreadManager threadManager;
    private String namePrefix;
    private int priority;
    private boolean daemon;
    private ClassLoader contextLoader;
    private volatile boolean closed;
    private long nextId = 1L;
    private Worker first;
    private Worker last;
    private List workers;
    private volatile int threadCount;
    private int minThreadCount;
    private int maxThreadCount;
    private long idleTimeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultThreadPool(ThreadManager threadManager, String namePrefix, int priority, boolean daemon, ClassLoader contextLoader, int minThreadCount, int maxThreadCount, long idleTimeout) throws InterruptedException {
        this.threadManager = threadManager;
        this.namePrefix = namePrefix;
        this.priority = priority;
        this.daemon = daemon;
        this.contextLoader = contextLoader;
        this.minThreadCount = minThreadCount;
        this.maxThreadCount = maxThreadCount;
        this.idleTimeout = idleTimeout;
        this.workers = new LinkedList();
        boolean success = false;
        try {
            for (int i = minThreadCount - 1; i >= 0; --i) {
                long id;
                ++this.nextId;
                Worker worker = this.createWorker(id, namePrefix + id);
                this.workers.add(worker);
                ++this.threadCount;
                worker.start();
            }
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    public DefaultThreadPool(ThreadManager threadManager, String namePrefix, int priority, boolean daemon, int minThreadCount, int maxThreadCount, long idleTimeout) throws InterruptedException {
        this(threadManager, namePrefix, priority, daemon, ClassLoader.getSystemClassLoader(), minThreadCount, maxThreadCount, idleTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Work start(Runnable target) throws InterruptedException {
        Worker worker;
        DefaultThreadPool defaultThreadPool = this;
        synchronized (defaultThreadPool) {
            while (this.first == null) {
                if (this.closed) {
                    throw new IllegalStateException("Thread pool is closed!");
                }
                if (this.threadCount < this.maxThreadCount) {
                    long id;
                    ++this.nextId;
                    worker = this.createWorker(id, this.namePrefix + id);
                    this.workers.add(worker);
                    ++this.threadCount;
                    worker.start();
                }
                this.waitPool();
            }
            worker = this.first;
            this.first = worker.next;
            if (this.first == null) {
                this.last = null;
            } else {
                this.first.prev = null;
            }
            worker.next = null;
            worker.idle = false;
            worker.used = true;
        }
        WorkImpl work = new WorkImpl(target, worker);
        worker.start(work);
        return work;
    }

    @Override
    public Thread getThread(Work work) {
        return ((WorkImpl)work).thread;
    }

    protected void waitPool() throws InterruptedException {
        this.wait(0L);
    }

    @Override
    public synchronized void close() throws InterruptedException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.first = null;
        this.last = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Stopping worker threads: " + this);
        }
        Iterator i = this.workers.iterator();
        while (i.hasNext()) {
            Worker worker = (Worker)i.next();
            i.remove();
            --this.threadCount;
            worker.shutdown();
            worker.join();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Worker threads stopped: " + this);
        }
        this.workers = null;
        this.first = null;
        this.last = null;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected Worker createWorker(long id, String name) {
        Worker worker = new Worker(id, name);
        ClassLoader cl = this.contextLoader;
        if (cl != null) {
            worker.setContextClassLoader(cl);
        }
        worker.setDaemon(this.daemon);
        worker.setPriority(this.priority);
        return worker;
    }

    protected synchronized void pool(Worker worker, boolean worked) {
        if (worked) {
            worker.used = false;
            if (worker.idle) {
                return;
            }
        } else if (worker.idle || worker.used) {
            return;
        }
        worker.idle = true;
        worker.next = this.first;
        if (this.first == null) {
            this.last = worker;
        } else {
            this.first.prev = worker;
        }
        this.first = worker;
        this.notifyAll();
    }

    protected synchronized void timeout(Worker worker) {
        if (worker.idle && this.threadCount > this.minThreadCount && !worker.used) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Idle timeout: " + worker);
            }
            worker.active = false;
            if (this.workers.remove(worker)) {
                --this.threadCount;
                if (worker == this.first) {
                    this.first = worker.next;
                    if (this.first != null) {
                        this.first.prev = null;
                    }
                } else {
                    worker.prev.next = worker.next;
                }
                if (worker == this.last) {
                    this.last = worker.prev;
                    if (this.last != null) {
                        this.last.next = null;
                    }
                } else {
                    worker.next.prev = worker.prev;
                }
                worker.prev = null;
                worker.next = null;
            }
        }
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getMinThreadCount() {
        return this.minThreadCount;
    }

    public synchronized void setMinThreadCount(int minThreadCount) {
        if (this.minThreadCount == minThreadCount) {
            return;
        }
        this.minThreadCount = minThreadCount;
        if (this.threadCount < minThreadCount) {
            // empty if block
        }
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public synchronized void setMaxThreadCount(int maxThreadCount) {
        if (this.maxThreadCount == maxThreadCount) {
            return;
        }
        this.maxThreadCount = maxThreadCount;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdleTimeout(long idleTimeout) {
        DefaultThreadPool defaultThreadPool = this;
        synchronized (defaultThreadPool) {
            if (this.idleTimeout == idleTimeout) {
                return;
            }
            this.idleTimeout = idleTimeout;
        }
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public synchronized void setNamePrefix(String namePrefix) {
        if (this.namePrefix == namePrefix) {
            return;
        }
        this.namePrefix = namePrefix;
        Worker worker = this.first;
        while (worker != null) {
            worker.setName(namePrefix + worker.id);
            worker = worker.next;
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public synchronized void setPriority(int priority) {
        if (this.priority == priority) {
            return;
        }
        this.priority = priority;
        Worker worker = this.first;
        while (worker != null) {
            worker.setPriority(priority);
            worker = worker.next;
        }
    }

    protected synchronized void checkConsistency() {
        Worker worker = this.first;
        Worker prev = null;
        while (worker != null) {
            if (!worker.idle) {
                throw new IllegalStateException("worker=" + worker + ", not idle!");
            }
            if (worker.prev != prev) {
                throw new IllegalStateException("worker=" + worker + ", prev=" + worker.prev + " != " + prev);
            }
            prev = worker;
            worker = worker.next;
        }
        if (prev != this.last) {
            throw new IllegalStateException("last=" + prev + " != " + this.last);
        }
    }

    protected class Worker
    extends Thread
    implements WorkerThread {
        long id;
        Worker prev;
        Worker next;
        volatile boolean active;
        boolean idle;
        boolean used;
        private WorkImpl work;

        public Worker(long id, String name) {
            super(name);
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                this.active = true;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Worker thread started: " + this);
                }
                if (DefaultThreadPool.this.threadManager != null) {
                    DefaultThreadPool.this.threadManager.registerThread(Thread.currentThread());
                }
                boolean worked = false;
                while (true) {
                    WorkImpl w;
                    Worker worker = this;
                    synchronized (worker) {
                        w = this.work;
                        if (w == null) {
                            DefaultThreadPool.this.pool(this, worked);
                            worked = false;
                            try {
                                if (DefaultThreadPool.this.idleTimeout > 0L) {
                                    long delay;
                                    long base = System.currentTimeMillis();
                                    long now = 0L;
                                    while (this.work == null && this.active && (delay = DefaultThreadPool.this.idleTimeout - now) > 0L) {
                                        this.wait(delay);
                                        now = System.currentTimeMillis() - base;
                                    }
                                } else {
                                    while (this.work == null && this.active) {
                                        this.wait(0L);
                                    }
                                }
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            if ((w = this.work) == null) {
                                if (!this.active) return;
                                DefaultThreadPool.this.timeout(this);
                                if (!this.active) return;
                                continue;
                            }
                        }
                        this.work = null;
                    }
                    Runnable r = w.target;
                    Throwable x = null;
                    if (r != null) {
                        try {
                            r.run();
                        }
                        catch (Throwable e) {
                            x = e;
                        }
                    }
                    WorkImpl workImpl = w;
                    synchronized (workImpl) {
                        w.error = x;
                        w.alive = false;
                        w.notifyAll();
                    }
                    worked = true;
                }
            }
            finally {
                this.active = false;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Worker thread stopped: " + this);
                }
                if (DefaultThreadPool.this.threadManager != null) {
                    DefaultThreadPool.this.threadManager.unregisterThread(Thread.currentThread());
                }
            }
        }

        protected synchronized void start(WorkImpl w) {
            this.work = w;
            this.notifyAll();
        }

        protected synchronized void shutdown() {
            this.active = false;
            this.notifyAll();
        }

        @Override
        public boolean isRunning() {
            return this.active;
        }

        @Override
        public boolean isIdle() {
            return this.idle;
        }
    }

    protected class WorkImpl
    implements Work {
        Runnable target;
        Throwable error;
        boolean alive;
        Thread thread;

        public WorkImpl(Runnable target, Thread thread) {
            this.target = target;
            this.thread = thread;
            this.alive = true;
        }

        @Override
        public int getPriority() {
            return DefaultThreadPool.this.priority;
        }

        @Override
        public boolean isDaemon() {
            return DefaultThreadPool.this.daemon;
        }

        @Override
        public boolean isAlive() {
            return this.alive;
        }

        @Override
        public Throwable getException() {
            return this.error;
        }

        @Override
        public synchronized void join() throws InterruptedException {
            while (this.alive) {
                this.wait(0L);
            }
        }

        @Override
        public synchronized void join(long millis) throws InterruptedException {
            long base = System.currentTimeMillis();
            long now = 0L;
            if (millis < 0L) {
                throw new IllegalArgumentException("timeout value is negative");
            }
            if (millis == 0L) {
                while (this.alive) {
                    this.wait(0L);
                }
            } else {
                long delay;
                while (this.alive && (delay = millis - now) > 0L) {
                    this.wait(delay);
                    now = System.currentTimeMillis() - base;
                }
            }
        }

        @Override
        public void join(long millis, int nanos) throws InterruptedException {
            if (millis < 0L) {
                throw new IllegalArgumentException("timeout value is negative");
            }
            if (nanos < 0 || nanos > 999999) {
                throw new IllegalArgumentException("nanosecond timeout value out of range");
            }
            if (nanos >= 500000 || nanos != 0 && millis == 0L) {
                ++millis;
            }
            this.join(millis);
        }
    }
}

