/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.table;

import com.spacekiller.util.Tools;
import com.spacekiller.util.swing.SwingTools;
import com.spacekiller.util.table.TableExport;
import com.spacekiller.util.table.TableExportFormat;
import com.spacekiller.util.table.TableExportWizard;
import com.spacekiller.util.table.export.CsvTableExportFormat;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;

public class DefaultTableExportWizard
extends JPanel
implements TableExportWizard {
    private static final long serialVersionUID = 7067681716926008550L;
    private List formats;
    private TableExportFormat selectedFormat;
    private TableExport tableExport;
    private Component customizerComponent;
    private Object dialog = null;
    private boolean dialogConfirmed = false;
    private JLabel jLabel = null;
    private JComboBox jComboBoxFormat = null;
    private JPanel jPanelCustomizer = null;
    private JButton jButtonExport = null;
    private static final Logger logger = Logger.getLogger(DefaultTableExportWizard.class.getName());
    private PropertyChangeHandler propertyChangeHandler = new PropertyChangeHandler();

    public DefaultTableExportWizard() {
        this.initialize();
        this.initDefaultTableExportWizard();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints5.anchor = 13;
        gridBagConstraints5.gridy = 2;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints4.gridy = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints1.gridx = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.gridy = 0;
        this.jLabel = new JLabel();
        this.jLabel.setText("Format:");
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(368, 227));
        this.add((Component)this.jLabel, gridBagConstraints);
        this.add((Component)this.getJComboBoxFormat(), gridBagConstraints1);
        this.add((Component)this.getJPanelCustomizer(), gridBagConstraints4);
        this.add((Component)this.getJButtonExport(), gridBagConstraints5);
    }

    @Override
    public TableExport showTableExportDialog(JTable table) throws Exception {
        this.dialogConfirmed = false;
        JDialog dialog = new JDialog();
        this.dialog = dialog;
        dialog.setTitle("Export Table");
        dialog.setContentPane(this);
        dialog.setSize(500, 400);
        Tools.centerWindow((Window)dialog);
        dialog.setModal(true);
        dialog.setVisible(true);
        if (!this.dialogConfirmed) {
            return null;
        }
        TableExport export = this.tableExport;
        return export;
    }

    private JComboBox getJComboBoxFormat() {
        if (this.jComboBoxFormat == null) {
            this.jComboBoxFormat = new JComboBox();
            this.jComboBoxFormat.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DefaultTableExportWizard.this.refreshTableExport();
                }
            });
        }
        return this.jComboBoxFormat;
    }

    private JPanel getJPanelCustomizer() {
        if (this.jPanelCustomizer == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            this.jPanelCustomizer = new JPanel();
            this.jPanelCustomizer.setLayout(gridLayout);
            this.jPanelCustomizer.setOpaque(false);
            this.jPanelCustomizer.setBorder(BorderFactory.createEtchedBorder(1));
        }
        return this.jPanelCustomizer;
    }

    private JButton getJButtonExport() {
        if (this.jButtonExport == null) {
            this.jButtonExport = new JButton();
            this.jButtonExport.setText("Export");
            this.jButtonExport.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/table/icons/filetarget16.gif")));
            this.jButtonExport.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultTableExportWizard.this.dialogConfirmed = true;
                    ((JDialog)DefaultTableExportWizard.this.dialog).dispose();
                }
            });
        }
        return this.jButtonExport;
    }

    public void addTableExportFormat(TableExportFormat format) {
        if (format == null) {
            return;
        }
        this.formats.add(format);
        this.refreshFormats();
    }

    public void removeTableExportFormat(TableExportFormat format) {
        this.formats.remove(format);
        this.refreshFormats();
    }

    public void removeAllTableExportFormats() {
        this.formats.clear();
        this.refreshFormats();
    }

    protected void initDefaultTableExportWizard() {
        this.formats = new ArrayList();
        this.addTableExportFormat(new CsvTableExportFormat());
    }

    protected void refreshFormats() {
        SwingTools.clearJComboBox((JComboBox)this.getJComboBoxFormat());
        for (TableExportFormat format : this.formats) {
            this.getJComboBoxFormat().addItem(format);
        }
        this.checkEnable();
    }

    protected void checkEnable() {
        boolean enableExport = false;
        try {
            if (this.tableExport != null && this.selectedFormat != null) {
                enableExport = this.selectedFormat.isTableExportReady(this.tableExport);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.getJButtonExport().setEnabled(enableExport);
    }

    protected void refreshTableExport() {
        TableExportFormat newFormat;
        Component comp = this.customizerComponent;
        Object item = this.getJComboBoxFormat().getSelectedItem();
        if (item != null && (newFormat = (TableExportFormat)item) != this.selectedFormat) {
            try {
                if (this.tableExport != null) {
                    this.tableExport.removePropertyChangeListener(this.propertyChangeHandler);
                }
                this.selectedFormat = newFormat;
                this.tableExport = newFormat.createTableExport();
                comp = newFormat.createCustomizerComponent(this.tableExport);
                if (this.tableExport != null) {
                    this.tableExport.addPropertyChangeListener(this.propertyChangeHandler);
                }
            }
            catch (Exception e) {
                comp = null;
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (comp != this.customizerComponent) {
            this.customizerComponent = comp;
            this.getJPanelCustomizer().removeAll();
            if (comp != null) {
                this.getJPanelCustomizer().add(comp);
            }
        }
        this.getJPanelCustomizer().validate();
        this.getJPanelCustomizer().repaint();
        this.checkEnable();
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DefaultTableExportWizard.this.checkEnable();
        }
    }
}

