/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.table;

import com.spacekiller.util.AbstractExecution;
import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.Execution;
import com.spacekiller.util.ExecutionManager;
import com.spacekiller.util.Platform;
import com.spacekiller.util.RuntimeContext;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.DefaultDragSourceHandler;
import com.spacekiller.util.table.DefaultTableCellFormatter;
import com.spacekiller.util.table.DefaultTableExportWizard;
import com.spacekiller.util.table.TableCellFormatter;
import com.spacekiller.util.table.TableColumnProvider;
import com.spacekiller.util.table.TableExport;
import com.spacekiller.util.table.TableExportWizard;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableViewPanel
extends JPanel {
    private static final long serialVersionUID = 6176842880073067658L;
    private static final Logger logger = Logger.getLogger(TableViewPanel.class.getName());
    private BeansToolkit beansToolkit;
    private BeanDropSupport beanDropSupport;
    private TableExportWizard tableExportWizard;
    private DragGestureHandler dragGestureHandler = new DragGestureHandler();
    private DefaultDragSourceHandler dragSourceHandler = new DefaultDragSourceHandler();
    private TableCellRenderer tableCellRenderer;
    private TableCellRenderer tableHeaderRenderer;
    private TableColumnModel columnModel;
    private boolean autoCreateColumnModel = true;
    private TableHandler tableHandler = new TableHandler();
    private TableModel tableModel;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private JPopupMenu tablePopupMenu;
    private JPopupMenu tableHeaderPopupMenu;
    private JButton upperRightCornerButton;
    private JPopupMenu tableCornerPopupMenu;
    private TableMouseHandler tableMouseHandler = new TableMouseHandler();
    private TableHeaderMouseHandler tableHeaderMouseHandler = new TableHeaderMouseHandler();
    private ScrollPaneMouseHandler scrollPaneMouseHandler = new ScrollPaneMouseHandler();
    private EventListenerList actionListeners;
    private List headerActionListeners;

    public TableViewPanel() {
        this.initialize();
        this.initTableViewPanel();
    }

    private void initialize() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.setRows(1);
        this.setLayout(gridLayout);
        this.setSize(new Dimension(378, 238));
        this.add((Component)this.getJScrollPane(), null);
    }

    public BeanDropSupport getBeanDropSupport() {
        return this.beanDropSupport;
    }

    public void setBeanDropSupport(BeanDropSupport beanDropSupport) {
        this.beanDropSupport = beanDropSupport;
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public synchronized void setTableModel(TableModel newTableModel) {
        if (this.tableModel == newTableModel) {
            return;
        }
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableHandler);
        }
        this.tableModel = newTableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.tableHandler);
        }
        if (this.autoCreateColumnModel) {
            TableColumnModel columnModel = this.createTableColumnModel(this.tableModel);
            this.setColumnModel(columnModel);
        }
        this.getJTable().setModel(this.tableModel);
    }

    protected TableColumnModel createTableColumnModel(TableModel tableModel) {
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        if (tableModel != null) {
            try {
                ArrayList tableColumns = new ArrayList();
                this.createTableColumns(tableModel, tableColumns);
                int cols = tableColumns.size();
                for (int c = 0; c < cols; ++c) {
                    TableColumn column = (TableColumn)tableColumns.get(c);
                    columnModel.addColumn(column);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return columnModel;
    }

    protected void createTableColumns(TableModel tableModel, List destTableColumns) {
        int cols = tableModel.getColumnCount();
        for (int c = 0; c < cols; ++c) {
            String name = tableModel.getColumnName(c);
            TableColumn column = new TableColumn();
            column.setModelIndex(c);
            column.setHeaderValue(name);
            column.setHeaderRenderer(this.tableHeaderRenderer);
            column.setCellRenderer(this.tableCellRenderer);
            column.setMinWidth(10);
            column.setMaxWidth(500);
            destTableColumns.add(column);
        }
    }

    public TableExportWizard getTableExportWizard() {
        return this.tableExportWizard;
    }

    public void setTableExportWizard(TableExportWizard tableExportWizard) {
        this.tableExportWizard = tableExportWizard;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setOpaque(false);
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    protected final JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
        }
        return this.jTable;
    }

    public int[] getSelectedRows() {
        return this.getJTable().getSelectedRows();
    }

    public int[] getSelectedColumns() {
        return this.getJTable().getSelectedColumns();
    }

    protected void initTableViewPanel() {
        this.actionListeners = new EventListenerList();
        this.headerActionListeners = new ArrayList();
        this.getJTable().addMouseListener(this.tableMouseHandler);
        this.getJTable().getTableHeader().addMouseListener(this.tableHeaderMouseHandler);
        this.getJScrollPane().addMouseListener(this.scrollPaneMouseHandler);
        this.setTableExportWizard(new DefaultTableExportWizard());
        this.getJTable().setAutoCreateColumnsFromModel(false);
        this.getJScrollPane().setHorizontalScrollBarPolicy(30);
        this.getJScrollPane().setVerticalScrollBarPolicy(22);
        JButton cornerButton = new JButton();
        cornerButton.setMargin(new Insets(0, 0, 0, 0));
        cornerButton.setIcon(new ImageIcon(TableViewPanel.class.getResource("/com/spacekiller/util/table/icons/table_corner.gif")));
        cornerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableViewPanel.this.actionShowTableCornerPopupMenu();
            }
        });
        this.upperRightCornerButton = cornerButton;
        this.getJTable().setRowSelectionAllowed(true);
        this.getJTable().setAutoResizeMode(0);
        DragSource ds = new DragSource();
        ds.addDragSourceListener((DragSourceListener)this.dragSourceHandler);
        int actions = 0x40000003;
        DragGestureRecognizer dgr = ds.createDefaultDragGestureRecognizer(this.getJTable(), actions, this.dragGestureHandler);
        dgr.getComponent();
    }

    public void showTableExportWizard() {
        JTable table = this.getJTable();
        TableColumnModel columnModel = table.getColumnModel();
        int cols = columnModel.getColumnCount();
        DefaultTableCellFormatter defaultFormatter = new DefaultTableCellFormatter();
        TableCellFormatter[] cellFormatters = new TableCellFormatter[cols];
        for (int i = 0; i < cols; ++i) {
            cellFormatters[i] = defaultFormatter;
        }
        this.showTableExportWizard(cellFormatters);
    }

    public void showTableExportWizard(TableColumnProvider[] columnProviders) {
        JTable table = this.getJTable();
        TableModel model = table.getModel();
        int cols = columnProviders.length;
        TableCellFormatter[] cellFormatters = new TableCellFormatter[cols];
        for (int i = 0; i < cols; ++i) {
            TableCellFormatter cellFormatter = columnProviders[i].createCellFormatter(model);
            if (cellFormatter == null) {
                cellFormatter = new DefaultTableCellFormatter();
            }
            cellFormatters[i] = cellFormatter;
        }
        this.showTableExportWizard(cellFormatters);
    }

    public void showTableExportWizard(TableCellFormatter[] cellFormatters) {
        TableExportWizard wizard = this.getTableExportWizard();
        if (wizard == null) {
            return;
        }
        try {
            JTable table = this.getJTable();
            TableExport export = wizard.showTableExportDialog(table);
            if (export == null) {
                return;
            }
            TableExporter exporter = new TableExporter(export, table, cellFormatters);
            exporter.start();
            ExecutionManager em = Platform.getInstance().getExecutionManager();
            if (em != null) {
                em.addExecution((Execution)exporter);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
        this.getRuntimeContext().notifyError((Object)this, e);
    }

    protected RuntimeContext getRuntimeContext() {
        return Platform.getInstance().getRuntimeContext();
    }

    public TableCellRenderer getTableCellRenderer() {
        return this.tableCellRenderer;
    }

    public void setTableCellRenderer(TableCellRenderer tableCellRenderer) {
        this.tableCellRenderer = tableCellRenderer;
    }

    public JPopupMenu getTableCornerPopupMenu() {
        return this.tableCornerPopupMenu;
    }

    public void setTableCornerPopupMenu(JPopupMenu tableCornerPopupMenu) {
        this.tableCornerPopupMenu = tableCornerPopupMenu;
        if (tableCornerPopupMenu != null) {
            this.getJScrollPane().setCorner("UPPER_RIGHT_CORNER", this.upperRightCornerButton);
        } else {
            this.getJScrollPane().setCorner("UPPER_RIGHT_CORNER", null);
        }
    }

    protected void actionShowTableCornerPopupMenu() {
        JPopupMenu menu = this.getTableCornerPopupMenu();
        if (menu == null) {
            return;
        }
        Rectangle bounds = this.upperRightCornerButton.getBounds();
        Dimension menuSize = menu.getPreferredSize();
        menu.show(this, bounds.x - menuSize.width, bounds.y);
    }

    public void layoutResultToFitWindow() {
        this.getJTable().setAutoResizeMode(4);
    }

    public void layoutResultToFitColumns() {
        this.getJTable().setAutoResizeMode(0);
    }

    protected void adjustTableColumns(int firstRow, int lastRow) {
        TableModel tm = this.tableModel;
        if (tm == null) {
            return;
        }
        TableColumnModel cm = this.columnModel;
        if (cm == null) {
            return;
        }
        JTable table = this.jTable;
        int rowCount = tm.getRowCount();
        if (lastRow >= rowCount) {
            lastRow = rowCount - 1;
        }
        int colCount = cm.getColumnCount();
        for (int c = 0; c < colCount; ++c) {
            TableColumn tc = cm.getColumn(c);
            int mi = tc.getModelIndex();
            TableCellRenderer cr = tc.getCellRenderer();
            if (cr == null) continue;
            int width = 0;
            for (int i = firstRow; i <= lastRow; ++i) {
                Object v = tm.getValueAt(i, mi);
                Component comp = cr.getTableCellRendererComponent(table, v, false, false, i, mi);
                Dimension dim = comp.getPreferredSize();
                if (dim.width <= width) continue;
                width = dim.width;
            }
            if (tc.getPreferredWidth() >= width) continue;
            tc.setPreferredWidth(width);
        }
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public synchronized void setColumnModel(TableColumnModel columnModel) {
        this.columnModel = columnModel;
        this.getJTable().setColumnModel(columnModel);
    }

    protected void handleDoubleClick(MouseEvent ev) {
        Point p = ev.getPoint();
        int row = this.jTable.rowAtPoint(p);
        if (row < 0) {
            return;
        }
        ev.consume();
        this.fireActionEvent(new ActionEvent(this, 1001, "action"));
    }

    protected void fireActionEvent(ActionEvent ev) {
        Object[] list = this.actionListeners.getListenerList();
        for (int i = 1; i < list.length; i += 2) {
            ((ActionListener)list[i]).actionPerformed(ev);
        }
    }

    public void addActionListener(ActionListener l) {
        if (l != null) {
            this.actionListeners.add(ActionListener.class, l);
        }
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(ActionListener.class, l);
    }

    public TableCellRenderer getTableHeaderRenderer() {
        return this.tableHeaderRenderer;
    }

    public void setTableHeaderRenderer(TableCellRenderer tableHeaderRenderer) {
        this.tableHeaderRenderer = tableHeaderRenderer;
    }

    public ListSelectionModel getSelectionModel() {
        return this.jTable.getSelectionModel();
    }

    public void setSelectedRows(int[] rows) {
        this.setSelectedRows(rows, 0, rows.length);
    }

    public void setSelectedRows(int[] rows, int off, int len) {
        ListSelectionModel sel = this.getSelectionModel();
        if (sel == null) {
            return;
        }
        sel.clearSelection();
        int prevMin = -1;
        int prevMax = -1;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            int r = rows[i];
            if (r < 0) continue;
            if (prevMin < 0) {
                prevMin = r;
                prevMax = r;
                continue;
            }
            if (r == prevMax + 1) {
                prevMax = r;
                continue;
            }
            if (r == prevMin - 1) {
                prevMin = r;
                continue;
            }
            if (prevMin >= 0) {
                sel.addSelectionInterval(prevMin, prevMax);
            }
            prevMin = r;
            prevMax = r;
        }
        if (prevMin >= 0) {
            sel.addSelectionInterval(prevMin, prevMax);
        }
    }

    public boolean isAutoCreateColumnModel() {
        return this.autoCreateColumnModel;
    }

    public void setAutoCreateColumnModel(boolean autoCreateColumnModel) {
        this.autoCreateColumnModel = autoCreateColumnModel;
    }

    public void scrollRowToVisible(int rowIndex) {
        JTable table = this.getJTable();
        Rectangle rect = table.getCellRect(rowIndex, 0, false);
        if (rect != null) {
            table.scrollRectToVisible(rect);
        }
    }

    public JPopupMenu getTablePopupMenu() {
        return this.tablePopupMenu;
    }

    public void setTablePopupMenu(JPopupMenu tablePopupMenu) {
        this.tablePopupMenu = tablePopupMenu;
    }

    protected void actionShowTablePopupMenu() {
        JPopupMenu menu;
        int x = 0;
        int y = 0;
        int leadIndex = this.getJTable().getSelectionModel().getLeadSelectionIndex();
        if (leadIndex >= 0) {
            Rectangle rect;
            int selColumn = this.getJTable().getSelectedColumn();
            if (selColumn < 0) {
                selColumn = 0;
            }
            if ((rect = this.getJTable().getCellRect(leadIndex, selColumn, false)) != null) {
                x = rect.x;
                y = rect.y + rect.height;
            }
        }
        if ((menu = this.getTablePopupMenu()) == null) {
            return;
        }
        menu.show(this.getJTable(), x, y);
    }

    protected void actionShowTablePopupMenu(int x, int y) {
        JPopupMenu menu;
        int row = this.getJTable().rowAtPoint(new Point(x, y));
        if (row >= 0 && !this.getJTable().isRowSelected(row)) {
            ListSelectionModel selModel = this.getJTable().getSelectionModel();
            selModel.setSelectionInterval(row, row);
        }
        if ((menu = this.getTablePopupMenu()) == null) {
            return;
        }
        menu.show(this.getJTable(), x, y);
    }

    protected void actionShowTableHeaderPopupMenu(int x, int y) {
        JPopupMenu menu = this.getTableHeaderPopupMenu();
        if (menu == null) {
            return;
        }
        menu.show(this.getJTable().getTableHeader(), x, y);
    }

    protected void actionShowScrollPanePopupMenu(int x, int y) {
        ListSelectionModel selModel = this.getJTable().getSelectionModel();
        selModel.clearSelection();
        JPopupMenu menu = this.getTablePopupMenu();
        if (menu == null) {
            return;
        }
        menu.show(this.getJScrollPane(), x, y);
    }

    public boolean getShowHorizontalLines() {
        return this.getJTable().getShowHorizontalLines();
    }

    public void setShowHorizontalLines(boolean showHorizontalLines) {
        this.getJTable().setShowHorizontalLines(showHorizontalLines);
    }

    public boolean getShowVerticalLines() {
        return this.getJTable().getShowVerticalLines();
    }

    public void setShowVerticalLines(boolean showVerticalLines) {
        this.getJTable().setShowVerticalLines(showVerticalLines);
    }

    public JPopupMenu getTableHeaderPopupMenu() {
        return this.tableHeaderPopupMenu;
    }

    public void setTableHeaderPopupMenu(JPopupMenu tableHeaderPopupMenu) {
        this.tableHeaderPopupMenu = tableHeaderPopupMenu;
    }

    protected void handleHeaderClick(MouseEvent ev) {
        int viewColumnIndex = this.getJTable().columnAtPoint(ev.getPoint());
        if (viewColumnIndex < 0) {
            return;
        }
        TableColumnModel colModel = this.getJTable().getColumnModel();
        int num = colModel.getColumnCount();
        if (viewColumnIndex >= num) {
            return;
        }
        TableColumn column = colModel.getColumn(viewColumnIndex);
        if (column == null) {
            return;
        }
        this.fireHeaderActionEvent(new ActionEvent(column, 1001, "action"));
    }

    protected synchronized void fireHeaderActionEvent(ActionEvent ev) {
        int num = this.headerActionListeners.size();
        for (int i = 0; i < num; ++i) {
            ((ActionListener)this.headerActionListeners.get(i)).actionPerformed(ev);
        }
    }

    public synchronized void addHeaderActionListener(ActionListener l) {
        if (l != null) {
            this.headerActionListeners.add(l);
        }
    }

    public synchronized void removeHeaderActionListener(ActionListener l) {
        this.headerActionListeners.remove(l);
    }

    protected class ScrollPaneMouseHandler
    extends MouseAdapter {
        protected ScrollPaneMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (e.isPopupTrigger()) {
                TableViewPanel.this.actionShowScrollPanePopupMenu(e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (e.isPopupTrigger()) {
                TableViewPanel.this.actionShowScrollPanePopupMenu(e.getX(), e.getY());
            }
        }
    }

    protected class TableHeaderMouseHandler
    extends MouseAdapter {
        protected TableHeaderMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (e.isPopupTrigger()) {
                TableViewPanel.this.actionShowTableHeaderPopupMenu(e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (e.isPopupTrigger()) {
                TableViewPanel.this.actionShowTableHeaderPopupMenu(e.getX(), e.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            TableViewPanel.this.handleHeaderClick(e);
        }
    }

    protected class TableMouseHandler
    extends MouseAdapter {
        protected TableMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (e.isPopupTrigger()) {
                TableViewPanel.this.actionShowTablePopupMenu(e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (e.isPopupTrigger()) {
                TableViewPanel.this.actionShowTablePopupMenu(e.getX(), e.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            int clicks = e.getClickCount();
            if (clicks == 2) {
                TableViewPanel.this.handleDoubleClick(e);
            }
        }
    }

    protected class TableHandler
    implements TableModelListener {
        protected TableHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            switch (e.getType()) {
                case 0: 
                case 1: {
                    int fr = e.getFirstRow();
                    int lr = e.getLastRow();
                    if (fr >= 0 && lr >= fr) {
                        TableViewPanel.this.adjustTableColumns(fr, lr);
                    }
                    return;
                }
            }
        }
    }

    protected class TableExporter
    extends AbstractExecution {
        private TableExport export;
        private JTable table;
        private TableCellFormatter[] columns;

        public TableExporter(TableExport export, JTable table, TableCellFormatter[] columns) {
            this.export = export;
            this.table = table;
            this.columns = columns;
        }

        protected void execute() throws Exception {
            try {
                this.export.exportTable(this.table, this.columns);
                TableViewPanel.this.getRuntimeContext().notify((Object)this, (Object)"Export completed successfully");
            }
            catch (Throwable e) {
                this.handleException(e);
            }
        }

        public double getProgress() {
            return this.export.getProgress();
        }
    }

    protected class DragGestureHandler
    implements DragGestureListener {
        protected DragGestureHandler() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            ArrayList<Object> beans = new ArrayList<Object>();
            int[] rows = TableViewPanel.this.getJTable().getSelectedRows();
            int[] cols = TableViewPanel.this.getJTable().getSelectedColumns();
            TableModel model = TableViewPanel.this.getTableModel();
            if (model == null) {
                return;
            }
            int columns = model.getColumnCount();
            for (int i = 0; i < rows.length; ++i) {
                int row = rows[i];
                if (cols.length < 1) {
                    for (int c = 0; c < columns; ++c) {
                        Object obj = model.getValueAt(row, c);
                        beans.add(obj);
                    }
                    continue;
                }
                for (int k = 0; k < cols.length; ++k) {
                    int col = cols[k];
                    Object obj = model.getValueAt(row, col);
                    beans.add(obj);
                }
            }
            if (beans.isEmpty()) {
                return;
            }
            TableViewPanel.this.dragSourceHandler.setBeanDropSupport(TableViewPanel.this.getBeanDropSupport());
            TableViewPanel.this.dragSourceHandler.startDrag(dge, beans);
        }
    }
}

