/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.table.export;

import com.spacekiller.util.table.AbstractTableExport;
import com.spacekiller.util.table.TableCellFormatter;
import java.beans.PropertyChangeEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CsvTableExport
extends AbstractTableExport {
    private File targetFile;
    private boolean includeColumnNames;
    private String columnSeparator;
    private String rowSeparator;
    private volatile int rowIndex;
    private volatile int rowCount;

    public CsvTableExport() {
        this.initCsvResultTableExport();
    }

    public CsvTableExport(File targetFile) {
        this();
        this.setTargetFile(targetFile);
    }

    protected void initCsvResultTableExport() {
        this.includeColumnNames = true;
        this.columnSeparator = ",";
        this.rowSeparator = System.getProperty("line.separator");
        if (this.rowSeparator == null) {
            this.rowSeparator = "\n";
        }
    }

    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
        this.firePropertyChange(new PropertyChangeEvent(this, "columnSeparator", null, null));
    }

    public String getRowSeparator() {
        return this.rowSeparator;
    }

    public void setRowSeparator(String rowSeparator) {
        this.rowSeparator = rowSeparator;
        this.firePropertyChange(new PropertyChangeEvent(this, "rowSeparator", null, null));
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(File targetFile) {
        this.targetFile = targetFile;
        this.firePropertyChange(new PropertyChangeEvent(this, "targetFile", null, null));
    }

    public boolean isIncludeColumnNames() {
        return this.includeColumnNames;
    }

    public void setIncludeColumnNames(boolean includeColumnNames) {
        this.includeColumnNames = includeColumnNames;
        this.firePropertyChange(new PropertyChangeEvent(this, "includeColumnNames", null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportTable(JTable table, TableCellFormatter[] columns) throws Exception {
        if (table == null) {
            throw new Exception("Table not specified.");
        }
        File file = this.getTargetFile();
        if (file == null) {
            throw new Exception("Target file not specified.");
        }
        FileWriter writer = new FileWriter(file);
        try {
            BufferedWriter bw = new BufferedWriter(writer);
            try {
                this.exportTable(table, columns, bw);
            }
            finally {
                bw.close();
            }
        }
        finally {
            writer.close();
        }
    }

    protected void exportTable(JTable table, TableCellFormatter[] columns, BufferedWriter writer) throws Exception {
        String s;
        TableModel model = table.getModel();
        int rows = model.getRowCount();
        int cols = columns.length;
        this.rowIndex = 0;
        this.rowCount = rows;
        if (this.includeColumnNames) {
            TableColumnModel columnModel = table.getColumnModel();
            int max = columnModel.getColumnCount();
            for (int c = 0; c < cols; ++c) {
                Object headerValue;
                TableColumn column;
                if (c > 0) {
                    writer.write(this.columnSeparator);
                }
                s = null;
                if (c < max && (column = columnModel.getColumn(c)) != null && (headerValue = column.getHeaderValue()) != null) {
                    s = headerValue.toString();
                }
                if (s == null) {
                    s = "#" + c;
                }
                writer.write(s);
            }
            writer.write(this.rowSeparator);
        }
        for (int r = 0; r < rows; ++r) {
            this.rowIndex = r;
            for (int c = 0; c < cols; ++c) {
                if (c > 0) {
                    writer.write(this.columnSeparator);
                }
                if ((s = columns[c].getValueAsString(table, r, c)) == null) continue;
                writer.write(s);
            }
            writer.write(this.rowSeparator);
        }
        this.rowIndex = rows;
    }

    @Override
    public double getProgress() {
        int indx = this.rowIndex;
        int rows = this.rowCount;
        if (indx >= rows) {
            return 1.0;
        }
        if (rows > 0) {
            return (double)indx / (double)rows;
        }
        return 0.0;
    }
}

