/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.table.export;

import com.spacekiller.util.swing.FileField;
import com.spacekiller.util.table.export.CsvTableExport;
import com.spacekiller.util.table.export.SeparatorField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Customizer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class CsvTableExportCustomizer
extends JPanel
implements Customizer {
    private static final long serialVersionUID = -8776591252734098464L;
    private CsvTableExport export;
    private boolean refreshing = false;
    private JLabel jLabel2 = null;
    private FileField fileField = null;
    private JPanel jPanelOptions2 = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JCheckBox jCheckBoxColumnNames = null;
    private JPanel jPanelOptions = null;
    private SeparatorField separatorFieldColumn = null;
    private SeparatorField separatorFieldRow = null;

    public CsvTableExportCustomizer() {
        this.initialize();
        this.initCsvTableExportCustomizer();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints3.anchor = 11;
        gridBagConstraints3.gridy = 2;
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 1;
        gridBagConstraints12.weightx = 1.0;
        gridBagConstraints12.fill = 2;
        gridBagConstraints12.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints12.gridy = 0;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints11.anchor = 17;
        gridBagConstraints11.gridy = 0;
        this.jLabel2 = new JLabel();
        this.jLabel2.setText("Target file:");
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/table/icons/filetarget16.gif")));
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(381, 184));
        this.add((Component)this.jLabel2, gridBagConstraints11);
        this.add((Component)this.getFileField(), gridBagConstraints12);
        this.add((Component)this.getJPanelOptions(), gridBagConstraints3);
    }

    @Override
    public void setObject(Object bean) {
        this.setExport((CsvTableExport)bean);
    }

    public CsvTableExport getExport() {
        return this.export;
    }

    public void setExport(CsvTableExport export) {
        this.export = export;
        this.refresh();
    }

    private FileField getFileField() {
        if (this.fileField == null) {
            this.fileField = new FileField();
            this.fileField.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CsvTableExportCustomizer.this.apply();
                }
            });
        }
        return this.fileField;
    }

    private JPanel getJPanelOptions2() {
        if (this.jPanelOptions2 == null) {
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.fill = 2;
            gridBagConstraints15.gridy = 1;
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints15.gridx = 1;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.fill = 2;
            gridBagConstraints14.gridy = 0;
            gridBagConstraints14.weightx = 1.0;
            gridBagConstraints14.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints14.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridy = 1;
            this.jLabel1 = new JLabel();
            this.jLabel1.setFont(new Font("Dialog", 0, 12));
            this.jLabel1.setText("Row separator:");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setFont(new Font("Dialog", 0, 12));
            this.jLabel.setText("Column separator:");
            this.jPanelOptions2 = new JPanel();
            this.jPanelOptions2.setLayout(new GridBagLayout());
            this.jPanelOptions2.add((Component)this.jLabel, gridBagConstraints);
            this.jPanelOptions2.add((Component)this.jLabel1, gridBagConstraints1);
            this.jPanelOptions2.add((Component)this.getJCheckBoxColumnNames(), gridBagConstraints2);
            this.jPanelOptions2.add((Component)this.getSeparatorFieldColumn(), gridBagConstraints14);
            this.jPanelOptions2.add((Component)this.getSeparatorFieldRow(), gridBagConstraints15);
        }
        return this.jPanelOptions2;
    }

    private JCheckBox getJCheckBoxColumnNames() {
        if (this.jCheckBoxColumnNames == null) {
            this.jCheckBoxColumnNames = new JCheckBox();
            this.jCheckBoxColumnNames.setFont(new Font("Dialog", 0, 12));
            this.jCheckBoxColumnNames.setText("include column names");
            this.jCheckBoxColumnNames.setToolTipText("include column names in the first row ?");
            this.jCheckBoxColumnNames.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CsvTableExportCustomizer.this.apply();
                }
            });
        }
        return this.jCheckBoxColumnNames;
    }

    private JPanel getJPanelOptions() {
        if (this.jPanelOptions == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 0.0;
            gridBagConstraints4.insets = new Insets(4, 4, 4, 4);
            this.jPanelOptions = new JPanel();
            this.jPanelOptions.setLayout(new GridBagLayout());
            this.jPanelOptions.add((Component)this.getJPanelOptions2(), gridBagConstraints4);
        }
        return this.jPanelOptions;
    }

    protected void initCsvTableExportCustomizer() {
        EtchedBorder border = new EtchedBorder(0);
        TitledBorder titledBorder = new TitledBorder(border, "Options");
        this.getJPanelOptions().setBorder(titledBorder);
        this.separatorFieldColumn.removeAllItems();
        this.separatorFieldColumn.addItem(",");
        this.separatorFieldColumn.addItem(":");
        this.separatorFieldColumn.addItem(";");
        this.separatorFieldColumn.addItem("\\t");
        this.separatorFieldRow.removeAllItems();
        this.separatorFieldRow.addItem("\\n");
        this.separatorFieldRow.addItem("\\r\\n");
    }

    private SeparatorField getSeparatorFieldColumn() {
        if (this.separatorFieldColumn == null) {
            this.separatorFieldColumn = new SeparatorField();
            this.separatorFieldColumn.setToolTipText("Column separator character(s)");
            this.separatorFieldColumn.setEditable(true);
            this.separatorFieldColumn.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CsvTableExportCustomizer.this.apply();
                }
            });
        }
        return this.separatorFieldColumn;
    }

    private SeparatorField getSeparatorFieldRow() {
        if (this.separatorFieldRow == null) {
            this.separatorFieldRow = new SeparatorField();
            this.separatorFieldRow.setToolTipText("Row separator character(s)");
            this.separatorFieldRow.setEditable(true);
            this.separatorFieldRow.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CsvTableExportCustomizer.this.apply();
                }
            });
        }
        return this.separatorFieldRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refresh() {
        try {
            this.refreshing = true;
            if (this.export != null) {
                this.getFileField().setFile(this.export.getTargetFile());
                this.getSeparatorFieldColumn().setSeparator(this.export.getColumnSeparator());
                this.getSeparatorFieldRow().setSeparator(this.export.getRowSeparator());
                this.getJCheckBoxColumnNames().setSelected(this.export.isIncludeColumnNames());
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void apply() {
        if (this.refreshing) {
            return;
        }
        if (this.export == null) {
            return;
        }
        this.export.setTargetFile(this.getFileField().getFile());
        this.export.setColumnSeparator(this.getSeparatorFieldColumn().getSeparator());
        this.export.setRowSeparator(this.getSeparatorFieldRow().getSeparator());
        this.export.setIncludeColumnNames(this.getJCheckBoxColumnNames().isSelected());
    }
}

