/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.table.sort;

import com.spacekiller.util.table.DefaultRowComparator;
import com.spacekiller.util.table.RowComparator;
import com.spacekiller.util.table.sort.ColumnTableSortRule;
import com.spacekiller.util.table.sort.TableSortRule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.TableModel;

public class TableSortModel
implements TableSortRule {
    private List rules = new ArrayList();

    public int getTableSortRuleCount() {
        return this.rules.size();
    }

    public TableSortRule getTableSortRuleAt(int i) {
        return (TableSortRule)this.rules.get(i);
    }

    @Override
    public synchronized RowComparator createRowComparator(TableModel model) throws Exception {
        if (this.rules.isEmpty()) {
            return null;
        }
        ArrayList<RowComparator> comps = new ArrayList<RowComparator>();
        for (TableSortRule rule : this.rules) {
            RowComparator comp = rule.createRowComparator(model);
            if (comp == null) continue;
            comps.add(comp);
        }
        if (comps.isEmpty()) {
            return null;
        }
        RowComparator[] compArr = comps.toArray(new RowComparator[comps.size()]);
        DefaultRowComparator def = new DefaultRowComparator(compArr);
        def.setTableSortModel(this);
        return def;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    public void prependTableSortRule(TableSortRule rule) {
        this.addTableSortRule(0, rule);
    }

    public synchronized void addTableSortRule(TableSortRule rule) {
        this.addTableSortRule(this.rules.size(), rule);
    }

    public synchronized void addTableSortRule(int index, TableSortRule rule) {
        if (rule == null) {
            return;
        }
        if (index < 0 || index > this.rules.size()) {
            throw new ArrayIndexOutOfBoundsException("Invalid index: " + index);
        }
        if (rule instanceof ColumnTableSortRule) {
            ColumnTableSortRule colRule = (ColumnTableSortRule)rule;
            String colName = colRule.getColumnName();
            Iterator i = this.rules.iterator();
            while (i.hasNext()) {
                ColumnTableSortRule cr;
                TableSortRule r = (TableSortRule)i.next();
                if (!(r instanceof ColumnTableSortRule) || !colName.equals((cr = (ColumnTableSortRule)r).getColumnName())) continue;
                i.remove();
            }
        }
        this.rules.add(index, rule);
    }

    public synchronized void removeTableSortRule(TableSortRule rule) {
        this.rules.remove(rule);
    }

    public synchronized void removeAllTableSortRules() {
        this.rules.clear();
    }
}

