/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.view;

import com.waxmonster.model.ChunkConsumer;
import com.waxmonster.model.ChunkInterval;
import com.waxmonster.model.ChunkModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineModel;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.view.AbstractLineView;
import com.waxmonster.model.view.ChunkRenderer;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class ChunkModelLineView
extends AbstractLineView {
    protected ChunkModel chunkModel;
    protected ChunkRenderer chunkRenderer;
    protected Graphics2D gr;
    protected Rectangle cr;
    protected int orient;
    protected boolean horiz;
    protected int fpx;
    protected int npx;
    protected double pps;
    protected double upp;
    protected long ofs;
    protected long end;
    protected LineChunk prevChunk;
    protected long prevOfs;
    protected long prevEnd;
    protected Rectangle clip;
    protected final ChunkPainter chunkPainter = new ChunkPainter();

    public ChunkModelLineView() {
        this.cr = new Rectangle();
        this.clip = new Rectangle();
    }

    public ChunkModel getChunkModel() {
        return this.chunkModel;
    }

    public void setChunkModel(ChunkModel chunkModel) {
        this.chunkModel = chunkModel;
    }

    public ChunkRenderer getChunkRenderer() {
        return this.chunkRenderer;
    }

    public void setChunkRenderer(ChunkRenderer chunkRenderer) {
        this.chunkRenderer = chunkRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g) {
        ChunkModel chunkModel = this.chunkModel;
        if (chunkModel == null) {
            return;
        }
        this.cr = g.getClipBounds(this.cr);
        this.orient = this.orientation;
        switch (this.orient) {
            case 0: {
                this.horiz = true;
                this.fpx = this.cr.x;
                this.npx = this.cr.width;
                break;
            }
            case 2: {
                this.horiz = false;
                this.fpx = this.cr.y;
                this.npx = this.cr.height;
                break;
            }
            default: {
                return;
            }
        }
        this.pps = this.zoomRate;
        this.ofs = LineUtil.getNanoOfs((long)this.fpx, (double)this.pps);
        this.end = LineUtil.getNanoOfs((long)(this.fpx + this.npx), (double)this.pps);
        try {
            this.gr = g;
            this.prevChunk = null;
            chunkModel.getIntervals(this.ofs, this.end, (ChunkConsumer)this.chunkPainter);
            if (this.prevChunk != null) {
                this.paintChunk(this.prevChunk, this.prevOfs, this.prevEnd);
            }
        }
        finally {
            this.prevChunk = null;
            this.gr = null;
        }
    }

    protected void paintChunk(LineChunk chunk, long interOfs, long interEnd) {
        int num;
        long fpx;
        LineModel model = chunk.getLineModel();
        if (model == null) {
            return;
        }
        int x = this.cr.x;
        int y = this.cr.y;
        int w = this.cr.width;
        int h = this.cr.height;
        if (this.horiz) {
            fpx = x;
            num = w;
        } else {
            fpx = y;
            num = h;
        }
        long chunkOfs = chunk.getChunkOfs();
        long chunkLen = chunk.getChunkEnd() - chunkOfs;
        if (chunkLen < 1L) {
            return;
        }
        long fpo = LineUtil.getUnitOfs((long)chunkOfs, (double)this.pps) - fpx;
        if (fpo >= (long)num) {
            return;
        }
        long modelOfs = chunk.getModelOfs();
        long modelEnd = modelOfs + chunkLen;
        if (modelEnd < modelOfs) {
            modelEnd = Long.MAX_VALUE;
        }
        if ((modelEnd = Math.min(modelEnd, chunk.getModelEnd())) <= modelOfs) {
            return;
        }
        double unitRate = model.getUnitRate();
        this.upp = unitRate / this.pps;
        long unitOfs = (long)Math.ceil(LineUtil.getUnitPos((long)modelOfs, (double)unitRate));
        long unitEnd = (long)Math.floor(LineUtil.getUnitPos((long)modelEnd, (double)unitRate));
        long unitLen = Math.min(unitEnd, this.getUnitLength(chunk, model)) - unitOfs;
        if (unitLen < 1L) {
            return;
        }
        long tpo = Math.min((long)num, fpo + LineUtil.longDivide((long)unitLen, (double)this.upp));
        if (tpo < 1L) {
            return;
        }
        unitEnd = unitOfs + unitLen;
        if (fpo >= 0L) {
            if (tpo < (long)num) {
                num = (int)tpo;
            }
            fpx += fpo;
            num -= (int)fpo;
            if (this.horiz) {
                x = (int)fpx;
                w = num;
            } else {
                y = (int)fpx;
                h = num;
            }
        } else {
            unitOfs += LineUtil.longMultiply((long)(-fpo), (double)this.upp);
            if (tpo < (long)num) {
                num = (int)tpo;
                if (this.horiz) {
                    w = num;
                } else {
                    h = num;
                }
            }
        }
        this.clip.x = x;
        this.clip.y = y;
        this.clip.width = w;
        this.clip.height = h;
        this.chunkRenderer.paint(this.gr, this.clip, this.bounds, this.orient, chunk, model, unitOfs, unitEnd, num, this.pps, this.upp);
    }

    protected long getUnitLength(LineChunk chunk, LineModel model) {
        return model.getUnitLength();
    }

    protected class ChunkPainter
    implements ChunkConsumer {
        protected ChunkPainter() {
        }

        public boolean consume(ChunkInterval interval) {
            int count = interval.getChunkCount();
            if (count < 1) {
                return true;
            }
            LineChunk chunk = interval.getChunkAt(count - 1);
            if (chunk == ChunkModelLineView.this.prevChunk && interval.getOfs() == ChunkModelLineView.this.prevEnd) {
                ChunkModelLineView.this.prevEnd = interval.getEnd();
            } else {
                if (ChunkModelLineView.this.prevChunk != null) {
                    ChunkModelLineView.this.paintChunk(ChunkModelLineView.this.prevChunk, ChunkModelLineView.this.prevOfs, ChunkModelLineView.this.prevEnd);
                }
                ChunkModelLineView.this.prevChunk = chunk;
                ChunkModelLineView.this.prevOfs = interval.getOfs();
                ChunkModelLineView.this.prevEnd = interval.getEnd();
            }
            return true;
        }
    }
}

