/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.view;

import com.waxmonster.model.view.Col;
import java.awt.Color;

public class ColUtil {
    private static ColUtil instance;
    protected static final float FREQ_RED = 125.0f;
    protected static final float FREQ_YELLOW = 250.0f;
    protected static final float FREQ_GREEN = 500.0f;
    protected static final float FREQ_CYAN = 1000.0f;
    protected static final float FREQ_BLUE = 2000.0f;
    protected static final float FREQ_ULTRA = 5000.0f;

    protected ColUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ColUtil getInstance() {
        if (instance != null) return instance;
        Class<ColUtil> clazz = ColUtil.class;
        synchronized (ColUtil.class) {
            if (instance != null) return instance;
            instance = new ColUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void getFreqSpectrum(Col[] dst, int num, float rate) {
        for (int i = 0; i < num; ++i) {
            float freq = rate / (float)(num - i);
            this.getFreqColorOLD1(freq, dst[i]);
        }
    }

    public void getFreqColor(float freq, Col dst) {
        float hue = freq;
        float saturation = 1.0f;
        float brightness = 1.0f;
        int rgb = Color.HSBtoRGB(hue, saturation, brightness);
        dst.r = rgb >> 16 & 0xFF;
        dst.g = rgb >> 8 & 0xFF;
        dst.b = rgb & 0xFF;
    }

    private void getFreqColorOLD1(float freq, Col dst) {
        if (freq > 2000.0f) {
            dst.r = 1.0f - (freq - 2000.0f) / 3000.0f;
            dst.g = 0.0f;
            dst.b = 1.0f;
            return;
        }
        if (freq > 1000.0f) {
            dst.r = 0.0f;
            dst.g = 1.0f - (freq - 1000.0f) / 1000.0f;
            dst.b = 1.0f;
            return;
        }
        if (freq > 500.0f) {
            dst.r = 0.0f;
            dst.g = 1.0f;
            dst.b = 1.0f - (freq - 500.0f) / 500.0f;
            return;
        }
        if (freq > 250.0f) {
            dst.r = 1.0f - (freq - 250.0f) / 250.0f;
            dst.g = 1.0f;
            dst.b = 0.0f;
            return;
        }
        if (freq > 125.0f) {
            dst.r = 1.0f;
            dst.g = (freq - 125.0f) / 125.0f;
            dst.b = 0.0f;
            return;
        }
        dst.r = freq / 125.0f;
        dst.g = 0.0f;
        dst.b = 0.0f;
    }
}

