/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.view;

import java.awt.Color;

public class MidiColorPalette {
    public static int CONTROL_COUNT = 128;
    public Color[] channelColors;
    public Color[][] controlColors;
    public Color[] noteColors;
    public Color noteOnColor;
    public Color noteOffColor;
    public Color polyPressureColor;
    public Color pitchBendColor;
    public Color channelPressureColor;
    public Color programChangeColor;
    public Color systemExclusiveColor;
    public Color songPositionPointerColor;
    public Color songSelectColor;
    public Color tuneRequestColor;
    public Color startColor;
    public Color continueColor;
    public Color stopColor;

    public static MidiColorPalette createDefaultColorPalette() {
        MidiColorPalette p = new MidiColorPalette();
        p.setDefaults();
        return p;
    }

    public Color getChannelColor(int channel) {
        Color[] arr = this.channelColors;
        if (arr == null || channel >= arr.length || channel < 0) {
            return null;
        }
        return arr[channel];
    }

    public Color getNoteColor(int channel) {
        Color[] arr = this.noteColors;
        if (arr == null || channel >= arr.length || channel < 0) {
            return null;
        }
        return arr[channel];
    }

    public Color getControlColor(int channel, int control) {
        Color[][] arrs = this.controlColors;
        if (arrs == null || channel >= arrs.length || channel < 0) {
            return null;
        }
        Color[] arr = arrs[channel];
        if (arr == null || control >= arr.length || control < 0) {
            return null;
        }
        return arr[control];
    }

    public void setDefaults() {
        this.channelColors = this.createDefaultChannelColors();
        this.controlColors = this.createDefaultChannelControlColors();
        this.noteColors = this.createDefaultNoteOnColors();
        this.noteOnColor = Color.DARK_GRAY;
        this.noteOffColor = Color.DARK_GRAY;
        this.polyPressureColor = Color.CYAN;
        this.pitchBendColor = Color.PINK;
        this.channelPressureColor = Color.ORANGE;
        this.programChangeColor = Color.GREEN;
        this.systemExclusiveColor = Color.DARK_GRAY;
        this.songPositionPointerColor = Color.YELLOW;
        this.songSelectColor = Color.MAGENTA;
        this.tuneRequestColor = Color.LIGHT_GRAY;
        this.startColor = Color.GREEN;
        this.continueColor = Color.GREEN;
        this.stopColor = Color.RED;
    }

    public Color[][] createDefaultChannelControlColors() {
        Color[] def = this.createDefaultControlColors();
        int num = 16;
        Color[][] arr = new Color[num][];
        for (int i = 0; i < num; ++i) {
            arr[i] = this.createDefaultChannelControlColors(i, def);
        }
        return arr;
    }

    public Color[] createDefaultChannelControlColors(int channel, Color[] def) {
        int num = def.length;
        Color[] cols = new Color[num];
        int ofs = channel * 31;
        for (int i = 0; i < num; ++i) {
            cols[i] = def[(ofs + i) % num];
        }
        return cols;
    }

    public Color[] createDefaultControlColors() {
        int num = CONTROL_COUNT;
        Color[] cols = new Color[num];
        for (int i = 0; i < num; ++i) {
            int row = i / 16;
            int column = i % 16;
            float hue = (float)(column % 16) / 16.0f;
            float saturation = 0.4f + (float)(row % 8) / 12.0f;
            float brightness = 1.0f - (float)(row % 8) / 10.0f;
            int rgb = Color.HSBtoRGB(hue, saturation, brightness);
            cols[i] = new Color(rgb);
        }
        return cols;
    }

    public Color[] createDefaultNoteOnColors() {
        return this.createDefaultChannelColors();
    }

    public Color[] createDefaultChannelColors() {
        int num = 16;
        Color[] cols = new Color[num];
        for (int i = 0; i < num; ++i) {
            float hue = (float)(i % num) / (float)num;
            float saturation = 0.8f;
            float brightness = 0.8f;
            int rgb = Color.HSBtoRGB(hue, saturation, brightness);
            cols[i] = new Color(rgb);
        }
        return cols;
    }
}

