/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.view;

import com.waxmonster.model.AudioModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineModel;
import com.waxmonster.model.view.ChunkRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PeakAudioChunkRenderer
implements ChunkRenderer {
    private static final Logger logger = Logger.getLogger(PeakAudioChunkRenderer.class.getName());
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    protected AudioModel audioModel;
    protected int chs;
    protected int fpp;
    protected int spp;
    protected double[] buf;
    protected double min;
    protected double max;
    protected Color color = Color.BLACK;

    public PeakAudioChunkRenderer() {
        this.buf = EMPTY_DOUBLE_ARRAY;
    }

    @Override
    public void paint(Graphics2D g, Rectangle clip, Rectangle bounds, int orient, LineChunk chunk, LineModel model, long unitOfs, long unitEnd, int numPix, double pps, double upp) {
        if (!(model instanceof AudioModel)) {
            return;
        }
        this.audioModel = (AudioModel)model;
        this.chs = this.audioModel.getChannels();
        if (this.chs < 1) {
            return;
        }
        this.fpp = (int)Math.ceil(upp);
        if (this.fpp < 1) {
            this.fpp = 1;
        }
        this.spp = this.fpp * this.chs;
        if (this.buf.length < this.spp) {
            this.buf = new double[this.spp];
        }
        double framePos = unitOfs;
        long frameEnd = this.audioModel.getFrameLength();
        g.setColor(this.color);
        try {
            switch (orient) {
                case 0: {
                    double full = bounds.height;
                    double half = full / 2.0;
                    double mid = (double)bounds.y + half;
                    int x = clip.x;
                    for (int i = 0; i < numPix; ++i) {
                        if (this.process(framePos, frameEnd)) {
                            double val = -this.min > this.max ? -this.min : this.max;
                            int pix = Math.max(1, (int)(val * full));
                            g.fillRect(x, (int)(mid - val * half), 1, pix);
                        }
                        framePos += upp;
                        ++x;
                    }
                    break;
                }
                case 2: {
                    int num = clip.height;
                    double full = bounds.width;
                    double half = full / 2.0;
                    double mid = (double)bounds.x + half;
                    int y = clip.y;
                    for (int i = 0; i < num; ++i) {
                        if (this.process(framePos, frameEnd)) {
                            double val = -this.min > this.max ? -this.min : this.max;
                            int pix = Math.max(1, (int)(val * full));
                            g.fillRect((int)(mid - val * half), y, pix, 1);
                        }
                        framePos += upp;
                        ++y;
                    }
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected boolean process(double framePos, long frameEnd) throws Exception {
        if (framePos < 0.0) {
            return false;
        }
        if (framePos + (double)this.fpp >= (double)frameEnd) {
            return false;
        }
        int len = this.spp;
        this.audioModel.get((long)this.chs * (long)framePos, this.buf, 0, len);
        double min = 0.0;
        double max = 0.0;
        for (int i = 0; i < len; ++i) {
            double val = this.buf[i];
            if (val > max) {
                max = val;
                continue;
            }
            if (!(val < min)) continue;
            min = val;
        }
        this.min = min;
        this.max = max;
        return true;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

