/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.view;

import com.waxmonster.model.AudioModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineModel;
import com.waxmonster.model.view.ChunkRenderer;
import com.waxmonster.model.view.StrokeUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PolyAudioChunkRenderer
implements ChunkRenderer {
    private static final Logger logger = Logger.getLogger(PolyAudioChunkRenderer.class.getName());
    private double[] darr;
    private int[] iarr;
    private int[] sarr;
    private Color color = Color.BLUE;
    private Color[] colors = new Color[]{Color.GREEN, Color.RED};
    private boolean mono;
    private Stroke stroke = StrokeUtil.getInstance().getDefaultStroke();

    public PolyAudioChunkRenderer(int initCapacity) {
        this.darr = new double[initCapacity];
        this.iarr = new int[initCapacity];
        this.sarr = new int[initCapacity];
        this.updateSequenceArray(this.sarr.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g, Rectangle clip, Rectangle bounds, int orient, LineChunk chunk, LineModel model, long unitOfs, long unitEnd, int numPix, double pps, double upp) {
        int[] seq;
        double frameEnd;
        double factor;
        int ty;
        int tx;
        int len;
        boolean horiz;
        if (!(model instanceof AudioModel)) {
            return;
        }
        AudioModel audioModel = (AudioModel)model;
        double framePos = unitOfs;
        long frameLen = audioModel.getFrameLength();
        if (framePos > (double)(frameLen - 1L)) {
            return;
        }
        int x = clip.x;
        int y = clip.y;
        int w = clip.width;
        int h = clip.height;
        switch (orient) {
            case 0: {
                horiz = true;
                len = w + 2;
                tx = x - 1;
                ty = bounds.y;
                break;
            }
            case 2: {
                horiz = false;
                len = h + 2;
                tx = bounds.x;
                ty = y - 1;
                break;
            }
            default: {
                return;
            }
        }
        if (horiz) {
            ty += bounds.height / 2;
            factor = (double)bounds.height / 2.0;
        } else {
            tx += bounds.width / 2;
            factor = (double)bounds.width / 2.0;
        }
        if (framePos < 0.0) {
            int z = (int)(-framePos / upp);
            switch (orient) {
                case 0: {
                    tx += z;
                    break;
                }
                case 1: {
                    tx -= z;
                    break;
                }
                case 2: {
                    ty += z;
                    break;
                }
                case 3: {
                    ty -= z;
                }
            }
            framePos = 0.0;
        }
        if ((frameEnd = framePos + (double)len * upp) > (double)frameLen) {
            len = (int)(((double)frameLen - framePos) / upp);
        }
        if (len < 1) {
            return;
        }
        int channels = audioModel.getChannels();
        if (channels < 1) {
            return;
        }
        double[] v = this.darr;
        int sLen = len * channels;
        if (v.length < sLen) {
            this.darr = v = new double[sLen];
        }
        try {
            audioModel.getValues(framePos, upp, v, 0, sLen);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
            return;
        }
        int[] val = this.iarr;
        if (val.length < len) {
            this.iarr = val = new int[len];
        }
        if ((seq = this.sarr).length < len) {
            this.updateSequenceArray(len);
            seq = this.sarr;
        }
        int loops = this.mono ? 1 : channels;
        Stroke os = g.getStroke();
        g.setStroke(this.stroke);
        g.translate(tx, ty);
        try {
            for (int c = 0; c < loops; ++c) {
                int o;
                if (this.mono && channels > 1) {
                    o = 0;
                    for (int i = 0; i < len; ++i) {
                        double m = v[o++];
                        for (int k = 1; k < channels; ++k) {
                            m += v[o++];
                        }
                        val[i] = (int)Math.round(m * factor);
                    }
                    g.setColor(this.color);
                } else {
                    o = c;
                    for (int i = 0; i < len; ++i) {
                        val[i] = (int)Math.round(v[o] * factor);
                        o += channels;
                    }
                    g.setColor(c < this.colors.length ? this.colors[c] : this.color);
                }
                if (horiz) {
                    g.drawPolyline(seq, val, len);
                    continue;
                }
                g.drawPolyline(val, seq, len);
            }
        }
        finally {
            g.setStroke(os);
            g.translate(-tx, -ty);
        }
    }

    protected void updateSequenceArray(int len) {
        if (len > this.sarr.length) {
            this.sarr = new int[len];
        } else {
            len = this.sarr.length;
        }
        for (int i = 0; i < len; ++i) {
            this.sarr[i] = i;
        }
    }

    public boolean isMono() {
        return this.mono;
    }

    public void setMono(boolean mono) {
        this.mono = mono;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color[] getColors() {
        return this.colors;
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }
}

