/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.view;

import com.waxmonster.model.FaderModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineModel;
import com.waxmonster.model.view.ChunkRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PolyFaderChunkRenderer
implements ChunkRenderer {
    private static final Logger logger = Logger.getLogger(PolyFaderChunkRenderer.class.getName());
    private float[] farr;
    private int[] iarr;
    private int[] sarr;
    private Color color = Color.BLACK;
    private boolean inverted = false;

    public PolyFaderChunkRenderer(int initCapacity) {
        this.farr = new float[initCapacity];
        this.iarr = new int[initCapacity];
        this.sarr = new int[initCapacity];
        this.updateSequenceArray(this.sarr.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g, Rectangle clip, Rectangle bounds, int orient, LineChunk chunk, LineModel model, long unitOfs, long unitEnd, int numPix, double pps, double upp) {
        double frameEnd;
        double factor;
        int ty;
        int tx;
        int len;
        boolean horiz;
        if (!(model instanceof FaderModel)) {
            return;
        }
        FaderModel faderModel = (FaderModel)model;
        double framePos = unitOfs;
        long frameLen = faderModel.getFrameLength();
        if (framePos > (double)(frameLen - 1L)) {
            return;
        }
        int x = clip.x;
        int y = clip.y;
        int w = clip.width;
        int h = clip.height;
        switch (orient) {
            case 0: {
                horiz = true;
                len = w + 2;
                tx = x - 1;
                ty = bounds.y;
                break;
            }
            case 2: {
                horiz = false;
                len = h + 2;
                tx = bounds.x;
                ty = y - 1;
                break;
            }
            default: {
                return;
            }
        }
        if (horiz) {
            factor = bounds.height - 1;
            if (this.inverted) {
                factor = -factor;
                ty += bounds.height - 1;
            }
        } else {
            factor = bounds.width - 1;
            if (this.inverted) {
                factor = -factor;
                tx += bounds.width - 1;
            }
        }
        if (framePos < 0.0) {
            int z = (int)(-framePos / upp);
            switch (orient) {
                case 0: {
                    tx += z;
                    break;
                }
                case 1: {
                    tx -= z;
                    break;
                }
                case 2: {
                    ty += z;
                    break;
                }
                case 3: {
                    ty -= z;
                }
            }
            framePos = 0.0;
        }
        if ((frameEnd = framePos + (double)len * upp) > (double)frameLen) {
            len = (int)(((double)frameLen - framePos) / upp);
        }
        if (len < 1) {
            return;
        }
        float[] v = this.farr;
        if (this.farr.length < len) {
            this.farr = v = new float[len];
        }
        try {
            faderModel.getValues(framePos, upp, v, 0, len);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
            return;
        }
        int[] val = this.iarr;
        if (val.length < len) {
            this.iarr = val = new int[len];
        }
        for (int i = 0; i < len; ++i) {
            val[i] = (int)Math.round((double)v[i] * factor);
        }
        int[] seq = this.sarr;
        if (seq.length < len) {
            this.updateSequenceArray(len);
            seq = this.sarr;
        }
        g.translate(tx, ty);
        try {
            g.setColor(this.color);
            if (horiz) {
                g.drawPolyline(seq, val, len);
            } else {
                g.drawPolyline(val, seq, len);
            }
        }
        finally {
            g.translate(-tx, -ty);
        }
    }

    protected void updateSequenceArray(int len) {
        if (len > this.sarr.length) {
            this.sarr = new int[len];
        } else {
            len = this.sarr.length;
        }
        for (int i = 0; i < len; ++i) {
            this.sarr[i] = i;
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }
}

