/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.view;

import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineModel;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.model.view.ChunkRenderer;
import com.waxmonster.model.view.StrokeUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PolyTimecodeChunkRenderer
implements ChunkRenderer {
    private static final Logger logger = Logger.getLogger(PolyTimecodeChunkRenderer.class.getName());
    public static final int ZERO_BASE = 0xA00000;
    private double[] darr;
    private int[] iarr;
    private int[] sarr;
    private Color color = Color.BLUE;
    private Stroke stroke = StrokeUtil.getInstance().getDefaultStroke();
    private boolean inverted = false;

    public PolyTimecodeChunkRenderer(int initCapacity) {
        this.darr = new double[initCapacity];
        this.iarr = new int[initCapacity];
        this.sarr = new int[initCapacity];
        this.updateSequenceArray(this.sarr.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g, Rectangle clip, Rectangle bounds, int orient, LineChunk chunk, LineModel model, long unitOfs, long unitEnd, int numPix, double pps, double upp) {
        int[] seq;
        int i;
        double q;
        int ty;
        int tx;
        int len;
        boolean horiz;
        if (!(model instanceof TimecodeModel)) {
            return;
        }
        TimecodeModel tcModel = (TimecodeModel)model;
        double framePos = unitOfs;
        long frameLen = tcModel.getFrameLength();
        if (framePos > (double)(frameLen - 1L)) {
            return;
        }
        int x = clip.x;
        int y = clip.y;
        int w = clip.width;
        int h = clip.height;
        switch (orient) {
            case 0: {
                horiz = true;
                len = w + 2;
                tx = x - 1;
                ty = bounds.y;
                break;
            }
            case 2: {
                horiz = false;
                len = h + 2;
                tx = bounds.x;
                ty = y - 1;
                break;
            }
            default: {
                return;
            }
        }
        if (framePos < 0.0) {
            int z = (int)(-framePos / upp);
            switch (orient) {
                case 0: {
                    tx += z;
                    break;
                }
                case 1: {
                    tx -= z;
                    break;
                }
                case 2: {
                    ty += z;
                    break;
                }
                case 3: {
                    ty -= z;
                }
            }
            framePos = 0.0;
        }
        if (framePos + (double)len * upp > (double)frameLen && (q = ((double)frameLen - framePos) / upp) > (double)(len = (int)q)) {
            ++len;
        }
        if (len < 1) {
            return;
        }
        double[] v = this.darr;
        if (v.length < len) {
            this.darr = v = new double[len];
        }
        try {
            tcModel.getValues(framePos, upp, v, 0, len);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                String msg = "Failed to get samples: framePos=" + framePos + ", fpu=" + upp + ", num=" + len + ", frameLen=" + frameLen + ", Cause: " + e.getMessage();
                logger.log(Level.FINE, msg, e);
            }
            return;
        }
        int[] val = this.iarr;
        if (val.length < len) {
            this.iarr = val = new int[len];
        }
        int base = 0xA00000;
        if (this.inverted) {
            for (i = 0; i < len; ++i) {
                val[i] = base + (int)Math.round(v[i] * pps / 1000.0);
            }
        } else {
            for (i = 0; i < len; ++i) {
                val[i] = base - (int)Math.round(v[i] * pps / 1000.0);
            }
        }
        if ((seq = this.sarr).length < len) {
            this.updateSequenceArray(len);
            seq = this.sarr;
        }
        Stroke os = g.getStroke();
        g.setStroke(this.stroke);
        g.translate(tx, ty);
        try {
            g.setColor(this.color);
            if (horiz) {
                g.drawPolyline(seq, val, len);
            } else {
                g.drawPolyline(val, seq, len);
            }
        }
        finally {
            g.setStroke(os);
            g.translate(-tx, -ty);
        }
    }

    protected void updateSequenceArray(int len) {
        if (len > this.sarr.length) {
            this.sarr = new int[len];
        } else {
            len = this.sarr.length;
        }
        for (int i = 0; i < len; ++i) {
            this.sarr[i] = i;
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }
}

