/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.view;

import com.spacekiller.util.midi.model.MidiNode;
import com.spacekiller.util.midi.model.MidiState;
import com.spacekiller.util.midi.model.Model;
import com.spacekiller.util.midi.model.Node;
import com.spacekiller.util.midi.model.NodeConsumer;
import com.spacekiller.util.midi.model.StateModel;
import com.spacekiller.util.midi.model.StateNode;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineModel;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.MidiModel;
import com.waxmonster.model.view.LineManager;
import com.waxmonster.model.view.MidiChunkRenderer;
import com.waxmonster.model.view.MidiColorPalette;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleMidiChunkRenderer
implements MidiChunkRenderer {
    private static final Logger logger = Logger.getLogger(SimpleMidiChunkRenderer.class.getName());
    public static final int DEFAULT_INIT_SIZE = 64;
    public static final int DEFAULT_NODE_LIMIT = 16384;
    public static final int CTRL_INIT_CAPACITY = 4;
    public static final int MIN_POLY_CAPACITY = 16;
    private static MidiColorPalette DEFAULT_COLOR_PALETTE;
    protected MidiColorPalette palette;
    protected LineManager lineManager;
    protected LineChunk recordingChunk;
    protected int nodeLimit = 16384;
    protected Node[] nodes;
    protected int[] polyX;
    protected int[] polyY;
    protected long maxControlInactiveMillis = 0L;
    protected long maxControlInactiveTicks;
    protected int maxControlSmoothPixels = 10;
    protected int minNoteSize = 2;
    protected int noteSize;
    protected int noteSizeHalf;
    protected Rectangle cb;
    protected long ofs;
    protected long end;
    protected long tickOfs;
    protected long startTickPos;
    protected Graphics2D g;
    protected int rx;
    protected int ry;
    protected int rw;
    protected int rh;
    protected int orient;
    protected double upp;
    protected NoteInfo firstNote;
    protected NoteInfo lastNote;
    protected NoteInfo[][] noteMatrix;
    protected CtrlInfo firstCtrl;
    protected CtrlInfo lastCtrl;
    protected CtrlInfo[][] ctrlMatrix;
    protected final NoteStateHandler noteStateHandler = new NoteStateHandler();
    protected final CtrlStateHandler ctrlStateHandler = new CtrlStateHandler();
    protected final TrackHandler trackHandler = new TrackHandler();

    protected void addChange(CtrlInfo ctrl, long tick, byte value) {
        int cnt = ctrl.cnt;
        if (cnt == 1) {
            if (tick < this.ofs) {
                ctrl.ticks[0] = tick;
                ctrl.values[0] = value;
                return;
            }
            if (this.maxControlInactiveTicks > 0L && tick - ctrl.ticks[0] > this.maxControlInactiveTicks) {
                ctrl.ticks[0] = tick;
                ctrl.values[0] = value;
                return;
            }
        }
        if (cnt >= ctrl.max) {
            int min = cnt < 1 ? 4 : cnt << 1;
            long[] newTcks = new long[min];
            byte[] newVals = new byte[min];
            if (cnt > 0) {
                System.arraycopy(ctrl.ticks, 0, newTcks, 0, cnt);
                System.arraycopy(ctrl.values, 0, newVals, 0, cnt);
            }
            ctrl.ticks = newTcks;
            ctrl.values = newVals;
            ctrl.max = min;
        }
        ctrl.ticks[cnt] = tick;
        ctrl.values[cnt] = value;
        ctrl.cnt = ++cnt;
    }

    protected void paintNote(int channel, int noteIdx, int k, int j, Color noteOnCol, Color noteCol) {
        switch (this.orient) {
            case 0: {
                int m = noteIdx * this.rh / 128;
                int q = this.rh - 1 - m - this.noteSizeHalf;
                this.g.setColor(noteCol);
                this.g.fillRect(k, q, j - k + 1, this.noteSize);
                if (noteOnCol == null) break;
                this.g.setColor(noteOnCol);
                this.g.fillRect(k, q, 1, this.noteSize);
                break;
            }
            case 2: {
                int m = noteIdx * this.rw / 128;
                int q = m - 2;
                this.g.setColor(noteCol);
                this.g.fillRect(q, k, this.noteSize, j - k + 1);
                if (noteOnCol == null) break;
                this.g.setColor(noteOnCol);
                this.g.fillRect(q, k, this.noteSize, 1);
                break;
            }
        }
    }

    public SimpleMidiChunkRenderer() {
        this(64);
    }

    public SimpleMidiChunkRenderer(int initSize) {
        int i;
        this.palette = SimpleMidiChunkRenderer.getDefaultColorPalette();
        this.nodes = new Node[initSize];
        this.polyX = new int[initSize];
        this.polyY = new int[initSize];
        this.cb = new Rectangle();
        this.noteMatrix = new NoteInfo[16][];
        for (i = 0; i < this.noteMatrix.length; ++i) {
            this.noteMatrix[i] = new NoteInfo[128];
        }
        this.ctrlMatrix = new CtrlInfo[16][];
        for (i = 0; i < this.ctrlMatrix.length; ++i) {
            this.ctrlMatrix[i] = new CtrlInfo[128];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g, Rectangle clip, Rectangle bounds, int orient, LineChunk chunk, LineModel model, long unitOfs, long unitEnd, int numPix, double pps, double upp) {
        if (!(model instanceof MidiModel)) {
            return;
        }
        MidiModel midiModel = (MidiModel)model;
        this.cb = g.getClipBounds(this.cb);
        try {
            int barSize;
            StateNode stateNode;
            this.g = g;
            this.rx = clip.x;
            this.ry = clip.y;
            this.rw = clip.width;
            this.rh = clip.height;
            this.orient = orient;
            this.upp = upp;
            g.clipRect(this.rx, this.ry, this.rw, this.rh);
            int recPos = 0;
            boolean paintRecordingHelper = false;
            if (chunk == this.recordingChunk && this.lineManager != null) {
                paintRecordingHelper = true;
                recPos = (int)LineUtil.getUnitOfs((long)this.lineManager.getTimePosition(), (double)pps);
            }
            double tickRate = midiModel.getTickRate();
            this.startTickPos = LineUtil.getUnitOfs((long)chunk.getChunkOfs(), (double)tickRate);
            this.tickOfs = LineUtil.getUnitOfs((long)chunk.getModelOfs(), (double)tickRate);
            long tickEnd = LineUtil.getUnitOfs((long)chunk.getModelEnd(), (double)tickRate);
            long spare = (long)(4.0 * upp);
            this.ofs = unitOfs - spare;
            this.end = unitEnd + spare;
            StateModel stateModel = midiModel.getStateModel();
            if (stateModel == null) {
                stateNode = null;
            } else {
                stateModel.validate(this.ofs);
                stateNode = (StateNode)stateModel.getBefore(this.ofs);
            }
            switch (orient) {
                case 0: 
                case 1: {
                    barSize = bounds.height;
                    break;
                }
                case 2: 
                case 3: {
                    barSize = bounds.width;
                    break;
                }
                default: {
                    barSize = 0;
                }
            }
            this.noteSize = barSize / 128;
            if (this.noteSize < this.minNoteSize) {
                this.noteSize = this.minNoteSize;
            }
            this.noteSizeHalf = this.noteSize / 2;
            this.maxControlInactiveTicks = this.maxControlInactiveMillis > 0L ? 1L + (long)((double)this.maxControlInactiveMillis * tickRate / 1000.0) : 0L;
            if (stateNode == null) {
                midiModel.getNodes(Long.MIN_VALUE, this.end, (NodeConsumer)this.trackHandler);
            } else {
                MidiState state = (MidiState)stateNode.getState();
                state.getNotes((NodeConsumer)this.noteStateHandler);
                state.getCtrls((NodeConsumer)this.ctrlStateHandler);
                midiModel.getNodes(state.getTick(), this.end, (NodeConsumer)this.trackHandler);
            }
            NoteInfo note = this.firstNote;
            while (note != null) {
                this.noteMatrix[note.channel][note.note] = null;
                Color noteCol = this.palette.getNoteColor(note.channel);
                if (noteCol != null) {
                    int k = (int)Math.floor(this.pixelForTick(note.tick));
                    int j = paintRecordingHelper ? recPos : (tickEnd < this.end ? (int)this.pixelForTick(tickEnd) : (int)this.pixelForTick(this.end));
                    this.paintNote(note.channel, note.note, k, j, this.palette.noteOnColor, noteCol);
                }
                note = note.next;
            }
            this.firstNote = null;
            this.lastNote = null;
            CtrlInfo ctrl = this.firstCtrl;
            while (ctrl != null) {
                block40: {
                    long max;
                    int cnt;
                    block43: {
                        block41: {
                            block42: {
                                this.ctrlMatrix[ctrl.channel][ctrl.control] = null;
                                cnt = ctrl.cnt;
                                if (cnt < 1) break block40;
                                if (this.maxControlInactiveTicks <= 0L) break block41;
                                max = ctrl.ticks[cnt - 1] + this.maxControlInactiveTicks;
                                if (max >= this.ofs) break block42;
                                ctrl.cnt = 0;
                                break block40;
                            }
                            if (max > this.end) {
                                max = this.end;
                            }
                            break block43;
                        }
                        max = this.end;
                    }
                    if (tickEnd < max) {
                        max = tickEnd;
                    }
                    int pn = 0;
                    int px = 0;
                    int py = 0;
                    switch (orient) {
                        case 0: {
                            int y;
                            int x;
                            double p;
                            int i;
                            int rhm1 = this.rh - 4;
                            for (i = 0; i < cnt; ++i) {
                                p = this.pixelForTick(ctrl.ticks[i]);
                                x = (int)p;
                                y = this.rh - 3 - (int)((double)(ctrl.values[i] * rhm1) / 127.0);
                                if (i == 0) {
                                    this.setPolyPoint(pn++, x, y);
                                } else if (x - px > this.maxControlSmoothPixels) {
                                    this.setPolyPoint(pn++, x - 1, py);
                                    this.setPolyPoint(pn++, x, y);
                                } else {
                                    this.setPolyPoint(pn++, x, y);
                                }
                                px = x;
                                py = y;
                            }
                            if (paintRecordingHelper) {
                                x = recPos;
                                if (x <= px) break;
                                this.setPolyPoint(pn++, x, py);
                                break;
                            }
                            x = (int)Math.ceil(this.pixelForTick(max));
                            if (x <= px) break;
                            this.setPolyPoint(pn++, x, py);
                            break;
                        }
                        case 2: {
                            int y;
                            int x;
                            double p;
                            int i;
                            int rwm2 = this.rw - 4;
                            for (i = 0; i < cnt; ++i) {
                                p = this.pixelForTick(ctrl.ticks[i]);
                                y = (int)p;
                                x = 1 + (int)((double)(ctrl.values[i] * rwm2) / 127.0);
                                if (i == 0) {
                                    this.setPolyPoint(pn++, x, y);
                                } else if (y - py > this.maxControlSmoothPixels) {
                                    this.setPolyPoint(pn++, px, y - 1);
                                    this.setPolyPoint(pn++, x, y);
                                } else {
                                    this.setPolyPoint(pn++, x, y);
                                }
                                px = x;
                                py = y;
                            }
                            if (paintRecordingHelper) {
                                y = recPos;
                                if (y <= py) break;
                                this.setPolyPoint(pn++, px, y);
                                break;
                            }
                            y = (int)Math.ceil(this.pixelForTick(max));
                            if (y <= py) break;
                            this.setPolyPoint(pn++, px, y);
                            break;
                        }
                    }
                    if (pn > this.polyX.length) {
                        pn = this.polyX.length;
                    }
                    if (pn > this.polyY.length) {
                        pn = this.polyY.length;
                    }
                    g.setColor(ctrl.color);
                    g.drawPolyline(this.polyX, this.polyY, pn);
                    ctrl.cnt = 0;
                }
                ctrl = ctrl.next;
            }
            this.firstCtrl = null;
            this.lastCtrl = null;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            g.setClip(this.cb.x, this.cb.y, this.cb.width, this.cb.height);
            this.g = null;
        }
    }

    protected int getNodes(Model model, long ofs, long end) {
        int max = this.nodes.length;
        int count;
        while ((count = model.getNodes(ofs, end, this.nodes, 0, max)) < 0) {
            count = max * 2;
            if (count > this.nodeLimit) {
                return max;
            }
            this.nodes = new Node[count];
            max = count;
        }
        return count;
    }

    protected double pixelForTick(long tick) {
        return (double)(tick - this.tickOfs + this.startTickPos) / this.upp;
    }

    protected void setPolyPoint(int i, int x, int y) {
        if (i < this.polyX.length) {
            this.polyX[i] = x;
            this.polyY[i] = y;
            return;
        }
        int newLen = i << 1;
        if (newLen > this.nodeLimit) {
            return;
        }
        int[] newPolyX = new int[newLen];
        int[] newPolyY = new int[newLen];
        System.arraycopy(this.polyX, 0, newPolyX, 0, this.polyX.length);
        System.arraycopy(this.polyY, 0, newPolyY, 0, this.polyY.length);
        newPolyX[i] = x;
        newPolyY[i] = y;
        this.polyX = newPolyX;
        this.polyY = newPolyY;
    }

    protected void drawLine(Node n, Graphics2D g, int k, int w, int h) {
        switch (this.orient) {
            case 0: {
                g.drawLine(k, 0, k, h);
                break;
            }
            case 2: {
                g.drawLine(0, k, w, k);
                break;
            }
            case 1: {
                g.drawLine(w - 1 - k, 0, w - 1 - k, h);
                break;
            }
            case 3: {
                g.drawLine(0, h - 1 - k, w, h - 1 - k);
            }
        }
    }

    protected void fillRect3(Node n, Graphics2D g, int k, int w, int h, double d) {
        switch (this.orient) {
            case 0: {
                int m = (int)(d * (double)h);
                g.fillRect(k, h - 1 - m - 1, 3, 3);
                break;
            }
            case 2: {
                int m = (int)(d * (double)w);
                g.fillRect(m - 1, k, 3, 3);
                break;
            }
            case 1: {
                int m = (int)(d * (double)h);
                g.fillRect(w - 1 - k - 2, h - 1 - m - 1, 3, 3);
                break;
            }
            case 3: {
                int m = (int)(d * (double)w);
                g.fillRect(m - 1, h - 1 - k - 2, 3, 3);
                break;
            }
        }
    }

    protected void fillRect5(Node n, Graphics2D g, int k, int w, int h, double d) {
        switch (this.orient) {
            case 0: {
                int m = (int)(d * (double)h);
                g.fillRect(k, h - 1 - m - 2, 5, 5);
                break;
            }
            case 2: {
                int m = (int)(d * (double)w);
                g.fillRect(m - 2, k, 5, 5);
                break;
            }
            case 1: {
                int m = (int)(d * (double)h);
                g.fillRect(w - 1 - k - 4, h - 1 - m - 2, 5, 5);
                break;
            }
            case 3: {
                int m = (int)(d * (double)w);
                g.fillRect(m - 2, h - 1 - k - 4, 5, 5);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static MidiColorPalette getDefaultColorPalette() {
        MidiColorPalette p = DEFAULT_COLOR_PALETTE;
        if (p != null) return p;
        Class<MidiColorPalette> clazz = MidiColorPalette.class;
        synchronized (MidiColorPalette.class) {
            p = DEFAULT_COLOR_PALETTE;
            if (p != null) return p;
            DEFAULT_COLOR_PALETTE = p = MidiColorPalette.createDefaultColorPalette();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return p;
        }
    }

    protected MidiColorPalette getPalette() {
        return this.palette;
    }

    @Override
    public void setPalette(MidiColorPalette palette) {
        if (palette == null) {
            palette = SimpleMidiChunkRenderer.getDefaultColorPalette();
        }
        this.palette = palette;
    }

    @Override
    public int getNodeLimit() {
        return this.nodeLimit;
    }

    @Override
    public void setNodeLimit(int nodeLimit) {
        this.nodeLimit = nodeLimit;
    }

    @Override
    public long getMaxControlInactiveMillis() {
        return this.maxControlInactiveMillis;
    }

    @Override
    public void setMaxControlInactiveMillis(long maxControlInactiveMillis) {
        this.maxControlInactiveMillis = maxControlInactiveMillis;
    }

    @Override
    public int getMaxControlSmoothPixels() {
        return this.maxControlSmoothPixels;
    }

    @Override
    public void setMaxControlSmoothPixels(int maxControlSmoothPixels) {
        this.maxControlSmoothPixels = maxControlSmoothPixels;
    }

    @Override
    public int getMinNoteSize() {
        return this.minNoteSize;
    }

    @Override
    public void setMinNoteSize(int minNoteSize) {
        this.minNoteSize = minNoteSize;
    }

    protected LineManager getLineManager() {
        return this.lineManager;
    }

    @Override
    public void setLineManager(LineManager lineManager) {
        this.lineManager = lineManager;
    }

    protected LineChunk getRecordingChunk() {
        return this.recordingChunk;
    }

    @Override
    public void setRecordingChunk(LineChunk recordingChunk) {
        this.recordingChunk = recordingChunk;
    }

    protected class TrackHandler
    implements NodeConsumer {
        protected TrackHandler() {
        }

        public boolean consume(Node node) {
            block39: {
                MidiNode n = (MidiNode)node;
                int status = n.getStatus();
                block0 : switch (status & 0xF0) {
                    case 176: {
                        int channel = status & 0xF;
                        int control = n.getData1();
                        CtrlInfo ctrl = SimpleMidiChunkRenderer.this.ctrlMatrix[channel][control];
                        if (ctrl == null) {
                            Color col = SimpleMidiChunkRenderer.this.palette.getControlColor(channel, control);
                            if (col == null) break;
                            ctrl = new CtrlInfo();
                            ctrl.channel = channel;
                            ctrl.control = control;
                            ctrl.color = col;
                            ctrl.prev = SimpleMidiChunkRenderer.this.lastCtrl;
                            if (SimpleMidiChunkRenderer.this.lastCtrl == null) {
                                SimpleMidiChunkRenderer.this.firstCtrl = ctrl;
                            } else {
                                SimpleMidiChunkRenderer.this.lastCtrl.next = ctrl;
                            }
                            SimpleMidiChunkRenderer.this.lastCtrl = ctrl;
                            SimpleMidiChunkRenderer.this.ctrlMatrix[channel][control] = ctrl;
                        }
                        SimpleMidiChunkRenderer.this.addChange(ctrl, n.getTick(), (byte)n.getData2());
                        break;
                    }
                    case 128: 
                    case 144: {
                        Color noteCol;
                        int channel = status & 0xF;
                        int noteIdx = n.getData1();
                        int val = n.getData2();
                        long tick = n.getTick();
                        NoteInfo note = SimpleMidiChunkRenderer.this.noteMatrix[channel][noteIdx];
                        if (note == null) {
                            if (val < 1) break;
                            note = new NoteInfo();
                            note.channel = channel;
                            note.note = noteIdx;
                            note.value = val;
                            note.tick = tick;
                            note.prev = SimpleMidiChunkRenderer.this.lastNote;
                            if (SimpleMidiChunkRenderer.this.lastNote == null) {
                                SimpleMidiChunkRenderer.this.firstNote = note;
                            } else {
                                SimpleMidiChunkRenderer.this.lastNote.next = note;
                            }
                            SimpleMidiChunkRenderer.this.lastNote = note;
                            SimpleMidiChunkRenderer.this.noteMatrix[channel][noteIdx] = note;
                            break;
                        }
                        if (val > 0 && (status & 0xF0) != 128) break;
                        if (tick >= SimpleMidiChunkRenderer.this.ofs && (noteCol = SimpleMidiChunkRenderer.this.palette.getNoteColor(channel)) != null) {
                            int k = (int)Math.floor(SimpleMidiChunkRenderer.this.pixelForTick(note.tick));
                            int j = (int)Math.ceil(SimpleMidiChunkRenderer.this.pixelForTick(tick));
                            SimpleMidiChunkRenderer.this.paintNote(channel, noteIdx, k, j, SimpleMidiChunkRenderer.this.palette.noteOnColor, noteCol);
                        }
                        if (note.prev == null) {
                            SimpleMidiChunkRenderer.this.firstNote = note.next;
                        } else {
                            note.prev.next = note.next;
                        }
                        if (note.next == null) {
                            SimpleMidiChunkRenderer.this.lastNote = note.prev;
                        } else {
                            note.next.prev = note.prev;
                        }
                        SimpleMidiChunkRenderer.this.noteMatrix[channel][noteIdx] = null;
                        break;
                    }
                    case 192: {
                        Color col;
                        long tick = n.getTick();
                        if (tick < SimpleMidiChunkRenderer.this.ofs || (col = SimpleMidiChunkRenderer.this.palette.programChangeColor) == null) break;
                        int k = (int)Math.floor(SimpleMidiChunkRenderer.this.pixelForTick(tick));
                        SimpleMidiChunkRenderer.this.g.setColor(col);
                        SimpleMidiChunkRenderer.this.drawLine((Node)n, SimpleMidiChunkRenderer.this.g, k, SimpleMidiChunkRenderer.this.rw, SimpleMidiChunkRenderer.this.rh);
                        break;
                    }
                    case 208: {
                        Color col;
                        long tick = n.getTick();
                        if (tick < SimpleMidiChunkRenderer.this.ofs || (col = SimpleMidiChunkRenderer.this.palette.channelPressureColor) == null) break;
                        int k = (int)Math.floor(SimpleMidiChunkRenderer.this.pixelForTick(tick));
                        SimpleMidiChunkRenderer.this.g.setColor(col);
                        SimpleMidiChunkRenderer.this.fillRect3((Node)n, SimpleMidiChunkRenderer.this.g, k, SimpleMidiChunkRenderer.this.rw, SimpleMidiChunkRenderer.this.rh, (double)n.getData1() / 128.0);
                        break;
                    }
                    case 224: {
                        Color col;
                        long tick = n.getTick();
                        if (tick < SimpleMidiChunkRenderer.this.ofs || (col = SimpleMidiChunkRenderer.this.palette.pitchBendColor) == null) break;
                        int k = (int)Math.floor(SimpleMidiChunkRenderer.this.pixelForTick(tick));
                        int lsb = n.getData1() & 0x7F;
                        int msb = n.getData2() & 0x7F;
                        int bend = msb << 7 | lsb;
                        SimpleMidiChunkRenderer.this.g.setColor(col);
                        SimpleMidiChunkRenderer.this.fillRect3((Node)n, SimpleMidiChunkRenderer.this.g, k, SimpleMidiChunkRenderer.this.rw, SimpleMidiChunkRenderer.this.rh, (double)bend / 16384.0);
                        break;
                    }
                    case 240: {
                        switch (status) {
                            case 240: {
                                Color col;
                                long tick = n.getTick();
                                if (tick >= SimpleMidiChunkRenderer.this.ofs && (col = SimpleMidiChunkRenderer.this.palette.systemExclusiveColor) != null) {
                                    int k = (int)Math.floor(SimpleMidiChunkRenderer.this.pixelForTick(tick));
                                    SimpleMidiChunkRenderer.this.g.setColor(col);
                                    SimpleMidiChunkRenderer.this.drawLine((Node)n, SimpleMidiChunkRenderer.this.g, k, SimpleMidiChunkRenderer.this.rw, SimpleMidiChunkRenderer.this.rh);
                                    break block0;
                                }
                                break block39;
                            }
                            case 241: {
                                break block0;
                            }
                            case 242: {
                                Color col;
                                long tick = n.getTick();
                                if (tick >= SimpleMidiChunkRenderer.this.ofs && (col = SimpleMidiChunkRenderer.this.palette.songPositionPointerColor) != null) {
                                    int k = (int)Math.floor(SimpleMidiChunkRenderer.this.pixelForTick(tick));
                                    SimpleMidiChunkRenderer.this.g.setColor(col);
                                    SimpleMidiChunkRenderer.this.drawLine((Node)n, SimpleMidiChunkRenderer.this.g, k, SimpleMidiChunkRenderer.this.rw, SimpleMidiChunkRenderer.this.rh);
                                    break block0;
                                }
                                break block39;
                            }
                            case 243: {
                                Color col;
                                long tick = n.getTick();
                                if (tick >= SimpleMidiChunkRenderer.this.ofs && (col = SimpleMidiChunkRenderer.this.palette.songSelectColor) != null) {
                                    int k = (int)Math.floor(SimpleMidiChunkRenderer.this.pixelForTick(tick));
                                    SimpleMidiChunkRenderer.this.g.setColor(col);
                                    SimpleMidiChunkRenderer.this.drawLine((Node)n, SimpleMidiChunkRenderer.this.g, k, SimpleMidiChunkRenderer.this.rw, SimpleMidiChunkRenderer.this.rh);
                                    break block0;
                                }
                                break block39;
                            }
                            case 246: {
                                Color col;
                                long tick = n.getTick();
                                if (tick >= SimpleMidiChunkRenderer.this.ofs && (col = SimpleMidiChunkRenderer.this.palette.tuneRequestColor) != null) {
                                    int k = (int)Math.floor(SimpleMidiChunkRenderer.this.pixelForTick(tick));
                                    SimpleMidiChunkRenderer.this.g.setColor(col);
                                    SimpleMidiChunkRenderer.this.drawLine((Node)n, SimpleMidiChunkRenderer.this.g, k, SimpleMidiChunkRenderer.this.rw, SimpleMidiChunkRenderer.this.rh);
                                    break block0;
                                }
                                break block39;
                            }
                            case 248: {
                                break block0;
                            }
                            case 250: {
                                Color col;
                                long tick = n.getTick();
                                if (tick >= SimpleMidiChunkRenderer.this.ofs && (col = SimpleMidiChunkRenderer.this.palette.startColor) != null) {
                                    int k = (int)Math.floor(SimpleMidiChunkRenderer.this.pixelForTick(tick));
                                    SimpleMidiChunkRenderer.this.g.setColor(col);
                                    SimpleMidiChunkRenderer.this.drawLine((Node)n, SimpleMidiChunkRenderer.this.g, k, SimpleMidiChunkRenderer.this.rw, SimpleMidiChunkRenderer.this.rh);
                                    break block0;
                                }
                                break block39;
                            }
                            case 251: {
                                Color col;
                                long tick = n.getTick();
                                if (tick >= SimpleMidiChunkRenderer.this.ofs && (col = SimpleMidiChunkRenderer.this.palette.continueColor) != null) {
                                    int k = (int)Math.floor(SimpleMidiChunkRenderer.this.pixelForTick(tick));
                                    SimpleMidiChunkRenderer.this.g.setColor(col);
                                    SimpleMidiChunkRenderer.this.drawLine((Node)n, SimpleMidiChunkRenderer.this.g, k, SimpleMidiChunkRenderer.this.rw, SimpleMidiChunkRenderer.this.rh);
                                    break block0;
                                }
                                break block39;
                            }
                            case 252: {
                                Color col;
                                long tick = n.getTick();
                                if (tick >= SimpleMidiChunkRenderer.this.ofs && (col = SimpleMidiChunkRenderer.this.palette.stopColor) != null) {
                                    int k = (int)Math.floor(SimpleMidiChunkRenderer.this.pixelForTick(tick));
                                    SimpleMidiChunkRenderer.this.g.setColor(col);
                                    SimpleMidiChunkRenderer.this.drawLine((Node)n, SimpleMidiChunkRenderer.this.g, k, SimpleMidiChunkRenderer.this.rw, SimpleMidiChunkRenderer.this.rh);
                                    break block0;
                                }
                                break block39;
                            }
                            case 254: {
                                break block0;
                            }
                            case 255: {
                                break block0;
                            }
                        }
                    }
                }
            }
            return true;
        }
    }

    protected class CtrlStateHandler
    implements NodeConsumer {
        protected CtrlStateHandler() {
        }

        public boolean consume(Node node) {
            int control;
            MidiNode n = (MidiNode)node;
            int channel = n.getStatus() & 0xF;
            Color col = SimpleMidiChunkRenderer.this.palette.getControlColor(channel, control = n.getData1());
            if (col != null) {
                CtrlInfo ctrl = new CtrlInfo();
                ctrl.channel = channel;
                ctrl.control = control;
                ctrl.color = col;
                ctrl.prev = SimpleMidiChunkRenderer.this.lastCtrl;
                if (SimpleMidiChunkRenderer.this.lastCtrl == null) {
                    SimpleMidiChunkRenderer.this.firstCtrl = ctrl;
                } else {
                    SimpleMidiChunkRenderer.this.lastCtrl.next = ctrl;
                }
                SimpleMidiChunkRenderer.this.lastCtrl = ctrl;
                SimpleMidiChunkRenderer.this.ctrlMatrix[ctrl.channel][ctrl.control] = ctrl;
                SimpleMidiChunkRenderer.this.addChange(ctrl, n.getTick(), (byte)n.getData2());
            }
            return true;
        }
    }

    protected class NoteStateHandler
    implements NodeConsumer {
        protected NoteStateHandler() {
        }

        public boolean consume(Node node) {
            MidiNode n = (MidiNode)node;
            int status = n.getStatus();
            switch (status & 0xF0) {
                case 144: {
                    if (n.getData2() != 0) break;
                    return true;
                }
                case 128: {
                    return true;
                }
            }
            NoteInfo note = new NoteInfo();
            note.channel = status & 0xF;
            note.note = n.getData1();
            note.value = n.getData2();
            note.tick = n.getTick();
            note.prev = SimpleMidiChunkRenderer.this.lastNote;
            if (SimpleMidiChunkRenderer.this.lastNote == null) {
                SimpleMidiChunkRenderer.this.firstNote = note;
            } else {
                SimpleMidiChunkRenderer.this.lastNote.next = note;
            }
            SimpleMidiChunkRenderer.this.lastNote = note;
            SimpleMidiChunkRenderer.this.noteMatrix[note.channel][note.note] = note;
            return true;
        }
    }

    protected static class CtrlInfo {
        protected CtrlInfo prev;
        protected CtrlInfo next;
        protected int channel;
        protected int control;
        protected Color color;
        protected int cnt;
        protected int max;
        protected long[] ticks;
        protected byte[] values;

        protected CtrlInfo() {
        }
    }

    protected static class NoteInfo {
        protected NoteInfo prev;
        protected NoteInfo next;
        protected int channel;
        protected int note;
        protected int value;
        protected long tick;

        protected NoteInfo() {
        }
    }
}

