/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.view;

import com.spacekiller.util.sound.AudioMath;
import com.spacekiller.util.sound.AudioMathImpl;
import com.spacekiller.util.sound.FFT;
import com.waxmonster.model.AudioModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineModel;
import com.waxmonster.model.view.ChunkRenderer;
import com.waxmonster.model.view.Col;
import com.waxmonster.model.view.ColUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SpectroAudioChunkRenderer
implements ChunkRenderer {
    private static final Logger logger = Logger.getLogger(SpectroAudioChunkRenderer.class.getName());
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final Col[] EMPTY_COL_ARRAY = new Col[0];
    private static final int MIN_FFT = 1024;
    protected int channel;
    protected AudioModel audioModel;
    protected int chs;
    protected int fpp;
    protected int spp;
    protected double[] buf;
    protected double min;
    protected double max;
    protected Paint backgroundPaint = Color.DARK_GRAY;
    protected BufferedImage bi;
    protected Graphics2D bg;
    protected WritableRaster br;
    protected int[] col = new int[]{255, 0, 0, 255};
    protected AudioMath audioMath;
    protected int fppOld;
    protected FFT fft;
    protected int ffn;
    protected int fbs;
    protected double[] real;
    protected double[] imag;
    protected ColUtil colUtil;
    protected Col[] cols = EMPTY_COL_ARRAY;
    protected float colRate;

    public SpectroAudioChunkRenderer() {
        this.buf = EMPTY_DOUBLE_ARRAY;
        this.real = EMPTY_DOUBLE_ARRAY;
        this.imag = EMPTY_DOUBLE_ARRAY;
        this.audioMath = new AudioMathImpl();
        this.colUtil = ColUtil.getInstance();
    }

    @Override
    public void paint(Graphics2D g, Rectangle clip, Rectangle bounds, int orient, LineChunk chunk, LineModel model, long unitOfs, long unitEnd, int numPix, double pps, double upp) {
        float rate;
        if (!(model instanceof AudioModel)) {
            return;
        }
        this.audioModel = (AudioModel)model;
        this.chs = this.audioModel.getChannels();
        if (this.chs < 1) {
            return;
        }
        this.fpp = (int)Math.ceil(upp);
        if (this.fpp < 1) {
            this.fpp = 1;
        }
        this.spp = this.fpp * this.chs;
        if (this.fpp != this.fppOld) {
            this.fppOld = this.fpp;
            int power2 = this.power2(Math.max(1024, this.fpp));
            if (power2 != this.ffn) {
                this.ffn = power2;
                this.fft = this.audioMath.getFFT(this.ffn);
                if (this.real.length < this.ffn) {
                    this.real = new double[this.ffn];
                    this.imag = new double[this.ffn];
                    Col[] arr = new Col[this.ffn];
                    System.arraycopy(this.cols, 0, arr, 0, this.cols.length);
                    for (int i = this.cols.length; i < this.ffn; ++i) {
                        arr[i] = new Col();
                    }
                    this.cols = arr;
                }
                this.colRate = -1.0f;
            }
        }
        this.fbs = this.ffn * this.chs;
        if (this.buf.length < this.fbs) {
            this.buf = new double[this.fbs];
        }
        if ((rate = this.audioModel.getFrameRate()) != this.colRate) {
            this.colRate = rate;
            this.colUtil.getFreqSpectrum(this.cols, this.ffn, rate);
        }
        int rx = clip.x;
        int ry = clip.y;
        int rw = clip.width;
        int rh = clip.height;
        if (this.bi == null || this.bi.getWidth() < rw || this.bi.getHeight() < rh) {
            if (this.bg != null) {
                this.bg.dispose();
            }
            if (this.bi != null) {
                this.bi.flush();
            }
            this.bi = new BufferedImage(rw, rh, 1);
            this.bg = this.bi.createGraphics();
            this.br = this.bi.getRaster();
        }
        this.bg.setPaint(this.backgroundPaint);
        this.bg.fillRect(0, 0, rw, rh);
        double framePos = unitOfs;
        long frameEnd = this.audioModel.getFrameLength();
        try {
            switch (orient) {
                case 0: {
                    double full = bounds.height;
                    double half = full / 2.0;
                    double mid = half - (double)ry;
                    for (int i = 0; i < numPix; ++i) {
                        if (this.process(framePos, frameEnd)) {
                            double val = -this.min > this.max ? -this.min : this.max;
                            int pix = (int)(mid - val * half);
                            int end = pix + Math.max(1, (int)(val * full));
                            if (pix < 0) {
                                pix = 0;
                            }
                            if (end >= rh) {
                                end = rh;
                            }
                            while (pix < end) {
                                this.br.setPixel(i, pix++, this.col);
                            }
                        }
                        framePos += upp;
                    }
                    break;
                }
                case 2: {
                    double full = bounds.width;
                    double half = full / 2.0;
                    double mid = half - (double)rx;
                    for (int i = 0; i < numPix; ++i) {
                        if (this.process(framePos, frameEnd)) {
                            double val = -this.min > this.max ? -this.min : this.max;
                            int pix = (int)(mid - val * half);
                            int end = pix + Math.max(1, (int)(val * full));
                            if (pix < 0) {
                                pix = 0;
                            }
                            if (end >= rw) {
                                end = rw;
                            }
                            while (pix < end) {
                                this.br.setPixel(pix++, i, this.col);
                            }
                        }
                        framePos += upp;
                    }
                    break;
                }
                default: {
                    return;
                }
            }
            g.drawImage(this.bi, rx, ry, rx + rw, ry + rh, 0, 0, rw, rh, null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected boolean process(double framePos, long frameEnd) throws Exception {
        double val;
        int i;
        if (framePos < 0.0) {
            return false;
        }
        if (framePos + (double)this.ffn >= (double)frameEnd) {
            return false;
        }
        this.audioModel.get((long)this.chs * (long)framePos, this.buf, 0, this.fbs);
        int len = this.spp;
        double min = 0.0;
        double max = 0.0;
        int k = this.channel;
        if (k < 0) {
            for (i = 0; i < len; ++i) {
                val = this.buf[i];
                if (val > max) {
                    max = val;
                    continue;
                }
                if (!(val < min)) continue;
                min = val;
            }
        } else {
            if (k >= this.chs) {
                k = 0;
            }
            for (i = k; i < len; i += this.chs) {
                val = this.buf[i];
                if (val > max) {
                    max = val;
                    continue;
                }
                if (!(val < min)) continue;
                min = val;
            }
        }
        this.min = min;
        this.max = max;
        len = this.fbs;
        i = 0;
        if (k < 0) {
            k = 0;
        }
        while (k < len) {
            this.real[i] = this.buf[k];
            this.imag[i] = 0.0;
            ++i;
            k += this.chs;
        }
        this.fft.fft(this.real, this.imag);
        this.colorizeV3(this.real, this.imag, this.ffn);
        return true;
    }

    protected void colorizeV1(double[] real, double[] imag, int len) {
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        for (int i = 1; i < len; ++i) {
            double vr = real[i];
            double vi = imag[i];
            double v = Math.sqrt(vr * vr + vi * vi);
            r += (double)this.cols[i].r * v;
            g += (double)this.cols[i].g * v;
            b += (double)this.cols[i].b * v;
        }
        double max = r > g ? (r > b ? r : b) : (g > b ? g : b);
        this.col[0] = (int)(r * 255.0 / max);
        this.col[1] = (int)(g * 255.0 / max);
        this.col[2] = (int)(b * 255.0 / max);
    }

    protected void colorizeV2(double[] real, double[] imag, int len) {
        int iMax = 0;
        double vMax = 0.0;
        for (int i = 1; i < len; ++i) {
            double vr = real[i];
            double vi = imag[i];
            double v = Math.sqrt(vr * vr + vi * vi);
            if (!((v *= (double)i) > vMax)) continue;
            vMax = v;
            iMax = i;
        }
        if ((vMax /= (double)iMax) > 1.0) {
            vMax = 1.0;
        }
        this.col[0] = (int)((double)this.cols[iMax].r * vMax * 255.0);
        this.col[1] = (int)((double)this.cols[iMax].g * vMax * 255.0);
        this.col[2] = (int)((double)this.cols[iMax].b * vMax * 255.0);
    }

    protected void colorizeV3(double[] real, double[] imag, int len) {
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        for (int i = 1; i < len; ++i) {
            double vr = real[i];
            double vi = imag[i];
            double v = Math.sqrt(vr * vr + vi * vi);
            r += (double)this.cols[i].r * (v *= (double)i);
            g += (double)this.cols[i].g * v;
            b += (double)this.cols[i].b * v;
        }
        double max = r > g ? (r > b ? r : b) : (g > b ? g : b);
        this.col[0] = (int)(r * 255.0 / max);
        this.col[1] = (int)(g * 255.0 / max);
        this.col[2] = (int)(b * 255.0 / max);
    }

    protected int power2(int min) {
        for (long power = 2L; power < Integer.MAX_VALUE; power *= 2L) {
            if (power < (long)min) continue;
            return (int)power;
        }
        return 2;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint backgroundPaint) {
        if (backgroundPaint == null) {
            throw new NullPointerException("backgroundPaint");
        }
        this.backgroundPaint = backgroundPaint;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public AudioMath getAudioMath() {
        return this.audioMath;
    }

    public void setAudioMath(AudioMath audioMath) {
        this.audioMath = audioMath;
    }
}

