/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.view;

import com.waxmonster.fader.Fader;
import com.waxmonster.fader.FaderConfig;
import com.waxmonster.fader.VolumeShader;
import com.waxmonster.fader.impl.VolumeShaderBase;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineModel;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.MidiModel;
import com.waxmonster.model.impl.MidiModelFaderDecoder;
import com.waxmonster.model.view.ChunkRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class VolumeShaderMidiChunkRenderer
implements ChunkRenderer {
    public static final int DEFAULT_SHADER_EVENT_QUEUE_SIZE = 4000;
    public static final int DEFAULT_SHADER_CACHE_CAPACITY = 20;
    private static final Color[] DUMMY_SHADE_COLORS = new Color[]{Color.RED, Color.GREEN, Color.BLUE};
    protected final int channels;
    protected final boolean monoMix;
    protected MidiModelFaderDecoder faderDecoder;
    protected RenderVolumeShader[] volumeShaders;
    protected double[] vol;
    protected Color[] shadeColors;
    protected int cacheCapacity;

    public VolumeShaderMidiChunkRenderer(int channels, boolean monoMix, int eventQueueSize, int cacheCapacity) {
        VolumeShader[] shaders;
        if (channels < 1) {
            throw new IllegalArgumentException("channels: " + channels + " < 1");
        }
        this.channels = channels;
        this.monoMix = monoMix;
        this.shadeColors = DUMMY_SHADE_COLORS;
        if (monoMix && channels > 1) {
            MonoMixVolumeShader shader = new MonoMixVolumeShader();
            shader.setOutputChannels(channels);
            shader.setChannelMask(0);
            shader.setEventQueueSize(eventQueueSize);
            shaders = new RenderVolumeShader[]{shader};
        } else {
            shaders = new RenderVolumeShader[channels];
            for (int i = 0; i < channels; ++i) {
                RenderVolumeShader shader = new RenderVolumeShader();
                shader.setOutputChannels(channels);
                shader.setChannelMask(0xFFFFFFFF ^ 1 << i);
                shader.setEventQueueSize(eventQueueSize);
                shaders[i] = shader;
            }
        }
        this.volumeShaders = shaders;
        this.vol = new double[shaders.length];
        this.faderDecoder = new MidiModelFaderDecoder(cacheCapacity);
        this.faderDecoder.setChannelCount(channels);
        this.faderDecoder.setVolumeShaderArray(shaders);
    }

    public final int getChannels() {
        return this.channels;
    }

    public final boolean isMonoMix() {
        return this.monoMix;
    }

    public FaderConfig[] getFaderConfigArray() {
        return this.faderDecoder.getFaderConfigArray();
    }

    public void setFaderConfigArray(FaderConfig[] array) {
        if (array == this.faderDecoder.getFaderConfigArray()) {
            return;
        }
        this.faderDecoder.setFaderConfigArray(array);
    }

    protected Color[] getShadeColors() {
        return this.shadeColors;
    }

    public void setShadeColors(Color[] shadeColors) {
        this.shadeColors = shadeColors;
    }

    public int getCacheCapacity() {
        return this.cacheCapacity;
    }

    public void setCacheCapacity(int cacheCapacity) {
        if (cacheCapacity < 0) {
            cacheCapacity = 0;
        }
        this.cacheCapacity = cacheCapacity;
        this.faderDecoder.setCacheCapacity(cacheCapacity);
    }

    public void clearCache() {
        this.faderDecoder.clearCache();
    }

    @Override
    public void paint(Graphics2D g, Rectangle clip, Rectangle bounds, int orient, LineChunk chunk, LineModel model, long unitOfs, long unitEnd, int numPix, double pps, double upp) {
        RenderVolumeShader shader;
        int i;
        int ty;
        int tx;
        int len;
        boolean horiz;
        MidiModelFaderDecoder decoder = this.faderDecoder;
        if (decoder == null) {
            return;
        }
        if (!(model instanceof MidiModel)) {
            return;
        }
        MidiModel midiModel = (MidiModel)model;
        int x = clip.x;
        int y = clip.y;
        int w = clip.width;
        int h = clip.height;
        switch (orient) {
            case 0: {
                horiz = true;
                len = Math.min(w, numPix);
                tx = x;
                ty = clip.y;
                break;
            }
            case 2: {
                horiz = false;
                len = Math.min(h, numPix);
                ty = y;
                tx = clip.x;
                break;
            }
            default: {
                return;
            }
        }
        long unitMax = unitOfs + (long)Math.ceil((double)len * upp);
        if (unitEnd > unitMax) {
            unitEnd = unitMax;
        }
        decoder.setMidiModel(midiModel);
        decoder.seekTick(unitOfs);
        int shaders = this.volumeShaders.length;
        for (i = 0; i < shaders; ++i) {
            shader = this.volumeShaders[i];
            this.vol[i] = shader.vol;
            shader.clearQueue();
        }
        decoder.decodeTicks(unitEnd);
        float tickRate = midiModel.getTickRate();
        long time = LineUtil.getNanoOfs((long)unitOfs, (double)tickRate);
        long npp = LineUtil.getNanoOfs((double)upp, (double)tickRate);
        if (horiz) {
            if (shaders == 1) {
                shader = this.volumeShaders[0];
                QueueState state = shader.getQueueState();
                this.render(g, tx, ty, len, h, horiz, time, this.vol[0], npp, state);
            } else {
                int prt = h / shaders;
                int py = prt + h % shaders;
                shader = this.volumeShaders[0];
                QueueState state = shader.getQueueState();
                this.render(g, tx, ty, len, py, horiz, time, this.vol[0], npp, state);
                py += ty;
                for (i = 1; i < shaders; ++i) {
                    shader = this.volumeShaders[i];
                    state = shader.getQueueState();
                    this.render(g, tx, py, len, prt, horiz, time, this.vol[i], npp, state);
                    py += prt;
                }
            }
        } else if (shaders == 1) {
            shader = this.volumeShaders[0];
            QueueState state = shader.getQueueState();
            this.render(g, tx, ty, w, len, horiz, time, this.vol[0], npp, state);
        } else {
            int prt = w / shaders;
            int px = prt + w % shaders;
            shader = this.volumeShaders[0];
            QueueState state = shader.getQueueState();
            this.render(g, tx, ty, px, len, horiz, time, this.vol[0], npp, state);
            px += tx;
            for (i = 1; i < shaders; ++i) {
                shader = this.volumeShaders[i];
                state = shader.getQueueState();
                this.render(g, px, ty, prt, len, horiz, time, this.vol[i], npp, state);
                px += prt;
            }
        }
    }

    protected void render(Graphics2D g, int x, int y, int w, int h, boolean horiz, long time, double vol, long npp, QueueState state) {
        Color[] cols = this.shadeColors;
        int cc = cols.length - 1;
        int zx = 0;
        int zc = (int)(vol * (double)cc);
        int n = state.tail;
        long[] evt = state.evt;
        double[] evp = state.evp;
        for (int i = 0; i < n; ++i) {
            long et = evt[i];
            int ec = (int)(evp[i] * (double)cc);
            if (ec == zc) continue;
            int ex = (int)((et - time) / npp);
            if (ex > zx) {
                if (zc > cc) {
                    zc = cc;
                } else if (zc < 0) {
                    zc = 0;
                }
                if (horiz) {
                    if (ex > w) break;
                    g.setColor(cols[zc]);
                    g.fillRect(x + zx, y, ex - zx, h);
                } else {
                    if (ex > h) break;
                    g.setColor(cols[zc]);
                    g.fillRect(x, y + zx, w, ex - zx);
                }
                zx = ex;
            }
            zc = ec;
        }
        if (zc > cc) {
            zc = cc;
        } else if (zc < 0) {
            zc = 0;
        }
        if (horiz) {
            g.setColor(cols[zc]);
            g.fillRect(x + zx, y, w - zx, h);
        } else {
            g.setColor(cols[zc]);
            g.fillRect(x, y + zx, w, h - zx);
        }
    }

    protected static class MonoMixVolumeShader
    extends RenderVolumeShader {
        protected Fader[][] c2f;

        public void setOutputChannels(int chs) {
            super.setOutputChannels(chs);
            this.linkChannelsWithFaders();
        }

        public void setFaders(Fader[] faders) {
            super.setFaders(faders);
            this.linkChannelsWithFaders();
            this.initVolume = this.computeMonoInitVolume();
        }

        protected void linkChannelsWithFaders() {
            Fader[] faders;
            int channels = this.chs;
            if (this.c2f == null || this.c2f.length != channels) {
                this.c2f = new Fader[channels][];
            }
            int faderCount = (faders = this.getFaders()) == null ? 0 : faders.length;
            Fader[] temp = new Fader[faderCount];
            int mask = 1;
            for (int k = 0; k < channels; ++k) {
                Fader[] arr;
                int num = 0;
                for (int i = 0; i < faderCount; ++i) {
                    Fader fader = faders[i];
                    if (fader == null || (fader.mask & mask) != 0) continue;
                    temp[num++] = fader;
                }
                if (num < 1) {
                    arr = NO_FADERS;
                } else if (num == faderCount) {
                    arr = faders;
                } else {
                    arr = new Fader[num];
                    System.arraycopy(temp, 0, arr, 0, num);
                }
                this.c2f[k] = arr;
                mask <<= 1;
            }
        }

        protected double computeMonoInitVolume() {
            double sum = 0.0;
            for (int k = 0; k < this.chs; ++k) {
                Fader[] arr = this.c2f[k];
                int num = arr.length;
                double v = 1.0;
                int i = 0;
                while (i < num) {
                    v *= arr[i++].getInitVolume();
                }
                sum += v;
            }
            return sum / (double)this.chs;
        }

        protected double volume() {
            double sum = 0.0;
            for (int k = 0; k < this.chs; ++k) {
                Fader[] arr = this.c2f[k];
                int num = arr.length;
                double v = 1.0;
                int i = 0;
                while (i < num) {
                    v *= arr[i++].volume;
                }
                sum += v;
            }
            return sum / (double)this.chs;
        }
    }

    protected static class RenderVolumeShader
    extends VolumeShaderBase
    implements VolumeShader {
        protected double vol;
        protected QueueState state = new QueueState();

        public double getVolume() {
            return this.vol;
        }

        public void setVolume(double v) {
            this.vol = v;
        }

        public double getVelocity() {
            return 0.0;
        }

        public void setVelocity(double vel) {
        }

        public void produce(long time, int frames) {
            throw new UnsupportedOperationException();
        }

        public void setEventQueueSize(int eventQueueSize) {
            super.setEventQueueSize(eventQueueSize);
            this.state.evt = this.evt;
            this.state.evp = this.evp;
        }

        public void reset(double v) {
            this.vol = v;
        }

        public double seek() {
            this.vol = this.volume();
            return this.vol;
        }

        public boolean move(long time) {
            int idx;
            double v = this.volume();
            if (v == this.prev) {
                return false;
            }
            this.prev = v;
            if ((idx = this.tail++) < this.queueSize) {
                this.evt[idx] = time;
                this.evp[idx] = v;
            }
            return true;
        }

        protected QueueState getQueueState() {
            this.state.tail = this.tail;
            return this.state;
        }

        protected void clearQueue() {
            this.tail = 0;
            this.prev = -1.0;
        }
    }

    protected static class QueueState {
        protected long[] evt;
        protected double[] evp;
        protected int tail;

        protected QueueState() {
        }
    }
}

