/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.view.old;

import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineModel;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.view.old.LineModelRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public abstract class AbstractModelRenderer
implements LineModelRenderer {
    protected Rectangle bounds;
    protected int orient;
    protected boolean horiz;
    protected double pps;
    protected LineChunk lineChunk;
    protected LineModel lineModel;
    protected double ups;
    protected double upp;

    @Override
    public LineChunk getLineChunk() {
        return this.lineChunk;
    }

    protected void setLineChunk(LineChunk lineChunk) {
        this.lineChunk = lineChunk;
        if (lineChunk == null) {
            this.lineModel = null;
            this.ups = 1.0;
        } else {
            LineModel model;
            this.lineModel = model = lineChunk.getLineModel();
            this.ups = model == null ? 1.0 : (double)model.getUnitRate();
        }
        this.computeFramesPerPixel();
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    @Override
    public int getOrientation() {
        return this.orient;
    }

    @Override
    public void setOrientation(int orientation) {
        this.orient = orientation;
        this.horiz = orientation == 0 || orientation == 1;
    }

    @Override
    public double getZoomRate() {
        return this.pps;
    }

    @Override
    public void setZoomRate(double zoomRate) {
        this.pps = zoomRate;
        this.computeFramesPerPixel();
    }

    protected void computeFramesPerPixel() {
        this.upp = this.ups / this.pps;
    }

    protected void paintError(Graphics2D g, int rx, int ry, int rw, int rh) {
        g.setColor(Color.RED);
        g.drawLine(rx, ry, rx + rw, ry + rh);
        g.drawLine(rx, ry + rh, rx + rw, ry);
    }

    @Override
    public void paint(Graphics2D g, Rectangle r) {
        int num;
        long fpx;
        LineChunk chunk = this.lineChunk;
        if (chunk == null) {
            return;
        }
        LineModel model = this.lineModel;
        if (model == null) {
            return;
        }
        int rx = r.x;
        int ry = r.y;
        int rw = r.width;
        int rh = r.height;
        if (this.horiz) {
            fpx = rx;
            num = rw;
        } else {
            fpx = ry;
            num = rh;
        }
        long chunkOfs = chunk.getChunkOfs();
        long chunkLen = chunk.getChunkEnd() - chunkOfs;
        if (chunkLen < 1L) {
            return;
        }
        long fpo = LineUtil.getUnitOfs((long)chunkOfs, (double)this.pps) - fpx;
        if (fpo >= (long)num) {
            return;
        }
        long modelOfs = chunk.getModelOfs();
        long modelEnd = Math.min(chunk.getModelEnd(), modelOfs + chunkLen);
        if (modelEnd <= modelOfs) {
            return;
        }
        long unitOfs = (long)Math.ceil(LineUtil.getUnitPos((long)modelOfs, (double)this.ups));
        long unitEnd = (long)Math.floor(LineUtil.getUnitPos((long)modelEnd, (double)this.ups));
        long unitLen = Math.min(unitEnd, model.getUnitLength()) - unitOfs;
        if (unitLen < 1L) {
            return;
        }
        long tpo = Math.min((long)num, fpo + LineUtil.longDivide((long)unitLen, (double)this.upp));
        if (tpo < 1L) {
            return;
        }
        unitEnd = unitOfs + unitLen;
        if (fpo >= 0L) {
            if (tpo < (long)num) {
                num = (int)tpo;
            }
            fpx += fpo;
            num -= (int)fpo;
            if (this.horiz) {
                rx = (int)fpx;
                rw = num;
            } else {
                ry = (int)fpx;
                rh = num;
            }
        } else {
            unitOfs += LineUtil.longMultiply((long)(-fpo), (double)this.upp);
            if (tpo < (long)num) {
                num = (int)tpo;
                if (this.horiz) {
                    rw = num;
                } else {
                    rh = num;
                }
            }
        }
        this.paintModel(g, rx, ry, rw, rh, model, unitOfs, unitEnd, num);
    }

    protected abstract void paintModel(Graphics2D var1, int var2, int var3, int var4, int var5, LineModel var6, long var7, long var9, int var11);
}

