/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.view.old;

import com.waxmonster.model.LineChunk;
import com.waxmonster.model.TimecodeChunk;
import com.waxmonster.model.view.AbstractLineView;
import com.waxmonster.model.view.old.TimecodeLineView;
import com.waxmonster.model.view.old.TimecodeModelRenderer;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.logging.Logger;

public class DefaultTimecodeLineView
extends AbstractLineView
implements TimecodeLineView {
    private static final Logger logger = Logger.getLogger(DefaultTimecodeLineView.class.getName());
    private TimecodeChunk timecodeChunk;
    private TimecodeModelRenderer timecodeRenderer;
    private final Rectangle rect = new Rectangle();
    private final Rectangle clip = new Rectangle();

    public LineChunk getLineChunk() {
        return this.timecodeChunk;
    }

    @Override
    public TimecodeChunk getTimecodeChunk() {
        return this.timecodeChunk;
    }

    @Override
    public void setTimecodeChunk(TimecodeChunk timecodeChunk) {
        this.timecodeChunk = timecodeChunk;
        TimecodeModelRenderer renderer = this.timecodeRenderer;
        if (renderer != null) {
            renderer.setTimecodeChunk(timecodeChunk);
        }
    }

    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        TimecodeModelRenderer renderer = this.timecodeRenderer;
        if (renderer != null) {
            renderer.setBounds(bounds);
        }
    }

    @Override
    public void setOrientation(int orientation) {
        super.setOrientation(orientation);
        TimecodeModelRenderer renderer = this.timecodeRenderer;
        if (renderer != null) {
            renderer.setOrientation(orientation);
        }
    }

    @Override
    public void setZoomRate(double zoomRate) {
        super.setZoomRate(zoomRate);
        TimecodeModelRenderer renderer = this.timecodeRenderer;
        if (renderer != null) {
            renderer.setZoomRate(zoomRate);
        }
    }

    @Override
    public TimecodeModelRenderer getTimecodeRenderer() {
        return this.timecodeRenderer;
    }

    @Override
    public void setTimecodeRenderer(TimecodeModelRenderer timecodeRenderer) {
        this.timecodeRenderer = timecodeRenderer;
        this.refreshRenderer();
    }

    protected void refreshRenderer() {
        TimecodeModelRenderer renderer = this.timecodeRenderer;
        if (renderer == null) {
            return;
        }
        renderer.setBounds(this.bounds);
        renderer.setOrientation(this.orientation);
        renderer.setZoomRate(this.zoomRate);
        renderer.setTimecodeChunk(this.timecodeChunk);
    }

    public void paint(Graphics2D g) {
        Rectangle r;
        TimecodeModelRenderer renderer = this.timecodeRenderer;
        if (renderer == null) {
            return;
        }
        Rectangle clip = g.getClipBounds(this.clip);
        if (clip == null) {
            r = this.bounds;
        } else {
            DefaultTimecodeLineView.intersect(clip, this.bounds, this.rect);
            r = this.rect;
        }
        renderer.paint(g, r);
    }

    @Override
    public boolean isInverted() {
        return false;
    }

    @Override
    public void setInverted(boolean inverted) {
        if (inverted) {
            logger.warning("TODO setInverted: " + inverted);
        }
    }
}

