/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.view.old;

import com.waxmonster.model.LineModel;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.model.view.old.AbstractTimecodeModelRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PolyTimecodeModelRenderer
extends AbstractTimecodeModelRenderer {
    private static final Logger logger = Logger.getLogger(PolyTimecodeModelRenderer.class.getName());
    private double[] darr;
    private int[] iarr;
    private int[] sarr;
    private Color color = Color.BLACK;
    private boolean inverted = false;

    public PolyTimecodeModelRenderer(int initCapacity) {
        this.darr = new double[initCapacity];
        this.iarr = new int[initCapacity];
        this.sarr = new int[initCapacity];
        this.updateSequenceArray(this.sarr.length, this.orient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintModel(Graphics2D g, int rx, int ry, int rw, int rh, LineModel model, long unitOfs, long unitEnd, int numPix) {
        int i;
        double q;
        int ty;
        int tx;
        int len;
        boolean horiz;
        TimecodeModel tcModel = (TimecodeModel)model;
        double framePos = unitOfs;
        Rectangle bnd = this.bounds;
        int x = rx;
        int y = ry;
        int w = rw;
        int h = rh;
        long frameLen = tcModel.getFrameLength();
        switch (this.orient) {
            case 0: {
                horiz = true;
                len = w + 2;
                tx = x - 1;
                ty = bnd.y;
                break;
            }
            case 2: {
                horiz = false;
                len = h + 2;
                tx = bnd.x;
                ty = y - 1;
                break;
            }
            case 1: {
                this.paintError(g, rx, ry, rw, rh);
                return;
            }
            case 3: {
                this.paintError(g, rx, ry, rw, rh);
                return;
            }
            default: {
                return;
            }
        }
        if (framePos > (double)(frameLen - 1L)) {
            return;
        }
        if (framePos < 0.0) {
            int z = (int)(-framePos / this.upp);
            switch (this.orient) {
                case 0: {
                    tx += z;
                    break;
                }
                case 1: {
                    tx -= z;
                    break;
                }
                case 2: {
                    ty += z;
                    break;
                }
                case 3: {
                    ty -= z;
                }
            }
            framePos = 0.0;
        }
        if (framePos + (double)len * this.upp > (double)frameLen && (q = ((double)frameLen - framePos) / this.upp) > (double)(len = (int)q)) {
            ++len;
        }
        if (len < 1) {
            return;
        }
        if (len > this.darr.length) {
            this.darr = new double[len];
        }
        double[] v = this.darr;
        try {
            tcModel.getValues(framePos, this.upp, v, 0, len);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                String msg = "Failed to get samples: framePos=" + framePos + ", fpu=" + this.upp + ", num=" + len + ", frameLen=" + frameLen + ", Cause: " + e.getMessage();
                logger.log(Level.FINE, msg, e);
            }
            return;
        }
        if (len > this.iarr.length) {
            this.iarr = new int[len];
        }
        int[] val = this.iarr;
        int base = 0xA00000;
        if (this.inverted) {
            for (i = 0; i < len; ++i) {
                val[i] = base + (int)Math.round(v[i] * this.pps / 1000.0);
            }
        } else {
            for (i = 0; i < len; ++i) {
                val[i] = base - (int)Math.round(v[i] * this.pps / 1000.0);
            }
        }
        if (len > this.sarr.length) {
            this.updateSequenceArray(len, this.orient);
        }
        int[] seq = this.sarr;
        g.translate(tx, ty);
        try {
            g.setColor(this.color);
            if (horiz) {
                g.drawPolyline(seq, val, len);
            } else {
                g.drawPolyline(val, seq, len);
            }
        }
        finally {
            g.translate(-tx, -ty);
        }
    }

    @Override
    public void setOrientation(int orientation) {
        super.setOrientation(orientation);
        this.updateSequenceArray(this.sarr.length, orientation);
    }

    protected void updateSequenceArray(int len, int orient) {
        if (len > this.sarr.length) {
            this.sarr = new int[len];
        } else {
            len = this.sarr.length;
        }
        if (orient == 0 || orient == 2) {
            for (int i = 0; i < len; ++i) {
                this.sarr[i] = i;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                this.sarr[i] = -i;
            }
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }
}

