/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.view.old;

import com.waxmonster.fader.FaderCurve;
import com.waxmonster.model.FaderChunk;
import com.waxmonster.model.FaderModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.view.AbstractLineView;
import com.waxmonster.model.view.old.FaderLineView;
import com.waxmonster.model.view.old.FaderModelRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShadedFaderLineView
extends AbstractLineView
implements FaderLineView {
    private static final Logger logger = Logger.getLogger(ShadedFaderLineView.class.getName());
    private FaderChunk faderChunk;
    private Color[] colors;
    private float factor;
    private FaderCurve faderCurve;
    private float[] farr;

    public ShadedFaderLineView(int initCapacity, Color[] colors, FaderCurve faderCurve) {
        this.farr = new float[initCapacity];
        this.colors = colors;
        this.faderCurve = faderCurve;
        this.factor = colors.length - 1;
    }

    public LineChunk getLineChunk() {
        return this.faderChunk;
    }

    @Override
    public FaderChunk getFaderChunk() {
        return this.faderChunk;
    }

    @Override
    public void setFaderChunk(FaderChunk faderChunk) {
        this.faderChunk = faderChunk;
    }

    public void paint(Graphics2D g) {
        block29: {
            double frameEnd;
            double framePos;
            int ty;
            int tx;
            int len;
            boolean horiz;
            int h;
            int w;
            int y;
            int x;
            FaderChunk chunk = this.faderChunk;
            if (chunk == null) {
                return;
            }
            FaderModel model = chunk.getFaderModel();
            if (model == null) {
                return;
            }
            double frameRate = model.getFrameRate();
            double startFramePos = LineUtil.getUnitPos((long)chunk.getModelOfs(), (double)frameRate);
            double fpu = frameRate / this.zoomRate;
            int orient = this.orientation;
            Rectangle bnd = this.bounds;
            Rectangle clip = g.getClipBounds();
            if (clip == null) {
                x = bnd.x;
                y = bnd.y;
                w = bnd.width;
                h = bnd.height;
            } else {
                Rectangle r = bnd.intersection(clip);
                x = r.x;
                y = r.y;
                w = r.width;
                h = r.height;
            }
            long frameLen = model.getFrameLength();
            switch (orient) {
                case 0: {
                    horiz = true;
                    len = w + 2;
                    tx = x - 1;
                    ty = bnd.y;
                    framePos = (double)(x - bnd.x - 1) * fpu - startFramePos;
                    h = bnd.height;
                    break;
                }
                case 1: {
                    horiz = true;
                    len = w + 2;
                    tx = x + w;
                    ty = bnd.y;
                    framePos = (double)frameLen - (double)(x - bnd.x - 1) * fpu - (double)len + startFramePos;
                    h = bnd.height;
                    break;
                }
                case 2: {
                    horiz = false;
                    len = h + 2;
                    tx = bnd.x;
                    ty = y - 1;
                    framePos = (double)(y - bnd.y - 1) * fpu - startFramePos;
                    w = bnd.width;
                    break;
                }
                case 3: {
                    horiz = false;
                    len = h + 2;
                    tx = bnd.x;
                    ty = y + h;
                    framePos = (double)frameLen - (double)(y - bnd.y - 1) * fpu - (double)len + startFramePos;
                    w = bnd.width;
                    break;
                }
                default: {
                    return;
                }
            }
            if (framePos > (double)(frameLen - 1L)) {
                return;
            }
            if (framePos < 0.0) {
                int z = (int)(-framePos / fpu);
                switch (orient) {
                    case 0: {
                        tx += z;
                        break;
                    }
                    case 1: {
                        tx -= z;
                        break;
                    }
                    case 2: {
                        ty += z;
                        break;
                    }
                    case 3: {
                        ty -= z;
                    }
                }
                framePos = 0.0;
            }
            if ((frameEnd = framePos + (double)len * fpu) > (double)frameLen) {
                len = (int)(((double)frameLen - framePos) / fpu);
            }
            if (len < 1) {
                return;
            }
            if (len > this.farr.length) {
                this.farr = new float[len];
            }
            float[] v = this.farr;
            try {
                Color col;
                model.getValues(framePos, fpu, v, 0, len);
                float val = v[0];
                int o = 0;
                g.translate(tx, ty);
                for (int i = 1; i < len; ++i) {
                    if (v[i] == val) continue;
                    if (i > o) {
                        col = this.getColor(val);
                        g.setColor(col);
                        if (horiz) {
                            g.fillRect(o, y, i - o, h);
                        } else {
                            g.fillRect(x, o, w, i - o);
                        }
                    }
                    val = v[i];
                    o = i;
                }
                col = this.getColor(val);
                g.setColor(col);
                if (horiz) {
                    g.fillRect(o, y, len - o, h);
                } else {
                    g.fillRect(x, o, w, len - o);
                }
                g.translate(-tx, -ty);
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block29;
                logger.log(Level.FINE, e.getMessage(), e);
            }
        }
    }

    protected Color getColor(float value) {
        float volume = this.faderCurve.getVolume(value);
        int i = (int)(volume * this.factor);
        if (i < 0) {
            i = 0;
        }
        if (i >= this.colors.length) {
            i = this.colors.length - 1;
        }
        return this.colors[i];
    }

    @Override
    public FaderModelRenderer getFaderRenderer() {
        return null;
    }

    @Override
    public void setFaderRenderer(FaderModelRenderer faderRenderer) {
    }
}

