/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.view.old;

import com.waxmonster.fader.FaderCurve;
import com.waxmonster.model.FaderChunk;
import com.waxmonster.model.FaderModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.TimecodeChunk;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.model.view.AbstractLineView;
import com.waxmonster.model.view.old.TimecodeLineView;
import com.waxmonster.model.view.old.TimecodeModelRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShadedTimecodeLineView
extends AbstractLineView
implements TimecodeLineView {
    private static final Logger logger = Logger.getLogger(ShadedTimecodeLineView.class.getName());
    private TimecodeChunk timecodeChunk;
    private boolean inverted = false;
    private FaderChunk faderChunk;
    private FaderCurve faderCurve;
    private double faderPerUnit = 1.0;
    private double faderFactor = 1.0;
    private int thickness = 1;
    private int thickPlus = 0;
    private int thickMinus = 0;
    private Color color = Color.RED;
    private Color[] colors;
    private float factor;
    private double[] darr;
    private float[] farr;

    public ShadedTimecodeLineView(int initCapacity, Color[] colors, FaderCurve faderCurve) {
        this.colors = colors;
        this.factor = colors.length - 1;
        this.faderCurve = faderCurve;
        this.darr = new double[initCapacity];
        this.farr = new float[initCapacity];
        this.setOrientation(0);
    }

    public LineChunk getLineChunk() {
        return this.timecodeChunk;
    }

    @Override
    public TimecodeChunk getTimecodeChunk() {
        return this.timecodeChunk;
    }

    @Override
    public void setTimecodeChunk(TimecodeChunk timecodeChunk) {
        this.timecodeChunk = timecodeChunk;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public boolean isInverted() {
        return this.inverted;
    }

    @Override
    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    @Override
    public void setZoomRate(double zoomRate) {
        super.setZoomRate(zoomRate);
        this.adjustFaderUnits();
    }

    public FaderChunk getFaderChunk() {
        return this.faderChunk;
    }

    public void setFaderChunk(FaderChunk faderChunk) {
        this.faderChunk = faderChunk;
        this.adjustFaderUnits();
    }

    protected void adjustFaderUnits() {
        FaderChunk fc = this.faderChunk;
        if (fc == null) {
            return;
        }
        FaderModel fm = fc.getFaderModel();
        if (fm == null) {
            return;
        }
        double faderRate = fm.getFrameRate();
        this.faderPerUnit = faderRate / this.zoomRate;
        TimecodeChunk tc = this.timecodeChunk;
        if (tc == null) {
            return;
        }
        TimecodeModel tm = tc.getTimecodeModel();
        if (tm == null) {
            return;
        }
        this.faderFactor = faderRate / (double)tm.getFrameRate();
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int thickness) {
        this.thickness = thickness;
        this.thickMinus = thickness / 2;
        this.thickPlus = thickness - this.thickMinus - 1;
    }

    public void paint(Graphics2D g) {
        block38: {
            double frameEnd;
            double framePos;
            int ty;
            int tx;
            int len;
            boolean horiz;
            int h;
            int w;
            int y;
            int x;
            TimecodeChunk chunk = this.timecodeChunk;
            if (chunk == null) {
                return;
            }
            TimecodeModel model = chunk.getTimecodeModel();
            if (model == null) {
                return;
            }
            double frameRate = model.getFrameRate();
            double startFramePos = LineUtil.getUnitPos((long)chunk.getModelOfs(), (double)frameRate);
            double fpu = frameRate / this.zoomRate;
            double tpu = 1000.0 / this.zoomRate;
            int orient = this.orientation;
            Rectangle bnd = this.bounds;
            Rectangle clip = g.getClipBounds();
            if (clip == null) {
                x = bnd.x;
                y = bnd.y;
                w = bnd.width;
                h = bnd.height;
            } else {
                Rectangle r = bnd.intersection(clip);
                x = r.x;
                y = r.y;
                w = r.width;
                h = r.height;
            }
            long frameLen = model.getFrameLength();
            switch (orient) {
                case 0: {
                    horiz = true;
                    len = w + 2;
                    tx = x - 1;
                    ty = bnd.y;
                    framePos = (double)(x - bnd.x - 1) * fpu - startFramePos;
                    break;
                }
                case 1: {
                    horiz = true;
                    len = w + 2;
                    tx = x + w;
                    ty = bnd.y;
                    framePos = (double)frameLen - (double)(x - bnd.x - 1) * fpu - (double)len + startFramePos;
                    break;
                }
                case 2: {
                    horiz = false;
                    len = h + 2;
                    tx = bnd.x;
                    ty = y - 1;
                    framePos = (double)(y - bnd.y - 1) * fpu - startFramePos;
                    break;
                }
                case 3: {
                    horiz = false;
                    len = h + 2;
                    tx = bnd.x;
                    ty = y + h;
                    framePos = (double)frameLen - (double)(y - bnd.y - 1) * fpu - (double)len + startFramePos;
                    break;
                }
                default: {
                    return;
                }
            }
            if (framePos > (double)(frameLen - 1L)) {
                return;
            }
            if (framePos < 0.0) {
                int z = (int)(-framePos / fpu);
                switch (orient) {
                    case 0: {
                        tx += z;
                        break;
                    }
                    case 1: {
                        tx -= z;
                        break;
                    }
                    case 2: {
                        ty += z;
                        break;
                    }
                    case 3: {
                        ty -= z;
                    }
                }
                framePos = 0.0;
            }
            if ((frameEnd = framePos + (double)len * fpu) > (double)frameLen) {
                len = (int)(((double)frameLen - framePos) / fpu);
            }
            if (len < 1) {
                return;
            }
            if (len > this.darr.length) {
                this.darr = new double[len];
                this.farr = new float[len];
            }
            double[] v = this.darr;
            float[] f = this.farr;
            try {
                FaderModel fm;
                model.getValues(framePos, fpu, v, 0, len);
                int num = 0;
                float zf = 0.0f;
                FaderChunk fc = this.faderChunk;
                if (fc != null && (fm = fc.getFaderModel()) != null) {
                    double faderPos = framePos * this.faderFactor;
                    num = len;
                    double faderEnd = faderPos + (double)num * this.faderPerUnit;
                    long faderLen = fm.getFrameLength();
                    if (faderEnd > (double)faderLen) {
                        num = (int)(((double)faderLen - faderPos) / this.faderPerUnit);
                        if (faderLen > 0L) {
                            fm.get(faderLen - 1L, f, 0, 1);
                            zf = f[0];
                        }
                    }
                    if (num > 0) {
                        fm.getValues(faderPos, this.faderPerUnit, f, 0, num);
                    } else {
                        num = 0;
                    }
                }
                int base = 0xA00000;
                double divisor = this.inverted ? tpu : -tpu;
                int m = base + (int)Math.round(v[0] / divisor);
                float u = -34534.0f;
                Color col = this.color;
                g.setColor(col);
                g.translate(tx, ty);
                for (int i = 0; i < len; ++i) {
                    int p2;
                    int p1;
                    Color clr;
                    int p = base + (int)Math.round(v[i] / divisor);
                    if (i < num) {
                        if (u != f[i] && (clr = this.getColor(u = f[i])) != col) {
                            col = clr;
                            g.setColor(col);
                        }
                    } else if (u != zf) {
                        u = zf;
                        clr = this.getColor(zf);
                        if (clr != col) {
                            col = clr;
                            g.setColor(col);
                        }
                    }
                    if (p > m) {
                        p1 = m - this.thickMinus;
                        p2 = p + this.thickPlus;
                    } else {
                        p1 = p - this.thickMinus;
                        p2 = m + this.thickPlus;
                    }
                    if (horiz) {
                        g.drawLine(i, p1, i, p2);
                    } else {
                        g.drawLine(p1, i, p2, i);
                    }
                    m = p;
                }
                g.translate(-tx, -ty);
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block38;
                logger.log(Level.FINE, e.getMessage(), e);
            }
        }
    }

    protected Color getColor(float value) {
        float volume = this.faderCurve.getVolume(value);
        int i = (int)(volume * this.factor);
        if (i < 0) {
            i = 0;
        }
        if (i >= this.colors.length) {
            i = this.colors.length - 1;
        }
        return this.colors[i];
    }

    @Override
    public TimecodeModelRenderer getTimecodeRenderer() {
        return null;
    }

    @Override
    public void setTimecodeRenderer(TimecodeModelRenderer timecodeRenderer) {
    }
}

