/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.AbstractRawSampleBuffer;
import com.spacekiller.util.sound.ByteArraySampleBuffer;
import com.spacekiller.util.sound.SampleType;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;

public abstract class AbstractByteArraySampleBuffer
extends AbstractRawSampleBuffer
implements ByteArraySampleBuffer {
    protected final byte[] arr;
    protected final int byteLen;

    public AbstractByteArraySampleBuffer(int channels, float frameRate, int samples, SampleType sampleType, byte[] arr) {
        super(channels, frameRate, samples, sampleType);
        this.arr = arr;
        this.byteLen = samples * this.sampleSize;
    }

    @Override
    public final byte[] array() {
        return this.arr;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public int getByteLength() {
        return this.byteLen;
    }

    @Override
    public void read(int o, byte[] dst, int off, int len) {
        System.arraycopy(this.arr, o, dst, off, len);
    }

    @Override
    public void write(int o, byte[] src, int off, int len) {
        System.arraycopy(src, off, this.arr, o, len);
    }

    @Override
    public void read(int o, ByteBuffer dst, int len) {
        dst.put(this.arr, o, len);
    }

    @Override
    public void write(int o, ByteBuffer src, int len) {
        src.get(this.arr, o, len);
    }

    @Override
    public int read(int o, WritableByteChannel dst, int len) throws IOException {
        return dst.write(ByteBuffer.wrap(this.arr, o, len));
    }

    @Override
    public int write(int o, ReadableByteChannel src, int len) throws IOException {
        return src.read(ByteBuffer.wrap(this.arr, o, len));
    }

    @Override
    public void read(int o, OutputStream dst, int len) throws IOException {
        dst.write(this.arr, o, len);
    }

    @Override
    public void read(int o, RandomAccessFile dst, int len) throws IOException {
        dst.write(this.arr, o, len);
    }

    @Override
    public int write(int o, InputStream src, int len) throws IOException {
        return src.read(this.arr, o, len);
    }

    @Override
    public void writeFully(int o, InputStream src, int len) throws IOException {
        int n = src.read(this.arr, o, len);
        if (n < len) {
            if (n < 0) {
                throw new EOFException();
            }
            o += n;
            len -= n;
            do {
                if ((n = src.read(this.arr, o, len)) < 0) {
                    throw new EOFException();
                }
                o += n;
            } while ((len -= n) > 0);
        }
    }

    @Override
    public int write(int o, RandomAccessFile src, int len) throws IOException {
        return src.read(this.arr, o, len);
    }

    @Override
    public void writeFully(int o, RandomAccessFile src, int len) throws IOException {
        src.readFully(this.arr, o, len);
    }

    @Override
    public void clear(int i, int len) {
        int x = i * this.sampleSize;
        Arrays.fill(this.arr, x, x + len * this.sampleSize, (byte)0);
    }
}

