/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.AbstractSampleBuffer;
import com.spacekiller.util.sound.RawSampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleType;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public abstract class AbstractRawSampleBuffer
extends AbstractSampleBuffer
implements RawSampleBuffer {
    protected final SampleType sampleType;
    protected final int sampleSize;

    public AbstractRawSampleBuffer(int channels, float frameRate, int samples, SampleType sampleType) {
        super(channels, samples, frameRate);
        this.sampleType = sampleType;
        this.sampleSize = sampleType.getSampleSize();
    }

    @Override
    public SampleType getSampleType() {
        return this.sampleType;
    }

    @Override
    public int getSampleSize() {
        return this.sampleSize;
    }

    protected abstract double getD(int var1);

    protected abstract float getF(int var1);

    protected abstract void setD(int var1, double var2);

    protected abstract void setF(int var1, float var2);

    protected void addD(int o, double v) {
        this.setD(o, this.getD(o) + v);
    }

    protected void addF(int o, float v) {
        this.setD(o, this.getD(o) + (double)v);
    }

    @Override
    public double getDouble(int i) {
        return this.getD(i * this.sampleSize);
    }

    @Override
    public void set(int i, double v) {
        this.setD(i * this.sampleSize, v);
    }

    @Override
    public float getFloat(int i) {
        return this.getF(i * this.sampleSize);
    }

    @Override
    public void set(int i, float v) {
        this.setF(i * this.sampleSize, v);
    }

    @Override
    public void get(int i, double[] dst, int off, int len) {
        int o = i * this.sampleSize;
        int end = off + len;
        while (off < end) {
            dst[off++] = this.getD(o);
            o += this.sampleSize;
        }
    }

    @Override
    public void set(int i, double[] src, int off, int len) {
        int o = i * this.sampleSize;
        int end = off + len;
        while (off < end) {
            this.setD(o, src[off++]);
            o += this.sampleSize;
        }
    }

    @Override
    public void get(int i, float[] dst, int off, int len) {
        int o = i * this.sampleSize;
        int end = off + len;
        while (off < end) {
            dst[off++] = this.getF(o);
            o += this.sampleSize;
        }
    }

    @Override
    public void set(int i, float[] src, int off, int len) {
        int o = i * this.sampleSize;
        int end = off + len;
        while (off < end) {
            this.setF(o, src[off++]);
            o += this.sampleSize;
        }
    }

    @Override
    public void get(int i, DoubleBuffer dst, int len) {
        int o;
        int z = o + len * this.sampleSize;
        for (o = i * this.sampleSize; o < z; o += this.sampleSize) {
            dst.put(this.getD(o));
        }
    }

    @Override
    public void set(int i, DoubleBuffer src, int len) {
        int o;
        int z = o + len * this.sampleSize;
        for (o = i * this.sampleSize; o < z; o += this.sampleSize) {
            this.setD(o, src.get());
        }
    }

    @Override
    public void get(int i, FloatBuffer dst, int len) {
        int o;
        int z = o + len * this.sampleSize;
        for (o = i * this.sampleSize; o < z; o += this.sampleSize) {
            dst.put(this.getF(o));
        }
    }

    @Override
    public void set(int i, FloatBuffer src, int len) {
        int o;
        int z = o + len * this.sampleSize;
        for (o = i * this.sampleSize; o < z; o += this.sampleSize) {
            this.setF(o, src.get());
        }
    }

    @Override
    public void set(int i, SampleBuffer src, int off, int len) {
        int o;
        int z = o + len * this.sampleSize;
        for (o = i * this.sampleSize; o < z; o += this.sampleSize) {
            this.setD(o, src.getDouble(off++));
        }
    }

    @Override
    public void clear(int i, int len) {
        int o;
        int z = o + len * this.sampleSize;
        for (o = i * this.sampleSize; o < z; o += this.sampleSize) {
            this.setD(o, 0.0);
        }
    }

    @Override
    public void fill(int i, int len, double v) {
        int o;
        int z = o + len * this.sampleSize;
        for (o = i * this.sampleSize; o < z; o += this.sampleSize) {
            this.setD(o, v);
        }
    }

    @Override
    public void fill(int i, int len, float v) {
        int o;
        int z = o + len * this.sampleSize;
        for (o = i * this.sampleSize; o < z; o += this.sampleSize) {
            this.setF(o, v);
        }
    }

    @Override
    public void multiply(int i, int len, double v) {
        int o;
        int z = o + len * this.sampleSize;
        for (o = i * this.sampleSize; o < z; o += this.sampleSize) {
            this.setD(o, this.getD(o) * v);
        }
    }

    @Override
    public void multiply(int i, int len, float v) {
        int o;
        int z = o + len * this.sampleSize;
        for (o = i * this.sampleSize; o < z; o += this.sampleSize) {
            this.setF(o, this.getF(o) * v);
        }
    }

    @Override
    public double minDouble(int i, int len) {
        if (len < 1) {
            return Double.NaN;
        }
        int o = i * this.sampleSize;
        int z = o + len * this.sampleSize;
        double r = this.getD(o);
        o += this.sampleSize;
        while (o < z) {
            double v = this.getD(o);
            if (v < r) {
                r = v;
            }
            o += this.sampleSize;
        }
        return r;
    }

    @Override
    public float minFloat(int i, int len) {
        if (len < 1) {
            return Float.NaN;
        }
        int o = i * this.sampleSize;
        int z = o + len * this.sampleSize;
        float r = this.getF(o);
        o += this.sampleSize;
        while (o < z) {
            float v = this.getF(o);
            if (v < r) {
                r = v;
            }
            o += this.sampleSize;
        }
        return r;
    }

    @Override
    public double maxDouble(int i, int len) {
        if (len < 1) {
            return Double.NaN;
        }
        int o = i * this.sampleSize;
        int z = o + len * this.sampleSize;
        double r = this.getD(o);
        o += this.sampleSize;
        while (o < z) {
            double v = this.getD(o);
            if (v > r) {
                r = v;
            }
            o += this.sampleSize;
        }
        return r;
    }

    @Override
    public float maxFloat(int i, int len) {
        if (len < 1) {
            return Float.NaN;
        }
        int o = i * this.sampleSize;
        int z = o + len * this.sampleSize;
        float r = this.getF(o);
        o += this.sampleSize;
        while (o < z) {
            float v = this.getF(o);
            if (v > r) {
                r = v;
            }
            o += this.sampleSize;
        }
        return r;
    }

    @Override
    public double peakDouble(int i, int len) {
        double max;
        if (len < 1) {
            return Double.NaN;
        }
        int o = i * this.sampleSize;
        int z = o + len * this.sampleSize;
        double min = max = this.getD(o);
        o += this.sampleSize;
        while (o < z) {
            double v = this.getD(o);
            if (v > max) {
                max = v;
            } else if (v < min) {
                min = v;
            }
            o += this.sampleSize;
        }
        return Math.abs(min) > max ? min : max;
    }

    @Override
    public float peakFloat(int i, int len) {
        float max;
        if (len < 1) {
            return Float.NaN;
        }
        int o = i * this.sampleSize;
        int z = o + len * this.sampleSize;
        float min = max = this.getF(o);
        o += this.sampleSize;
        while (o < z) {
            float v = this.getF(o);
            if (v > max) {
                max = v;
            } else if (v < min) {
                min = v;
            }
            o += this.sampleSize;
        }
        return Math.abs(min) > max ? min : max;
    }

    @Override
    public void add(int i, double v) {
        this.addD(i * this.sampleSize, v);
    }

    @Override
    public void add(int i, float v) {
        this.addF(i * this.sampleSize, v);
    }

    @Override
    public void add(int i, double[] src, int off, int len) {
        int o = i * this.sampleSize;
        int end = off + len;
        while (off < end) {
            this.addD(o, src[off++]);
            o += this.sampleSize;
        }
    }

    @Override
    public void add(int i, float[] src, int off, int len) {
        int o = i * this.sampleSize;
        int end = off + len;
        while (off < end) {
            this.addF(o, src[off++]);
            o += this.sampleSize;
        }
    }
}

