/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.SampleBuffer;

public abstract class AbstractSampleBuffer
implements SampleBuffer {
    protected final int channels;
    protected final int samples;
    protected final float frameRate;

    public AbstractSampleBuffer(int channels, int samples, float frameRate) {
        if (channels < 1) {
            throw new IllegalArgumentException("Invalid number of channels: " + channels);
        }
        if (samples < 1) {
            throw new IllegalArgumentException("Invalid number of samples: " + samples);
        }
        if (frameRate <= 0.0f) {
            throw new IllegalArgumentException("Invalid frame rate: " + frameRate);
        }
        this.channels = channels;
        this.samples = samples;
        this.frameRate = frameRate;
    }

    @Override
    public final int getChannels() {
        return this.channels;
    }

    @Override
    public final int getSamples() {
        return this.samples;
    }

    @Override
    public final float getFrameRate() {
        return this.frameRate;
    }

    public String toString() {
        return super.toString() + "[channels=" + this.channels + ", rate=" + this.frameRate + ", samples=" + this.samples + "]";
    }
}

