/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.SampleModel;

public abstract class AbstractSampleModel
implements SampleModel {
    protected final int channels;
    protected final float frameRate;

    public AbstractSampleModel(int channels, float frameRate) {
        if (channels < 1) {
            throw new IllegalArgumentException("Invalid number of channels: " + channels);
        }
        if (frameRate <= 0.0f) {
            throw new IllegalArgumentException("Invalid frame rate: " + frameRate);
        }
        this.channels = channels;
        this.frameRate = frameRate;
    }

    @Override
    public final int getChannels() {
        return this.channels;
    }

    @Override
    public final float getFrameRate() {
        return this.frameRate;
    }

    public String toString() {
        return super.toString() + "[channels=" + this.channels + ", rate=" + this.frameRate + ", samples=" + this.getSamples() + "]";
    }
}

