/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

public class AudioFileReaderWrapper
extends AudioFileReader {
    private static final Logger logger = Logger.getLogger(AudioFileReaderWrapper.class.getName());
    private AudioFileReader reader;

    protected AudioFileReaderWrapper() {
    }

    public AudioFileReaderWrapper(AudioFileReader reader) {
        this();
        this.reader = reader;
    }

    protected void handleException(Throwable e) throws UnsupportedAudioFileException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            String msg = "Audio reader '" + this.reader + "' failed: " + e;
            logger.finer(msg);
        }
    }

    @Override
    public AudioFileFormat getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        AudioFileReader r = this.reader;
        if (r == null) {
            throw new UnsupportedAudioFileException();
        }
        try {
            return r.getAudioFileFormat(stream);
        }
        catch (UnsupportedAudioFileException e) {
            this.handleException(e);
            throw e;
        }
        catch (IOException e) {
            this.handleException(e);
            throw e;
        }
        catch (Throwable e) {
            this.handleException(e);
            throw new UnsupportedAudioFileException("" + e);
        }
    }

    @Override
    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        AudioFileReader r = this.reader;
        if (r == null) {
            throw new UnsupportedAudioFileException();
        }
        try {
            return r.getAudioFileFormat(url);
        }
        catch (UnsupportedAudioFileException e) {
            this.handleException(e);
            throw e;
        }
        catch (IOException e) {
            this.handleException(e);
            throw e;
        }
        catch (Throwable e) {
            this.handleException(e);
            throw new UnsupportedAudioFileException("" + e);
        }
    }

    @Override
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileReader r = this.reader;
        if (r == null) {
            throw new UnsupportedAudioFileException();
        }
        try {
            return r.getAudioFileFormat(file);
        }
        catch (UnsupportedAudioFileException e) {
            this.handleException(e);
            throw e;
        }
        catch (IOException e) {
            this.handleException(e);
            throw e;
        }
        catch (Throwable e) {
            this.handleException(e);
            throw new UnsupportedAudioFileException("" + e);
        }
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        AudioFileReader r = this.reader;
        if (r == null) {
            throw new UnsupportedAudioFileException();
        }
        try {
            return r.getAudioInputStream(stream);
        }
        catch (UnsupportedAudioFileException e) {
            this.handleException(e);
            throw e;
        }
        catch (IOException e) {
            this.handleException(e);
            throw e;
        }
        catch (Throwable e) {
            this.handleException(e);
            throw new UnsupportedAudioFileException("" + e);
        }
    }

    @Override
    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        AudioFileReader r = this.reader;
        if (r == null) {
            throw new UnsupportedAudioFileException();
        }
        try {
            return r.getAudioInputStream(url);
        }
        catch (UnsupportedAudioFileException e) {
            this.handleException(e);
            throw e;
        }
        catch (IOException e) {
            this.handleException(e);
            throw e;
        }
        catch (Throwable e) {
            this.handleException(e);
            throw new UnsupportedAudioFileException("" + e);
        }
    }

    @Override
    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileReader r = this.reader;
        if (r == null) {
            throw new UnsupportedAudioFileException();
        }
        try {
            return r.getAudioInputStream(file);
        }
        catch (UnsupportedAudioFileException e) {
            this.handleException(e);
            throw e;
        }
        catch (IOException e) {
            this.handleException(e);
            throw e;
        }
        catch (Throwable e) {
            this.handleException(e);
            throw new UnsupportedAudioFileException("" + e);
        }
    }

    public String toString() {
        return super.toString() + "[reader=" + this.reader + "]";
    }

    protected AudioFileReader getReader() {
        return this.reader;
    }

    protected void setReader(AudioFileReader reader) {
        this.reader = reader;
    }
}

