/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.AudioMath;
import com.spacekiller.util.sound.FFT;
import com.spacekiller.util.sound.FFTImpl;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleModel;
import java.io.IOException;

public class AudioMathImpl
implements AudioMath {
    private static final double LOG10 = StrictMath.log(10.0);

    @Override
    public FFT getFFT(int frames) {
        return new FFTImpl(frames);
    }

    @Override
    public double rms(SampleBuffer sb, int channel) {
        int nc = sb.getChannels();
        int frames = sb.getSamples() / nc;
        int ofs = channel;
        double ms = 0.0;
        for (int i = 0; i < frames; ++i) {
            double v = sb.getDouble(ofs);
            ms += v * v;
            ofs += nc;
        }
        return Math.sqrt(ms / (double)frames);
    }

    @Override
    public double rms(SampleModel sm, int channel) throws IOException {
        int nc = sm.getChannels();
        long frames = sm.getSamples() / (long)nc;
        long ofs = channel;
        double ms = 0.0;
        for (long i = 0L; i < frames; ++i) {
            double v = sm.getDouble(ofs);
            ms += v * v;
            ofs += (long)nc;
        }
        return Math.sqrt(ms / (double)frames);
    }

    @Override
    public double rms(SampleModel sm, int channel, long ofs, long len) throws IOException {
        int nc = sm.getChannels();
        ofs = ofs * (long)nc + (long)channel;
        double ms = 0.0;
        for (long i = 0L; i < len; ++i) {
            double v = sm.getDouble(ofs);
            ms += v * v;
            ofs += (long)nc;
        }
        return Math.sqrt(ms / (double)len);
    }

    @Override
    public double rms2Decibel(double rms) {
        return Double.isNaN(rms) || rms <= 0.0 ? Double.NaN : StrictMath.log(rms) * 20.0 / LOG10;
    }

    @Override
    public double decibel2Rms(double decibel) {
        return Double.isNaN(decibel) ? Double.NaN : StrictMath.exp(decibel * LOG10 / 20.0);
    }
}

