/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.AbstractSampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class ChannelSampleBuffer
extends AbstractSampleBuffer {
    private final SampleBuffer buf;
    private final int ci;
    private final int nc;

    public ChannelSampleBuffer(SampleBuffer buf, int channel) {
        super(1, ChannelSampleBuffer.computeSamples(buf, channel), buf.getFrameRate());
        this.ci = channel;
        this.nc = buf.getChannels();
        this.buf = buf;
        if (this.ci < 0) {
            throw new IllegalArgumentException("Invalid channel index: " + this.ci + " < 0");
        }
        if (this.ci >= this.nc) {
            throw new IllegalArgumentException("Invalid channel index: " + this.ci + " >= " + this.nc);
        }
    }

    private static int computeSamples(SampleBuffer buf, int channel) {
        int channels = buf.getChannels();
        int total = buf.getSamples();
        int samples = total / channels;
        if (samples * channels + channel < total) {
            ++samples;
        }
        return samples;
    }

    @Override
    public boolean isReadOnly() {
        return this.buf.isReadOnly();
    }

    @Override
    public double getDouble(int i) {
        return this.buf.getDouble(i * this.nc + this.ci);
    }

    @Override
    public float getFloat(int i) {
        return this.buf.getFloat(i * this.nc + this.ci);
    }

    @Override
    public void set(int i, double v) {
        this.buf.set(i * this.nc + this.ci, v);
    }

    @Override
    public void set(int i, float v) {
        this.buf.set(i * this.nc + this.ci, v);
    }

    @Override
    public void get(int i, double[] dst, int off, int len) {
        int x = i * this.nc + this.ci;
        int end = off + len;
        while (off < end) {
            dst[off++] = this.buf.getDouble(x);
            x += this.nc;
        }
    }

    @Override
    public void get(int i, float[] dst, int off, int len) {
        int x = i * this.nc + this.ci;
        int end = off + len;
        while (off < end) {
            dst[off++] = this.buf.getFloat(x);
            x += this.nc;
        }
    }

    @Override
    public void set(int i, double[] src, int off, int len) {
        int x = i * this.nc + this.ci;
        int end = off + len;
        while (off < end) {
            this.buf.set(x, src[off++]);
            x += this.nc;
        }
    }

    @Override
    public void set(int i, float[] src, int off, int len) {
        int x = i * this.nc + this.ci;
        int end = off + len;
        while (off < end) {
            this.buf.set(x, src[off++]);
            x += this.nc;
        }
    }

    @Override
    public void get(int i, DoubleBuffer dst, int len) {
        int x = i * this.nc + this.ci;
        while (len-- > 0) {
            dst.put(this.buf.getDouble(x));
            x += this.nc;
        }
    }

    @Override
    public void get(int i, FloatBuffer dst, int len) {
        int x = i * this.nc + this.ci;
        while (len-- > 0) {
            dst.put(this.buf.getFloat(x));
            x += this.nc;
        }
    }

    @Override
    public void set(int i, DoubleBuffer src, int len) {
        int x = i * this.nc + this.ci;
        while (len-- > 0) {
            this.buf.set(x, src.get());
            x += this.nc;
        }
    }

    @Override
    public void set(int i, FloatBuffer src, int len) {
        int x = i * this.nc + this.ci;
        while (len-- > 0) {
            this.buf.set(x, src.get());
            x += this.nc;
        }
    }

    @Override
    public void set(int i, SampleBuffer src, int off, int len) {
        int x = i * this.nc + this.ci;
        int end = off + len;
        while (off < end) {
            this.buf.set(x, src.getDouble(off++));
            x += this.nc;
        }
    }

    @Override
    public void add(int i, double v) {
        this.buf.add(i * this.nc + this.ci, v);
    }

    @Override
    public void add(int i, float v) {
        this.buf.add(i * this.nc + this.ci, v);
    }

    @Override
    public void add(int i, double[] src, int off, int len) {
        int x = i * this.nc + this.ci;
        int end = off + len;
        while (off < end) {
            this.buf.add(x, src[off++]);
            x += this.nc;
        }
    }

    @Override
    public void add(int i, float[] src, int off, int len) {
        int x = i * this.nc + this.ci;
        int end = off + len;
        while (off < end) {
            this.buf.add(x, src[off++]);
            x += this.nc;
        }
    }

    @Override
    public void clear(int i, int len) {
        int x;
        int z = x + len * this.nc;
        for (x = i * this.nc + this.ci; x < z; x += this.nc) {
            this.buf.set(x, 0.0);
        }
    }

    @Override
    public void fill(int i, int len, double v) {
        int x;
        int z = x + len * this.nc;
        for (x = i * this.nc + this.ci; x < z; x += this.nc) {
            this.buf.set(x, v);
        }
    }

    @Override
    public void fill(int i, int len, float v) {
        int x;
        int z = x + len * this.nc;
        for (x = i * this.nc + this.ci; x < z; x += this.nc) {
            this.buf.set(x, v);
        }
    }

    @Override
    public void multiply(int i, int len, double v) {
        int x;
        int z = x + len * this.nc;
        for (x = i * this.nc + this.ci; x < z; x += this.nc) {
            this.buf.set(x, this.buf.getDouble(x) * v);
        }
    }

    @Override
    public void multiply(int i, int len, float v) {
        int x;
        int z = x + len * this.nc;
        for (x = i * this.nc + this.ci; x < z; x += this.nc) {
            this.buf.set(x, this.buf.getFloat(x) * v);
        }
    }

    @Override
    public double minDouble(int i, int len) {
        if (len < 1) {
            return Double.NaN;
        }
        int x = i * this.nc + this.ci;
        int z = x + len * this.nc;
        double r = this.buf.getDouble(x);
        x += this.nc;
        while (x < z) {
            double v = this.buf.getDouble(x);
            if (v < r) {
                r = v;
            }
            x += this.nc;
        }
        return r;
    }

    @Override
    public float minFloat(int i, int len) {
        if (len < 1) {
            return Float.NaN;
        }
        int x = i * this.nc + this.ci;
        int z = x + len * this.nc;
        float r = this.buf.getFloat(x);
        x += this.nc;
        while (x < z) {
            float v = this.buf.getFloat(x);
            if (v < r) {
                r = v;
            }
            x += this.nc;
        }
        return r;
    }

    @Override
    public double maxDouble(int i, int len) {
        if (len < 1) {
            return Double.NaN;
        }
        int x = i * this.nc + this.ci;
        int z = x + len * this.nc;
        double r = this.buf.getDouble(x);
        x += this.nc;
        while (x < z) {
            double v = this.buf.getDouble(x);
            if (v > r) {
                r = v;
            }
            x += this.nc;
        }
        return r;
    }

    @Override
    public float maxFloat(int i, int len) {
        if (len < 1) {
            return Float.NaN;
        }
        int x = i * this.nc + this.ci;
        int z = x + len * this.nc;
        float r = this.buf.getFloat(x);
        x += this.nc;
        while (x < z) {
            float v = this.buf.getFloat(x);
            if (v > r) {
                r = v;
            }
            x += this.nc;
        }
        return r;
    }

    @Override
    public double peakDouble(int i, int len) {
        double max;
        if (len < 1) {
            return Double.NaN;
        }
        int x = i * this.nc + this.ci;
        int z = x + len * this.nc;
        double min = max = this.buf.getDouble(x);
        x += this.nc;
        while (x < z) {
            double v = this.buf.getDouble(x);
            if (v > max) {
                max = v;
            } else if (v < min) {
                min = v;
            }
            x += this.nc;
        }
        return Math.abs(min) > max ? min : max;
    }

    @Override
    public float peakFloat(int i, int len) {
        float max;
        if (len < 1) {
            return Float.NaN;
        }
        int x = i * this.nc + this.ci;
        int z = x + len * this.nc;
        float min = max = this.buf.getFloat(x);
        x += this.nc;
        while (x < z) {
            float v = this.buf.getFloat(x);
            if (v > max) {
                max = v;
            } else if (v < min) {
                min = v;
            }
            x += this.nc;
        }
        return Math.abs(min) > max ? min : max;
    }
}

